-- under construction
-- libhttp ver. 0.5
-- you need 9lua
-- coded by Kenar (Kenji arisawa)

gen=require("gen")
xio=require("xio")

dprint = gen.dprint
split = gen.split
match = string.match
find = string.find
sub = string.sub
gsub = string.gsub
lower = string.lower
byte = string.byte
char = string.char

function dumfunc(...)
end


function aread(f,opt,quiet)
  local s,r
  p9.alarm(timeout)
  s,r = f:read(opt)
  p9.alarm(0)
  -- case s==nil must be returned, otherwise xfer will not work
  if r then
    if quiet then
      os.exit()
    end
    dprint("url: %s",url)
    print(f.fd,opt)
    error(r)
  end
  return s,r
end

function areadn(f,opt)
  local s,r
  p9.alarm(timeout)
  s,r = f:readn(opt)    
  p9.alarm(0)
  if r then
    dprint("url: %s",url)
    error(r)
  end
  return s,r
end

function areadln(f)
  local s,r
  p9.alarm(timeout)
  s,r = f:readln()
  p9.alarm(0)
  if r then
    dprint("url: %s",url)
    error(r)
  end
  return s,r
end

function awrite(f,opt)
  p9.alarm(timeout)
  s = f:write(opt)
  p9.alarm(0)
  if s == false then
    dprint("url: %s",url)
    error(r)
  end
  return s,r
end

function getheader(data)
  local size=4096
  local eoh = "\r\n\r\n"
  local s,t,p,q,r,h,b
  s,r = aread(data,size)
  if s == nil then
    os.exit()
  end
  -- reject junk request
  q = match(s,"^([A-Z]+)")
  if q == nil or magic[q] == nil then
    dprint("junk: %s",q)
    os.exit()
  end
  t = ""
  while s do
    -- dprint("#s:%d",#s)
    t = t .. s
    p,q = find(t,eoh,1,true)
    if p == nil then
      p,q = find(t,"\n\n",1,true) -- for servers out of RFC
    end
    if p then
      h = sub(t,1,q) -- header
      b = sub(t,q+1) -- body
      data:unread(b)
      return h
    end
    s,r = aread(data,size)
  end
  return s,r
end

function readchunkstr(chunk)
  -- dechunk: converts a chunked string to a regular string
  -- return: real data
  local m,r
  local n0,n1,n
  local n = 1
  local t = ""
  repeat
    n0,n1 = find(chunk,"\n",n)
    s = sub(chunk,n,n0-1)
    m = tonumber(s,16)
    if m == nil then
      dprint("readchunkstr: n=%d,n0=%d,%d,%s",n,n0,#s,s)
    end
    if m > 0 then
      s = sub(chunk,n1+1,n1+m+2)  -- include trailing CRLF
      if sub(s,-1) ~= "\n" then
        error("chunk")
      end
      t = t .. s
      n = n1+m+3
    end
  until m == 0
  -- xfer the extension
  s = sub(chunk,n)
  return t,s
end

function shapeup(s)
  local t = ""
  s = lower(s)
  gsub(s,"(%l+)([^%l]*)",function(a,b)
    t = t .. char(byte(sub(a,1,1)) - 32) .. sub(a,2) .. b
  end)
  return t
end

function mainfield(s)
  local t = {}
  gsub(s,"\n([%w-]+): *([^%c]*)",function(a,b)
    -- we have multiple "Set-Cookie:"
    -- field name is case insensitive.
    a = shapeup(a)
    if t[a] then
      t[a] = t[a].."\n"..b
    else
      t[a] = b
    end
  end)
  return t
end

function subfield(s)
  local t = {}
  gsub(s,"([%w-]+)=([^;%c]*)",function(a,b)
    a = lower(a)
    t[a] = b
  end)
  return t
end

function elower(s)
  if s == nil then
    return nil
  end
  return lower(s)
end

function getfields(h)
  local t,v,u,u0,u1,u2
  -- read a first line to u0,u1,u2
  u = match(h,"^([^%c]*)")
  gsub(u,"^([^%s]+) +([^%s]+) *([^ ]*)", function(a,b,c)
    u0 = a; u1 = b; u2 = c
  end)
  if u0 == nil or u1 == nil then
    error("header")
  end
  t = {}
  if sub(u0,1,4) == "HTTP" then
    t["_status"] = u1
    t["_reason"] = u2
  else -- as we have already checked magic
    t["_method"] = u0
    url = u1
    t["_path"] = gsub(u1,"^(http.?://[^/]+)","",1)
    -- look RFC2616
    -- now we spport https using trumpoline
  end
  v = match(u,"HTTP/([^ %c]+)")
  if v == nil then
    v = "1.0"
  end
  t["_ver"] = v
  -- read second and the following lines
  gsub(h,"\n([%w-]+): *([^%c]*)", function(a,b)
    a = shapeup(a)
    -- we have multiple "Set-Cookie:"
    if t[a] then
      t[a] = t[a].."\n"..b
    else
      t[a] = b
    end
  end)
  t["Transfer-Encoding"] = elower(t["Transfer-Encoding"])
  t["Connection"] = elower(t["Connection"])
  return t
end

function mklen(t)
  local len
  if t["Transfer-Encoding"] then
    return t["Transfer-Encoding"]
  end
  if t["Content-Length"] then
    return tonumber(t["Content-Length"])
  end
  --[[ taking care of buggy header brings other problems. don't uncomment.
     i.e. if uncomment, iTunes store will not be connected.
  if t["Connection"] == "close" then
    -- Some buggy CGIs include body without Content-Length
    -- even if they claim HTTP/1.1
    -- in case "Connection: close"
    return nil
  end
  --]]
  if t["_ver"] == "1.1" then
    -- REF2616:
    --   HTTP/1.1 requests containing a message-body MUST include
    --   a valid Content-Length header
    -- Kenar says: HTTP/1.1 without Content-Length includes no message body
    return 0
  end
  --[[
  Some servers respond "HTTP/1.0" with "Connection: Keep-Alive"
  but without "Content-Lenght". RFC says nothing on this case.
  I guess such servers want to be something like "HTTP/1.1".
  Thereby I return 0.
  --]]
  if t["_ver"] == "1.0" and t["Connection"] == "keep-alive" then
    return 0
  end
  return nil
end


function xferchunk(fd0,fd1)
  -- return: size of real data
  local s,m,r
  local n = 0
  repeat
    s,r = areadln(fd0)
    awrite(fd1,s)
    m = tonumber(s,16)
    if m > 0 then
      s = areadn(fd0,m+2)  -- include trailing CRLF
      if sub(s,-1) ~= "\n" then
        error("chunk")
      end
      awrite(fd1,s)
      xbprint("%s",s)
      n = n + #s -2
    end
  until m == 0
  -- xfer the extension
  s,r = areadln(fd0)
  awrite(fd1,s)
  return n
end

function xferbody(fd0,fd1,len)
  -- we return size of real data
  -- dprint("xferbody")
  local n = 0
  if len == nil then
    local size=4096
    local u
    u = aread(fd0,size)
    while u do
      awrite(fd1,u)
      xbprint("%s",s) -- show xfer data
      n = n + #u
      u = aread(fd0,size)
    end
    return n
  end
  if type(len) == "string" then
    local s,i,m,u,v
    if len ~= "chunked" then
      error("Transfer-Encoding")
    end
    -- dprint("--- Chunked ---")
    return n + xferchunk(fd0,fd1)
  end
  if len > 0 then
    -- the transfer data might be big
    local s
    local size = 16*1024
    local m = len
    while m > size do
      s = areadn(fd0,size)  -- #s == size
	  awrite(fd1,s)
      xbprint("%s",s) -- show xfer data
      n = n + #s
      m = m - #s
    end
    s = areadn(fd0,m)
	awrite(fd1,s)
    xbprint("%s",s)  -- show xfer data
    n = n + #s
  end
  if len ~= n then
    -- this case happens in the respose from HTTP/1.1 servers with buggy header
    -- no "Content-Length" with content of size n > 0
    dprint("size: %d %d",len,n)
    dprint("url: %s", url)
    error()
  end
  return n
end


                          -- configulation --

timeout_default = 60
timeout = timeout_default
xbprint = dumfunc


meth = "HTTP" -- not a methods but we must add this one
meth = meth .. "|OPTIONS|GET|HEAD|POST|PUT|DELETE|TRACE|CONNECT" -- RFC2616
meth = meth .. "|PROPFIND|MKCOL|COPY|MOVE|PROPPATCH|LOCK|UNLOCK" -- WebDAV(RFC4918)
-- NOTE: MacOSX WebDAV client bypasses the proxy setting though

-- magic is a set of starting word of request and response
-- they are required to make proxy robust
magic = {}
gsub(meth,"([%w]+)",function(a)
  magic[a] = true
end)

return {
	mklen=mklen,
	getheader=getheader,
	getfields=getfields,
	xferbody=xferbody,
	readchunkstr=readchunkstr,
	subfield=subfield
}
