-- under construction

-- libenc ver. 0.5
-- you need lua with plan9 extension
-- coded by Kenar (Kenji arisawa)

t64e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
bit = p9.bit
sub = string.sub
byte = string.byte

-- Ref: /sys/src/libc/port/u64.c
function enc64(s)
  local b24 = 0
  local out = ""
  for i=0,#s - 1 do
    b24 = bit(b24,"|",bit(byte(s,i+1),"<<",8 *(2 - i%3)))
    if i%3 == 2 then
      b1 = bit(b24,">>",18) + 1
      b2 = bit(bit(b24,">>",12),"&",0x3f) + 1
      b3 = bit(bit(b24,">>",6),"&",0x3f) + 1
      b4 = bit(b24,"&",0x3f) + 1
      out = out .. sub(t64e,b1,b1)..sub(t64e,b2,b2)..sub(t64e,b3,b3)..sub(t64e,b4,b4)
      b24 = 0
    end
  end
  r = #s % 3
  if r == 2 then
    b1 = bit(b24,">>",18) + 1
    b2 = bit(bit(b24,">>",12),"&",0x3f) + 1
    b3 = bit(bit(b24,">>",6),"&",0x3f) + 1
    out = out .. sub(t64e,b1,b1)..sub(t64e,b2,b2)..sub(t64e,b3,b3).."="
  elseif r == 1 then
    b1 = bit(b24,">>",18) + 1
    b2 = bit(bit(b24,">>",12),"&",0x3f) + 1
    out = out .. sub(t64e,b1,b1)..sub(t64e,b2,b2).."=="
  end
  return out
end

--[[
print(enc64(""))
print(enc64("a"))
print(enc64("ab"))
print(enc64("abc"))
print(enc64("abcd"))
print(enc64("abcde"))
--]]
