-- libdir ver. 1.1
-- lua ver. 5.2 compliant
-- you need 9lua
-- update: 2014/09/07
-- coded by Kenar (Kenji arisawa)

gen=require("gen")
sub = string.sub
gsub = string.gsub
match = string.match
format = string.format

dprint = gen.printf
split = str.split
date = gen.date
basename = gen.basename


function isdir(file)
  local d
  if type(file) == "string" then
    d = p9.dirstat(file)
  else
    d = file
  end
  if d == nil then -- if the file does not exist
    return false
  end
  -- d.mode is a string: 020000000755  in octal, directory
  if sub(d.mode,1,2) == "02" then
   return true
  end
  return false
end

function test(t,file)
  -- we support usage such as test("-drx",name)
  -- not perfect!
  local mode = {['e']=0, ["x"]=1, ["w"]=2, ["r"]=4}
  local d,u,m
  if #t < 2 then error("test: usage") end
  if sub(t,1,1) ~= "-" then error("syntax") end
  t = sub(t,2)

  d = nil
  m = 0
  while #t > 0 do
    u = sub(t,1,1)
    if u == "d" then
      d = isdir(file)
    elseif u == "f" then
      d = not isdir(file)
    elseif u == "e" then
      d = p9.dirstat(file)
    elseif u == "s" then
      d = (p9.dirstat(file).length > 0)
    else
      m = m + mode[u]
    end
    t = sub(t,2)
  end
  -- we allow one of "d","f","e","s" in t otherwise not supported
  if d == nil then
    return p9.access(file,m)
  else -- d is true or false or others
    if m == 0 then
      return d
    end
    -- we allow the combination only of "d" and "rwx"
    local user = os.getenv("user")
    -- assuming user is on uid or gid, may be too restrictive though
    local p
    d = p9.dirstat(file)
    if d.uid == user then
      p = "(.)..$"
    elseif d.gid == user then
      p = ".(.).$"
	else
      p = "..(.)$"
	end
    if p9.bit(match(d.mode,p),"&",m) == m then
        return true
    end
    return false
  end
end

function mkdirs(d)
  local s,t
  s = split(d,"/")
  t = ""
  for i,v in ipairs(s) do
    t = t .. v .. "/"
    if test("-e",t) == false then
      p9.mkdir(t)
    end
  end
end

function copy(sour,dest,overwrite)
	local f = io.open(sour)
    if overwrite == nil and test("-e",dest) then
      error(dest.." exists")
    end
	local g = io.open(dest,"w+")
	local size = 32*1024
	b = f:read(size)
	while b do
		g:write(b)
		b = f:read(size)
	end
    f:close()
    g:close()
end

function settime(tar,ref) -- tar,ref: file
  local d = p9.dirstat(ref)
  p9.dirwstat(tar,{mtime=d.mtime})
end

function cpdir(sour,dest)
    -- sour must be a dir
    -- dest must not exist but the parent must exist
	local files
	local d,f,s,sb,sd1,st,sb1
    if match(dest,sour) then
      error(sour.." is in "..dest)
    end
	files = p9.readdir(sour)
	sb = p9.dirstat(sour)
	p9.mkdir(dest,sb.mode)
	for k,v in pairs(files) do
		s = sour.."/"..k
		d = dest.."/"..k
		if test("-d",s) then
			st = cpdir(s,d)
		else
			st = copy(s,d)
			settime(d,s)
		end
	end
	settime(dest,sour)
end

function remove(path)
  -- remove path; the path is a file or a dir.
  local names,s,r
  if test("-d",path) then
    names = p9.readdir(path)
    for k,v in pairs(names) do
      if v then
        s,r = remove(path.."/"..k)
      else
        s,r = os.remove(path.."/"..k)
      end
      if s == nil then
        return s,r
      end
    end
  end
  -- here path is a file or a empty dir, so we can apply os.remove()
  return os.remove(path) -- something weired ??? cannot remove!
  -- the reply is "Invalid argument", probably nil.
end

function walkdir(path,fun1,fun2,depth)
  local names
  if depth < 0 then return end
  if test("-d",path) then
    -- print(path) -- DEBUG
    fun1(path)
    names = p9.readdir(path)
    if depth then depth = depth -1 end
    for k,v in pairs(names) do
      walkdir(path.."/"..k,fun1,fun2,depth)
    end
  else
    -- print(path) -- DEBUG
    fun2(path)
  end
end

function _lsdir(tab,path,depth)
  local names
  if depth and depth < 0 then return end
  -- dprint("_lsdir:",path)
  if test("-d",path) then
    -- dprint(path.."/")
    table.insert(tab,path.."/")
    names = p9.readdir(path)
    -- note that depth may be nil
    if depth then depth = depth -1 end -- the depth may be nil
    for k,v in pairs(names) do
      _lsdir(tab,path.."/"..k,depth)
    end
  elseif type("-e",path) then
    -- dprint(path)
    table.insert(tab,path)
  else
    error(path.." no such file")
  end
end

function lsdir(path,depth)
  local tab = {}
  _lsdir(tab,path,depth)
  return tab
end


-- used in webdav
-- we assume the name does not end with trailing "/"
function removable(path,flag)
  -- flag == true: the parent dir is confirmed writable
  local names,s,r,path0
  if not test("-e",path) then
    return nil
  end
  if not flag then
    path0 = basename(path) -- then path0 is parent dir
    if test("-w",path0) == false then
      return false,path
    end
  end
  if test("-f",path) then
    return true
  end
  -- all names under the path must be removable
  -- it is enough to confirm:
  --   1. the dir is writable
  --   2. all dirs under the path are removable
  names = p9.readdir(path,true)
  if next(names) == nil then
    return true
  end
  if test("-w",path) then
    flag = true
  else
    return false,path
  end
  for k,v in pairs(names) do
    if isdir(v) then
      s,r =  removable(path.."/"..k, flag)
      if not s then
        return s,r
      end
    end
  end
  return true
end

return {
	isdir=isdir,
	test=test,
	mkdirs=mkdirs,
	copy=copy,
	settime=settime,
	cpdir=cpdir,
	remove=remove,
	walkdir=walkdir,
	lsdir=lsdir,
	removable=removable,
}

