#include <u.h>
//#include <libc.h>
#include "lauxlib.h"

#define _PLAN9_SOURCE

#include </sys/src/ape/lib/ap/plan9/lib.h>
//#include </sys/src/ape/lib/ap/plan9/sys9.h>
#include </sys/src/ape/lib/ap/plan9/dir.h>

#pragma	lib	"libc.a"
#pragma	src	"/sys/src/libc"

#define nil		((void*)0)
#define	OREAD	0	/* open for read */
#define	OWRITE	1	/* write */
#define	ORDWR	2	/* read and write */
#define	OEXEC	3	/* execute, == read but check execute permission */
#define	OTRUNC	16	/* or'ed in (except for exec), truncate file first */
#define	OCEXEC	32	/* or'ed in, close on exec */
#define	ORCLOSE	64	/* or'ed in, remove on close */
#define	OEXCL	0x1000	/* or'ed in, exclusive use (create only) */

/* bits in Dir.mode */
#define DMDIR		0x80000000	/* mode bit for directories */
#define DMAPPEND	0x40000000	/* mode bit for append only files */
#define DMEXCL		0x20000000	/* mode bit for exclusive use files */
#define DMMOUNT		0x10000000	/* mode bit for mounted channel */
#define DMREAD		0x4		/* mode bit for read permission */
#define DMWRITE		0x2		/* mode bit for write permission */
#define DMEXEC		0x1		/* mode bit for execute permission */

typedef	unsigned char	uchar;
typedef	unsigned short	ushort;
typedef unsigned int	uint;
typedef unsigned long	ulong;
typedef	long long	vlong;
typedef	unsigned long long uvlong;
//typedef	ushort		Rune;

typedef
struct Tm
{
	int	sec;
	int	min;
	int	hour;
	int	mday;
	int	mon;
	int	year;
	int	wday;
	int	yday;
	char	zone[4];
	int	tzoff;
} Tm;

typedef
struct Lock {
	int	val;
} Lock;

typedef
struct Waitmsg
{
	int	pid;		/* of loved one */
	ulong	time[3];	/* of loved one & descendants */
	char	*msg;
} Waitmsg;



extern	int	close(int);
extern	long	dirreadall(int, Dir**);
extern	Dir*	dirstat(char*);
extern	int   snprint(char *s, int len, char *format, ...);
extern	int	getfields(char*, char**, int, int, char*);
extern	char*	seprint(char*, char*, char*, ...);
extern	int	chartorune(Rune*, char*);
extern	int	runetochar(char*, Rune*);
extern	Tm*	gmtime(long);
extern	int access(char *name, int mode);
extern	int create(char *file, int omode, ulong perm);
extern	void genrandom(char *buf, int nbytes);
extern	vlong seek(int fd, vlong off, int how);
extern	int fork(void);
extern	Waitmsg*	_WAIT(void);
extern	int atnotify(int (*f)(void*, char*), int in);
extern	int fprint(int fd, char *format, ...);
extern	void lock(Lock *lk);
extern	void unlock(Lock *lk);

enum
{
	UTFmax		= 3,		/* maximum bytes per rune */
	Runesync	= 0x80,		/* cannot represent part of a UTF sequence (<) */
	Runeself	= 0x80,		/* rune and UTF sequences are the same (<) */
	Runeerror	= 0xFFFD,	/* decoding error in UTF */
};
