#include <stdio.h>
#include <string.h>
#include <netdb.h>

static const char *error_msg = "Resolver error";
static const char *const h_errlist[] = {
	"Error 0",
	"Unknown host",			    /* 1 HOST_NOT_FOUND */
	"Host name lookup failure",	    /* 2 TRY_AGAIN */
	"Unknown server error",		    /* 3 NO_RECOVERY */
	"No address associated with name",  /* 4 NO_ADDRESS */
};
static const int h_nerr = { sizeof(h_errlist)/sizeof(h_errlist[0]) };

/*
 * herror -- print the error indicated by the h_errno value.
 */
void herror(const char *s)
{
	static const char colon_space[] = ": ";
	const char *p;
	const char *c;

	c = colon_space;
	if (!s || !*s) {
		c += 2;
	}
	p = error_msg;
	if ((h_errno >= 0) && (h_errno < h_nerr)) {
	    p = h_errlist[h_errno];
	}
	fprintf(stderr, "%s%s%s\n", s, c, p);
}


const char *hstrerror(int err)
{
    if (err < 0) {
	return(error_msg);
    } else if (err < h_nerr) {
	return(h_errlist[err]);
    }
    return(error_msg);
}
