#! /usr/bin/env python
# (c) 1999 - AccesSoft - See license.txt for details
# $Id: tostr.py,v 1.1 2004/02/12 20:20:18 daveron Exp $
#    converts things to strings -- even tuples, lists, and dicts

# JGM -- I'm not sure what this does over and above the normal implicit string conversion...
"""

>>> tuple = (1, 2, 3)
>>> str(tuple)
'(1, 2, 3)'
>>> tostr(tuple)
'(1, 2, 3)'
>>> dictionary = { '1' : 'Spam', '2' : 'Eggs'}
>>> str(dictionary)
"{'2': 'Eggs', '1': 'Spam'}"
>>> tostr(dictionary)
'{2: Eggs, 1: Spam}'

"""


import types
import string

def tostr(x):
    t = type(x)
    if t == types.DictionaryType:
        return "{%s}" % string.join(map(lambda k,d=x: tostr(k)+": "+tostr(d[k]),
                                        x.keys()),
                                    ", "
                                    )
        

    if t == types.ListType:
        return "[%s]" % string.join(map(lambda i: tostr(i), x), ", ")

    if t == types.TupleType:
        if len(x) == 1:
            return '(%s)' % tostr(x[0])
        return '(' + string.join( \
            map( lambda i: tostr(i), x), \
            ", " ) + ")"

    return str(x)


def _test(verbose=0):
    import doctest
    import tostr
    return doctest.testmod(tostr, verbose=verbose)

if __name__ == '__main__':
    _test(0)
