#! /usr/bin/env python
import unittest
import msg
from StringIO import StringIO
import sys

def assertEquals(got, expect, error):
    assert got == expect, '''%s: expected %s, got %s''' % (error, `expect`, `got`)


class DocTestCase(unittest.TestCase):
    def setUp(self):
        self.doctest = None
    def checkDoc(self):
        if self.doctest:
            errors, tests = self.doctest(0)
            assertEquals(errors, 0,
                         '%s Doctest failed, %s errors out of %s tests' % (self.__class__.__name__, errors, tests))

class MsgDocTestCase(DocTestCase):
    def setUp(self):
        self.doctest = msg._test

class MsgTestCase(unittest.TestCase):
    pass

def suite():
    DocSuite = unittest.makeSuite(MsgDocTestCase, 'check')
    MsgSuite = unittest.makeSuite(MsgTestCase, 'check')
    suite = unittest.TestSuite((DocSuite, ))
    return suite

if __name__ == '__main__':
    testSuite = suite()
    runner = unittest.TextTestRunner()
    runner.run(testSuite)
