# (c) 1999 - AccesSoft - See license.txt for details
# $Id: moophelp2html.py,v 1.1 2004/02/12 20:20:18 daveron Exp $
#----------------------------------------------------------------------
#	This module converts MOOP help files into HTML.  It is a stand-
#	alone utility, not used or needed by the MOOP engine.
#----------------------------------------------------------------------

import moophelp
import os
from time import *
import string

gTopic = ''

def header(title):
	out = "<html><head><title>" + title + '\n'		\
		"</title></head><body><h2><center>" + title + '\n'	\
		"</center></h2>"
	return out

def footer(surpressLink = 0):
	out = ''
	if not surpressLink:
		out = '<p><a href="index.html">[Top]</a><br>'
	out = out + "<hr><i>" + ctime(time()) + "\n</body></html>"
	return out
	
def word(w):
	w = string.lstrip(w)
	if not w: return ''
	prestuff = ''
	while w and w[0] in "(),.!?;:":
		prestuff = prestuff + w[0]
		w = w[1:]
	poststuff = ''
	while w and w[-1] in "(),.!?;:":
		poststuff = w[-1] + poststuff
		w = w[:-1]
	if w != gTopic and w in moophelp.helpDB.keys():
		return prestuff + '<a href="' + w + '.html">' + w + '</a>' + poststuff
	return prestuff + w + poststuff

def makesafe(str):
	out = string.join(string.split(str,'<'),'&lt;')
	out = string.join(string.split(out,'>'),'&gt;')
	return out
	
def body(str):
	lines = string.split(str,'\n')
	out = ''
	intable = 0
	for l in lines:
		l = makesafe(l)
		if l[:3] == '   ':
			if not intable:
				out = out + '<center><table width=80% align=center>\n'
				intable = 1
			out = out + '<tr>'
			for w in filter( lambda x:x, string.split(l,"   ")):
				out = out + '<td>' + word(w) + '</td>'
			out = out + '</tr>\n'
		else:
			if intable:
				out = out + '</table></center>'
				intable = 0
			if l == '':
				out = out + '<p>'
			elif l[:7] == "Syntax:":
				out = out + '<b>Syntax:</b> <font size=+1><tt>' +  \
							l[8:] + '</tt></font><p>'
			else:
				out = out + string.join( map(lambda w:word(w), string.split(l) ))
			out = out + '\n'
			
	return out

#---------------------------------------------------------------
# load database
print "Loading database..."
moophelp.hLoad()

print "Creating html files..."
# change directory
#os.mkdir('moophelp')
os.chdir('moophelp')

# create the main file
print "index.html..."
f = open('index.html', 'w')
f.write(header('MOOP Help'))
f.write(body( moophelp.help()) )
f.write(footer(1))

# create particular topic files
for gTopic in moophelp.helpDB.keys():
	filename = gTopic + ".html"
	print filename+"..."
	f = open(filename, 'w')
	f.write(header(gTopic))
	f.write(body( moophelp.help(gTopic) ))
	f.write(footer())

print "All done!"
