# (c) 2001 - Joshua Macy - See license.txt for details
# (c) 1999 - AccesSoft - See license.txt for details
#----------------------------------------------------------------------
#    This module serves as a main program for moop.py,
#    and connects the engine directly to the terminal.
#----------------------------------------------------------------------

import moop
import sys
import string
from moophelp import HelpRec
term = sys.stdout
__done = 0

def AskYesNo(prompt, default='Y'):
    while 1:
        ans = raw_input(prompt + ' [' + default + '] ')
        if len(ans) > 1:
            ans = ans[0]
        if ans == '':
            ans = default
        ans = string.upper(ans)
        if ans == 'Y':
            return 1
        if ans == 'N':
            return 0
        print ("Please enter Y or N.")
    
def startup():
    # check for moop.dat
    try:
        file = open('../var/moop.dat', 'r')
        file.close()
        good = 1
    except:
        good = 0
    if good:
        print "Loading database..."
        moop.initialize()                # load file
    else:
        print "Cannot open data file 'moop.dat'."
        if not AskYesNo("Create new database from scratch?"):
            return 0
        moop.initialize(1)
    return 1

def login(name):
    matches = filter(lambda x,a=name: x.__isuser and x.name==a, \
            moop.gObjlist.values())
    if not matches:
        print "User", name, "not found."
        return 0

    user = matches[0]
    user.Login(term)
    return user

def play():
    # show login message
    try:
        f = open('../text/connect.txt','r')
        for line in f.readlines(): print line[:-1]
    except: pass

    name = raw_input("Name: ")
    print "Password: (not needed in direct mode)"
    user = login(name)
    if not user: return
    
    try:
        f = open('../text/motd.txt','r')
        for line in f.readlines(): print line[:-1]
    except IOError:
        pass

    done = 0
    while not done:
        sys.stdout = term
        cmd = raw_input('\n')
        print
        if cmd == "@quit":
            done = 1
            break
        elif cmd == "savedb":
            moop.gSave()
        else:
            user.handleMsg(cmd)
            for i in range(0,10):
                moop.gUpdate()

    try:
        user.Logout()
    except:
        print "Problem calling user.Logout()"
    sys.stdout = term
    if AskYesNo("Save database?"):
        moop.gSave()

def readFile():
    name = raw_input("Login Name: ")
    user = login(name)
    if not user:
        return
    
    fname = raw_input("Filename: ")
    file = open('../text/'+fname, 'r')
    lines = file.readlines()
    for i in range(0,len(lines)):
        print fname + ">" + lines[i]
        user.handleMsg(string.rstrip(lines[i]))
        for i in range(0,5):
            moop.gUpdate()
    try:
        user.Logout()
    except:
        print "Problem calling user.Logout()"
    sys.stdout = term
    if AskYesNo("Save database?"):
        moop.gSave()

def editHelp():
    import moophelp
    moophelp.hLoad()
    moophelp.popDB()
    if AskYesNo("Save help database?"):
        moophelp.hSave()

def setTreasury():
    while 1:
        instr = raw_input("Enter Treasury amount [%s]: " % moop.gTreasury) 
        if instr:
            try:
                moop.gTreasury = string.atoi(instr)
                break
            except ValueError:
                print "Treasury amount must be a number"
        else:
            print "Treasury amount unchanged"
            break
    if AskYesNo("Save database?"):
        moop.gSave()

class moopData:
    def __init__(self, objlist, props, contents, cmdDefs, treasury):
        self.objlist = objlist
        self.props = props
        self.contents = contents
        self.cmdDefs = cmdDefs
        self.treasury = treasury

def saveDB():
    try:
	moop.gSave()
	print "Database saved."
    except:
	print "can't save db"
	raise

def dumpToXML():
    import xml_pickle
    o = moopData(moop.gObjlist, moop.gProps, moop.gContents, moop.gCmdDefs, moop.gTreasury)
    fname = 'moop.xml'
    instr = raw_input("Enter a dump file name [%s]: " % fname)
    if instr:
        fname = instr
    xml_string = xml_pickle.XML_Pickler(o).dumps()
    print "Dumping to file", fname
    try:
        f = open('../text/'+fname, 'w')
    except IOError:
        print "Unable to open file", fname
    print >> f, xml_string

def quit():
    global __done
    __done = 1

def menu():
    global __done
    __done = 0
    choices = { '1' : ("Enter MOOP", play),
                '2' : ("Edit help database", editHelp),
                '3' : ("Read commands from a file", readFile),
                '4' : ("Set the treasury amount", setTreasury),
                '5' : ("Dump the moop to an XML file", dumpToXML),
		'6' : ("Save Database to disk", saveDB),
                'q' : ("Quit", quit)
               }
    while not __done:
        keys = choices.keys()
        keys.sort()
        for key in keys:
            print "%s: %s" % (key, choices[key][0])
        try:
            choice = string.lower(raw_input(">"))
        except EOFError:
            __done = 1
            break
        try:
            choices[choice][1]()
        except KeyError:
            pass

if __name__ == '__main__':
    if startup():
        menu()
