#!/usr/local/bin/python
#All code (c) Dusty Harr 
#see license.txt for info

import moopsock
import os
import sys

def daemonise():
    moopsock.Log('Attempting to fork daemon')
    pid = os.fork()
    if pid != 0:
        os._exit(0) #parent no longer needed
    # XXX TODO send output to a log file
    os.setsid()
    moopsock.Log('Daemon successfully forked')

#dont conflict with imported main!!
def daemonmain():
    moopsock.init()
    daemonise()
    while moopsock.running > -2:
       try:
           moopsock.main(noinit=True)
           if moopsock.running > -2:
               moopsock.Log(running)
               moopsock.Log('moop just died, starting again')
       except:
           moopsock.Log('exception encountered, restarting moop from last save')
           try:
               killcon()
           except:
               moopsock.Log('error cleaning up, continuing anyways')
               pass
           moopsock.init() 
    moopsock.Log('moop daemon terminated')   


def killcon():
    moopsock.Log( "emergancy reset, disconnecting users" )
    for p in moopsock.connlist: moopsock.Disconnect(p, "The server just died")
    sys.stdout = moopsock.stdout
    moopsock.sock.close()

if __name__ =='__main__':
    daemonmain()
    moopsock.Log('moopd daemon exiting')


