namespace eval plugins {
    variable current_plugins [list]
    variable config_dir [config::get_config_dir "plugins"]

    proc on_set_current_place {place} {
        variable current_plugins
        foreach name $current_plugins {
            set handler_name "${name}::on_set_current_place"
            set handlers_count [llength [info procs $handler_name]]
            if {$handlers_count > 0} {
                eval "$handler_name {$place}"
            }
        }
    }

    proc load {path} {
        global base_dir

        set f [string first "/" $path]
        if {$f == -1} {
            # Absolute path:
            source $path
        } else {
            # Relative path:
            source "$base_dir/$path"
        }
    }
    proc register {name} {
        variable current_plugins
        set current_plugins [lappend current_plugins $name]
    }

    proc init {} {
        variable current_plugins
        config::load_plugins

        foreach name $current_plugins {
            eval "${name}::init"
        }
    }
}
