package require Thread

namespace eval curl {
    namespace export download
    namespace export read

    variable tmpdir "/tmp/$config::UID"
    file mkdir $tmpdir
    variable download_dir "$env(HOME)/Downloads"
    variable executor [tpool::create -minworkers 8 -maxworkers 12]

    variable user_agent \
        "Mozilla/5.0 (X11; Linux x86_64; rv:81.0) Gecko/20100101 Firefox/81.0"

    proc threaded_download {url target} {
        variable user_agent
        variable executor

        set curl_cmd "curl -s -A {$user_agent} -f -L {$url} -o {$target}"
        set cmd "exec -ignorestderr -- $curl_cmd"

        set task_id [tpool::post -nowait $executor $cmd]
        return $task_id
    }

    proc wait_threaded_return {task_id} {
        variable executor

        set ready_count [llength [tpool::wait $executor $task_id]]
        if {$ready_count == 0} {return "WAIT"}

        try {
            set results [tpool::get $executor $task_id]
        } trap CHILDSTATUS {results options} {
            set status [lindex [dict get $options -errorcode] 2]
            puts "task $task_id status: $status"
            return "ERROR"
        }
        return "OK"
    }

    proc _download {url target} {
        variable user_agent

        set cmd "exec -ignorestderr -- curl -s -f -A {$user_agent} -L {$url} -o {$target}"

        try {
            set results [eval $cmd]
        } trap CHILDSTATUS {results options} {
            set status [lindex [dict get $options -errorcode] 2]
            puts "curl $url -o $target status: $status"
            return ""
        }
        return $target
    }

    proc download {url target {cached false}} {
        if {$cached == true} {
            set exists [file exists $target]
            if {$exists} {
                return $target
            }
        }
        return [_download $url $target]
    }

    proc _read {url} {
        variable user_agent

        try {
            set results [exec -ignorestderr -- curl -A $user_agent -L --silent $url]
        } trap CHILDSTATUS {results options} {
            set status [lindex [dict get $options -errorcode] 2]
            puts "curl $url status: $status"
            return ""
        }
        return $results
    }

    proc read {url {target ""}} {
        variable tmpdir

        if {$target != ""} {
            set target_path "$tmpdir/$target"
            set exists [file exists $target_path]
            if {$exists} {
                set fd [open $target_path r]
                set content [::read $fd]
                close $fd
                return $content
            }
        }

        set results [curl::_read $url]
        if {$target != ""} {
            set fd [open $target_path w]
            puts -nonewline $fd $results
            close $fd
        }
        return $results
    }
}
