namespace eval config {
    variable UID $env(USER)
    variable HOME $env(HOME)
    variable images_step_size 200

    variable h1font "Fira Sans Heavy"
    variable hfont "Fira Sans ExtraBold"
    variable pfont "Fira Sans Light"
    variable fxfont "Fira Code Light"
    variable base_font_size 14

    variable config_dir [file join $HOME ".config" "blipt"]

    # User defined:
    proc load_plugins {} {}

    proc load_user_config {} {
        variable config_dir
        set ucf_path [file join $config_dir "config.tcl"]
        if {[catch {set user_config_file [open $ucf_path]}] == 0} {
            uplevel 1 "source {$ucf_path}"
        }
    }

    proc get_config_dir {name} {
        variable config_dir
        set dir [file join $config_dir $name]
        file mkdir $dir
        return $dir
    }

    # init
    load_user_config
}
