namespace eval async_queue {
    variable async_commands [list]
    variable async_command_index 0

    variable long_wait 750
    variable short_wait 50

    proc enqueue {cmd} {
        variable async_commands
        set async_commands [lappend async_commands $cmd]
    }

    proc iterate {} {
        variable long_wait
        variable short_wait
        variable async_commands
        variable async_command_index

        update

        set counter [llength $async_commands]
        if {$counter == 0} {
            after $long_wait "async_queue::iterate"
            return
        }

        set next_command [lindex $async_commands $async_command_index]
        if {$next_command == ""} {
            after $short_wait "async_queue::cleanup"
            return
        }

        set result [eval $next_command]
        if {$result == "OK" || $result == "ERROR"} {
            incr async_command_index
            after $short_wait "async_queue::iterate"
            return
        }
        set w [expr $long_wait / 2]
        after $w "async_queue::iterate"
        return
    }

    proc start {} {
        variable long_wait

        set w [expr $long_wait * 2]
        after $w "async_queue::iterate"
    }

    proc cleanup {} {
        update
        variable async_commands
        variable async_command_index
        variable long_wait

        set async_commands [list]
        set async_command_index 0

        after $long_wait "async_queue::iterate"
    }
}
