namespace eval tags {
    variable config_dir [file join \
        $plugins::config_dir "tags" $blipt::driver::name]

    variable current_tags [list]

    bind $blipt::doc f {
        plugins::tags::tag "favorite" [blipt::get_current_place]
    }

    proc tag {tag_name place} {
        variable config_dir
        variable current_tags

        set file_path [file join $config_dir "$tag_name.txt"]

        # Check if this tag isn't already enabled:
        foreach tag $current_tags {
            set local_tag_name [lindex $tag 0]
            if {$local_tag_name != $tag_name} {continue}

            set tags_list [lindex $tag 1]
            foreach tagged_entry $tags_list {
                set parts [split $tagged_entry "|"]
                set tagged_place [lindex $parts 0]
                if {$tagged_place == $place} {
                    remove_tag $tag_name $place $file_path
                    return
                }
            }
        }

        # Add to file:
        set f [open $file_path "a"]
        puts $f "$place|$blipt::current_title"
        close $f

        # Add to current_tags:
        # (Too lazy, it's too late, I'm just using brute force:)
        set current_tags [list]
        load_tags

        # Reload which tags are active in this place:
        set place_tags [get_place_tags $place]

        # Add to title:
        blipt::set_title_complement [string toupper "$tag_name"]

        # Let driver know:
        catch {blipt::driver::has_tags $place_tags}
    }
    proc load_tags {} {
        variable config_dir

        foreach tags_file [glob -nocomplain -directory $config_dir *.txt] {
            load_tags_from_file $tags_file
        }
    }
    proc load_tags_from_file {tags_file} {
        variable current_tags

        set parts [file split [file rootname $tags_file]]
        set tag_name [lindex $parts end]

        set tags_list [list]
        set f [open $tags_file]
        foreach place [split [read $f] "\n"] {
            set tags_list [lappend tags_list $place]
        }
        set current_tags [lappend current_tags [list $tag_name $tags_list]]
    }
    proc on_set_current_place {place} {
        variable current_tags

        set place_tags [get_place_tags $place]
        blipt::set_title_complement $place_tags
        catch {blipt::driver::has_tags $place_tags}
    }
    proc get_place_tags {place} {
        variable current_tags

        set place_tags [list]
        foreach tag $current_tags {
            set tag_name [lindex $tag 0]
            set tags_list [lindex $tag 1]

            foreach tagged_entry $tags_list {
                set parts [split $tagged_entry "|"]
                set tagged_place [lindex $parts 0]
                if {$tagged_place == $place} {
                    set uppername [string toupper $tag_name]
                    set place_tags [lappend place_tags $uppername]
                    break
                }
            }
        }
        return $place_tags
    }
    proc remove_tag {tag_name place file_path} {
        variable current_tags

        # Remove from file:
        set f [open $file_path "r"]
        set valid_entries [list]
        foreach line [split [read $f] "\n"] {
            if {$line == ""} {continue}
            set match [string first "$place|" $line]
            if {$match == -1} {
                set valid_entries [lappend valid_entries $line]
            }
        }
        set f [open $file_path "w"]
        foreach valid_entry $valid_entries {
            puts $f $valid_entry
        }
        close $f

        # Remove from local list:
        # (Too lazy, it's too late, I'm just using brute force:)
        set current_tags [list]
        load_tags

        # Remove from title:
        set place_tags [get_place_tags $place]
        blipt::set_title_complement $place_tags

        # Let driver know:
        catch {blipt::driver::has_tags $place_tags}
    }

    proc init {} {
        variable config_dir
        file mkdir $config_dir
        load_tags
    }

    plugins::register "tags"
}
