# Blipt!

## Installation

1. Copy the project directory anywhere you find fit.
1. Create a symbolic link to `blipt` script in any directory inside your
   `PATH`.

If you, like me, has your own `~/bin`, just do this:

```bash
$ cd ~/bin
$ ln -s ~/Downloads/blipt/blipt .
```

If you're using `zsh`, use the `rehash` command after creating the
symbolic link and you're good to go.

### Requirements

* Tcl/Tk 8.6
* Fira fonts

## Usage

### Magic line

If you plan to use Blipt! as a GUI for your program, you'll be writing
what Blipt! calls a "driver". That is, your program will be controlling
Blipt! to show whatever you need.


First thing you'll need is to configure your *magic line* to use Blipt! as
the "interpreter" for your script:

```tcl
#!blipt
```

### Namespace

Your entire script will run inside a `namespace eval driver` command, that
runs inside a `namespace eval blipt`. That means that full names of your
variables and commands will be `blipt::driver::<name>`.

### main command

Blipt will handle command line arguments and pass along basically
everything except your script name.

```tcl
proc init {argv} {
    set first_argument [lindex $argv 0]
}
```

(If you need to know the script name, you can use `$blipt::driver::name`.)

### Navigating around

You should use `blipt::go_to` to navigate around, since it allows Blipt to
keep track of **history** and already encapsulates your commands in a call
to `blipt::change_doc`.

If you have a command, let's say, `display_page {address}`, you should
navigate to an address using this:

```tcl
blipt::go_to "driver::display_page {$address}"
```

Blipt! won't "uplevel" the command, since it becomes very tricky to call
the same command later at toplevel (for instance, when the User press some
key), so your command must be already properly expanded and that's why you
usually pass commands to `go_to` using double quotes and not curly braces
as usual in other contexts.

## Plugins

You can write plugins for Blipt! for handling peripheral things like tags
management, input/output formatting, logging, etc. Your plugin must have
an `init {}` command and optionally implement some other commands to
handle events. For instance:

```tcl
proc on_set_current_place {place} {
}
```

### Configuring plugins

Blipt! loads configuration from `~/.config/blipt/config.tcl`. Yes, it is
a simple Tcl script that is *sourced* inside `config::` namespace.

Besides changing config variables, you also can load plugins via
`load_plugins` command:

```tcl
# You can set different fonts:
set fxfont "Inconsolata"

# Or load plugins:
proc load_plugins {} {
    plugins::load "../plugins/tags.tcl"
}
```

If the plugin path is a relative one, it's relative to `blipt.tcl` script.
But you can pass absolute paths, too: plugin are not required to live
inside `blipt` project directory.

### Example

Look into `plugins/tags.tcl`.
