# Blipt!

    Βλέπετε

**Your contribution is welcomed. See CONTRIBUTING.md.**

## What I saw

For some time I was eager to find some way to read things without all the
**bloat** from modern Web browsers but, at the same time, without the
**harshness** of Terminal User Interfaces (TUIs).


But why not using a Web Browser?

You see, my usual desktop experience would need almost no RAM by today
standards, but every time a Web browser is lurking around the comsumption
goes much higher than what I believe is reasonable and my hard drive keeps
spinning like crazy when the system is "at rest" because "local storage"
and "IndexedDB" are doing something I never asked.

Beside that there's the question of how much inaccessible to the common
programmer the Web has become nowadays. Our browsers currently have
**more** lines of code than our operating systems! When even Microsoft
tried to implement a new one and in the end gave up, one can realize that
keeping up with the latest "living standards" is virtually impossible.


That's not the way it should be.


Trying to find some middle ground between both worlds (Web browsers and
TUIs) I made an experiment with my "fxi" project (that *I think* stands
for "for X interface" - can't really remember), but relying on a Python
install was not very appealing to most people and now I think it is not
appealing even to me.

Also, trying to create applications with GUI always seemed too difficult,
since most of the time the GUI itself tends to consume **more** mental
resources and lines of code than what we are really trying to do and
that's kind of frustrating. To the point a lot of really talented
programmers don't even think about creating GUIs anymore and resort to
more manageable options like `ncurses` or even raw interaction via the
command line.

## What I want to see

I always thought accessing external documents, like in the Web, should
follow, somehow, **the Unix philosophy**, and Blipt! is the first piece
of a project to make that happen.

Basically, Blipt! is a Tcl program expected to load another custom
*source file*. Nothing fancy, actually. What Blipt! provides, besides
what Tk already does, is some easy to use functions that allow users to
create **documents** easily.

Here is an example:

```tcl
h1 "The Blipt! Project"
h2 "Blipt!: see!"
hr

p "This is just another text as any text you ever seem, I think. "
p "We call it a paragraph, but you can call it the way you feel more "
p "confortable with."
newline

fixed "And this\nis fixed width\ntext"
newline

link "This is a link" "example-link" {
    puts "link clicked"
    load_file "test2.tcl"
}
newline

img "test.png"
newline
```

The idea is to use Blipt! to facilitate creating new ways to interact
with certains document types and data in general. It will **not**
implement features specific to any format or protocol and that's why it's
expected to load a *source file* provided by the user or an application.

This way you can build a simple Gopher browser, for instance, without
spending too much time thinking about GUI details. All you need to do is
create a `gopher.tcl` file, for instance, that handles low level details
about the protocol and load it into Blipt! to server as renderer.

## Empower, but with simplicity

Applications are absolutelly free to use Blipt! and Tcl/Tk to create
anything they want -- the plan is not to limit, but to empower.

Except Blipt! is not raw Tcl/Tk. The project has its own objectives and
the final goal is to render documents with **simplicity and
beauty** by default.

### This project won't focus on these things

* Floating elements: we should see documents as primarily textual.
* "URL bar": Blipt! is **not** a "browser".
* HTML support: HTML is XML. Avoid XML whenever possible. Implement input
  as a separate program or plugin.
* Playing videos or music: let the user decide which program to use for
  that.
