# include <stdio.h>
# include <malloc.h>
# include <stdlib.h>
# include "sound.h"
# include "dsetup.h"


/*
 *	Set up for using the sound library, getting the buffers using
 *	far malloc.
 *
 *	nobufs - number of buffers to allocate for sound library use
 *		The minimum value of nobufs is 4 (5 for continuous
 *		play).
 *	trigger - number of buffers to fill before starting playback
 *		(0 for maximum possible buffers)
 *	dma_channel - which dma channel to use.  
 *		(u_short) 0 indicates a default.
 *	irq - which interrupt channel to use.  
 *		(u_short) 0 indicates a default.
 *	options - various option flags to be passed to snd_init.
 *
 *	See the snd_init() documentation for more info on the last 4
 *	parameters.
 */
# ifdef __STDC__
void far set_up_sound(u_short nobufs, u_short trigger, u_short dma_channel, 
	u_short irq, u_short options)
# else
void far set_up_sound(nobufs, trigger, dma_channel, irq, options)
u_short nobufs, trigger, dma_channel, irq, options;
# endif
{
	int	bufno;		/* buffers allocated counter */
	int	len;		/* appropriate size for buffers */
	char far *cp;		/* pointer to last allocated buffer */
	int	ret;		/* snd_init return code */
	char	versbuf[100];	/* buffer for version string */
	char far *vp;		/* pointer into version string */

	/* Print the version number */

	for (vp = snd_version()->version, cp = versbuf; *vp; vp++, cp++)
		*cp = *vp;
	*cp = 0;
	printf("Sound Library %s\n", versbuf);

	/* find out what size buffer the sound library wants */
	len = snd_addbuf((SOUND far *) 0, (short) 0);

	/* loop for however many buffers are needed */
	for (bufno = 0; bufno < nobufs; bufno++)
	{
		/* allocate a buffer in far data space */
		cp = _fmalloc(len);
		/* check if allocation was successful */
		if (cp == NULL)
		{
			fprintf(stderr, "Cannot allocate sound buffers\n");
			exit (1);
		}
		/* give the sound library 1 buffer */
		snd_addbuf(cp, (short) 1);

		/* loop for the next buffer */
	}
	/* all the buffers are allocated */

	/* initialize the sound library */
	ret = snd_init(trigger, dma_channel, irq, options);
	switch(ret)
	{
		case NOERROR:	/* ok */
			return;
		case INITBUF:	/* insufficient buffers */
			printf("snd_init:  insufficient buffers\n");
			break;
		case INIT64K:	/* buffers span 64k boundary */
			printf("snd_init:  all buffers span 64k boundary\n");
			break;
		case BADDMA:	/* DMA channel requested is invalid */
			printf("snd_init: DMA channel requested is invalid\n");
			break;
		case BADIRQ:	/* IRQ number requested is invalid */
			printf("snd_init:  IRQ number requested is invalid\n");
			break;
		case NOIRON:	/* Can't find sound hardware */
			printf("snd_init:  Cannot find sound hardware \n");
			break;
		default:	/* unknown error code */
			printf("snd_init:  unknown error code %d\n", ret);
			break;
	}
	exit(1);
}
