# include <stdio.h>
# include <conio.h>
# include "sound.h"
# include "drecord.h"
# include "dgetbuf.h"

/*
 *	This routine records a sound into the memory allocated by
 *	set_up_buffers().  
 */

# ifdef __STDC__
void do_record_sound(void)
# else
void do_record_sound()
# endif
{
	int	i;
	int	prompted = 0;

	/* set up for recording */
	snd_cue(TORECORD);
	/* prompt the operator and wait for response */
	printf("Press ENTER to start recording\n");

	while (getch() != '\r')		/* wait for carriage return */
		; /* do nothing */

	/* for each buffer */
	for (i = 0; i < numbuffers; i++)
	{
		/*
		 * maxtime = 0 means "record until buffer fills up"
		 * rate = R11000; use 11,000 samples/second
		 */
		do
		{
			/* first pass through loop, give instructions */
			if (prompted == 0)
			{
				printf("Press any key to stop recording\n");
				prompted = 1;
			}

			/* Check for keyboard input, which is considered a */
			/* request to stop recording */
			if (kbhit())
			{
				/* stop recording */
				snd_stop((SNDHDR far *) 0);	
				/* read character and throw it away */
				getch();	
				printf("Recording stopped by operator request\n");
				return;
			}
		} while (snd_record(sndstructs[i], 0, R11000, 
			(u_char far *) NULL, FALSE) == WOULDBLOCK);
	}
	snd_wait((SNDHDR far *) 0, (short) 1);	
				/* wait for recording to finish */
	printf("Recording stopped - buffers full\n");
	return;
}
