# include <stdio.h>
# include <fcntl.h>
# include <stdlib.h>
# include <io.h>
# include "sound.h"
# include "dgetbuf.h"
# include "dload.h"
# include "csrbase.h"
# include "csrcmps.h"

/*
 *	This routine takes the sound saved in a file by do_compress_and_save()
 *	decompresses it, and loads it into the sound buffers allocated by
 *	set_up_buffers().
 *
 *	The file format is unlike anything used by anything else.
 *	The file format is:
 *	Repeat for each SOUND structure:
 *	  A long integer indicating the length of compressed data.
 *	  A long integer indicating the length of the data uncompressed.
 *	  An unsigned character containing the recording rate.
 *	  An unsigned character containing the system (machine type).
 *	  The compressed data
 *	Next SOUND structure
 *	A long integer containing 0.
 */
# ifdef __STDC__
void do_decompress_and_load(char *filename)
# else
void do_decompress_and_load(filename)
# endif
{
	int				fd;				/* file handle for save file */
	COMPINFO 		Info;			/* compress scratch area */
	unsigned char	filebuffer[512];/* buffer for file writes */
	long 			chunklength; 	/* length of compressed data for
										this SOUND structure */
	unsigned short 	datalen;		/* usable data length in filebuffer */
	int				bufno;			/* index for SOUND structures */
	int				firsttime;		/* first-time-through flag */
	u_char			rate;			/* speed sound was recorded at */
	u_char			system;			/* machine used to record sound */
	u_long			uncomplen; 		/* uncompressed length of sound */
	long			ret;			/* return value from decompress */
	MSGBOX			msg;
	char			msg_buff[90];


	msg.pString = "Open File";
	msg.btn_combo = MSG_COMBO_OK;

	/* open the save file */
	if ( (fd = open(filename, O_RDONLY|O_BINARY)) < 0)
	{
		strcpy( msg_buff,"Cannot open sound data file" );
		strncat( msg_buff, filename, 60);
		msg.pMessage = msg_buff;
		bomb_out( &msg );
	}

	/* for each SOUND structure */
	for (bufno = 0; bufno < numbuffers; bufno++)
	{
		/* read the length of the compressed data */
		if (read(fd, (char *) &chunklength, sizeof(chunklength)) !=
			sizeof(chunklength))
		{
			msg.pMessage = "Error reading save file";
			bomb_out( &msg );
		}

		/* check for end of file */
		if (chunklength == 0)
			return;

		/* read the length of the data uncompressed */
		if (read(fd, (char *) &uncomplen,
			sizeof(uncomplen)) != sizeof(uncomplen))
		{
			msg.pMessage = "Error reading save file";
			bomb_out( &msg );
		}
		sndheaders[bufno]->sndp->sndlen = uncomplen;

		/* read the recording rate */
		if (read(fd, &rate, sizeof(rate)) != sizeof(rate))
		{
			msg.pMessage = "Error reading save file";
			bomb_out( &msg );
		}
		sndheaders[bufno]->sndp->rate = rate;

		/* read the system */
		if (read(fd, &system, sizeof(system)) != sizeof(system))
		{
			msg.pMessage = "Error reading save file";
			bomb_out( &msg );
		}
		sndheaders[bufno]->sndp->system = system;

		firsttime = 1;
		while (chunklength > 0)
		{
			/* read smaller of remaining data or buffer size */
			datalen = (int)((chunklength < 512) ?
				chunklength : 512);
			if (read(fd, filebuffer, datalen) != datalen)
			{
				msg.pMessage = "Error reading save file";
				bomb_out( &msg );
			}
			/* decompress */
			ret = snd_decompress_part(firsttime ? (SOUND far *)
				sndheaders[bufno]->sndp : (SOUND far *) 0,
				(COMPINFO far *) &Info,
				(u_char far *) filebuffer, datalen);
			/* first time for each compressed chunk, pass the */
			/* SOUND struct; on subsequent pieces, pass a null */
			/* pointer */
			if (ret == BADFMT)
			{
				msg.pMessage = "Sound compressed using unsupported algorithm.";
				bomb_out( &msg );
			}
			firsttime = 0;

			/* subtract off data we just read from total */
			chunklength -= datalen;
		}
		/* final call to decompress, get last of the data */
		snd_decompress_part((SOUND far *) 0, (COMPINFO far *)&Info,
			(u_char far *) filebuffer, 0);

		/* do the next SOUND */
	}

	/* close the file */
	close(fd);
	return;
}
