# include <stdio.h>
# include <conio.h>
# include <stdlib.h>
# include "sound.h"
# include "dsetup.h"
# include "dgetbuf.h"
# include "drecord.h"
# include "dsave.h"
# include "demo2.h"

/*
 *	This demonstration program records a sound, compresses it,
 *	and stores it to disk.  The program expects one command-line
 *	argument to contain the name of the file to save the sound in.
 *
 *	(Warning:  the file format is unlikely to be compatible with
 *	anything but sound library demonstration programs)
 */
# ifdef __STDC__
int	main(int argc, char *argv[])
# else
int	main(argc, argv)
int	argc;
char	*argv[];
# endif
{
	/* check arguments */
	if (argc != 2)
	{
		printf("Usage:  demo2 savefile\n");
		exit(1);
	}
	/* allocate buffers for the sound library, and initialize hardware */
	set_up_sound((u_short) 5, (u_short) 0, (u_short) 0, (u_short) 0,
		(u_short) 0);

	/* get memory for storing the sound */
	set_up_buffers();

	/* record the sound */
	do_record_sound();

	/* compress it, and save the compressed data to a file. */
	do_compress_and_save(argv[1]);

	/* shut down the sound hardware */
	snd_exit();
	return 0;
}
