	page	60,132
;-----------------------------------------------------------------------------
;	Wait.asm - snd_wait() and and_buf_wait() functions for the PSSJ
;		 Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	_snd_flush:far
	extrn	_snd_clock:word
	include	external.inc
	include sound.inc

snddata	segment public 'DATA'
snddata	ends
sndseg	segment	public	'CODE'
	assume	cs:sndseg
	page

;------------------------------------------------------------------------------
;	Snd_Wait	Waits for sound(s) to be output

;	extern int snd_wait(int offset, int segment, int block)
;	segment:offset == SNDHDR far * sp
;	When segment==0, options=offset

;<Edit 30>	New version of snd_wait.  Adds new functions and tries
;		to clean up old algorithms.


;	Mode A:	segment == 0

;	option == 0, block == FALSE
;		Return FALSE if idle, otherwise return running time.
;		If just started, we LIE and claim one tick, ie, return TRUE.

;	option == 0, block == TRUE
;		(Flush is attempted)
;		Return FALSE if idle, otherwise wait until player or recorder
;		goes idle, then return running time.

;	option > 0, block == FALSE
;		Return FALSE if running time < options.
;		Return FALSE if idle.
;		Return TRUE if running time >= options.

;	option > 0, block == TRUE
;		(Flush is attempted)
;		Return FALSE if idle
;		Return TRUE if running time >= options.
;		Wait if running time < options.

;	Mode B: segment > 0, treated as part of sp.

;	sp > 0, block == FALSE
;		Return FALSE if not in memory PLAY mode
;		Return FALSE if player is idle.
;		Return FALSE if player has not yet played specified sound.
;		Return TRUE if player is or already has played specified sound.

;	sp > 0, block == TRUE
;		Return FALSE if not in memory PLAY mode (Either RAMPUP or PLAY,
;		but not DISKPLAY or RECORD or DISKRECORD)
;		(Flush is attempted)
;		Return TRUE if player is or already has played specified sound.
;		Otherwise, wait.
;	
;------------------------------------------------------------------------------
	page
	public _snd_buf_wait
_snd_buf_wait	proc	far
	jmp	short	_snd_wait	;Common routine
_snd_buf_wait	endp

	public _snd_wait
_snd_wait	proc far
	push	bp
	mov	bp,sp
	push	di
	push	si
	push	ds
	push	es

;	Create the world
	mov	ax,snddata
	mov	ds,ax	;======================================================
	assume	DS:snddata
	
;	Finally, get some work done
	les	di,[bp].spptr	;::::::::Get far pointer to play struct::::::::
	mov	cx,[bp].spint		;Get block option

	pushf				;Save interrupt state
	cli	;----------------------- DI here for atomic test/jp -----------

;-----------------------------------------------------------------------------
;	Here we divide requests based on whether they want to block or not.
;-----------------------------------------------------------------------------

	mov	bx,word ptr snd_mode	;<22>Get player/recorder status
	cmp	cx,0
	jz	$NoBlock		;Non blocking
	page
;-----------------------------------------------------------------------------
;	Blocking operations
;-----------------------------------------------------------------------------
;	As a safety measure to avoid deadlock, blocking calls invoke
;	snd_flush except for record and disk modes.

	test	bx,INRECORD or DISKRECORD OR DISKPLAY	;<22>Don't flush for records OR
					;<22>disk playing.  Someone else
					;<22>will do this.
	jnz	$noflush		;Skip flush() if we're running

	push	es
	push	cx
	call	_snd_flush		;Note YOU MUST call flush
	pop	cx			;even if the player is 
	pop	es			;running to push the last
					;buffer onto the queue

;	Now we test to see if we are dealing with buffers or some other
;	mode.  If we have buffers, then we had better be in play mode.

$noflush:
	mov	ax,es			;Well?
	or	ax,ax
	jz	$notbufs		;Not dealing with buffers.  Good

;	We are now in the mode b operation, so we had better be in play mode.

	test	bx,INPLAY		;We can do this because it should
					;have started if we intend to block

	jz	$falseret		;Not running - USER ERROR

;------------------------------------------------------------------------------
;	Now the player is active, and we have a buffer to match on.
;	Here they want us to wait for a specific sound
;------------------------------------------------------------------------------
	mov	bx,es:[di].sndticket
	sti	;------------------------<13>Need ISR's to reach target--------
$SoundWait:
	call	near ptr _snd_chkidle	;Have we gone idle?
	jz	$falseret		;Abort now

	mov	ax,bx
	sub	ax,dma_ticket		;was curticket
	jz	$trueret		;Is next
	cmp	ax,400			;Have we wrapped?
	ja	$trueret		;We have wrapped,
					;so it has already played
					;300 buffers cant fit in 640k
	jmp	short $SoundWait
	page
;------------------------------------------------------------------------------
;	Now we process requests that are idle/not idle or time-based.
;------------------------------------------------------------------------------
$notbufs:
	or	di,di			;Was it an option or a time?
	jnz	$timeblk		;Block on time

;------------------------------------------------------------------------------
;	Okay, we want to wait until the player, recorder or disk handlers
;	have stopped.
;------------------------------------------------------------------------------

	sti	;------------------------<13>Need ISR's enabled----------------
$PlayRecWait1:				;<13>
	call	near ptr _snd_chkidle
	jz	$timeret		;Return the time when we stop.

	jmp	short $PlayRecWait1
	

;------------------------------------------------------------------------------
;	Now we want to wait until the player/recorder has been active
;	for a certain amount of time.  To prevent deadlocks, we also
;	test for the recorder or player going idle due to disk errors
;	or other problems.
;------------------------------------------------------------------------------

$timeblk:
	call	_snd_chkidle		;Are we idle?
	jz	$falseret		;Abort

	cmp	di,word ptr _snd_clock	;Amount of time we have been active
	jc	$timeblk
	jmp	$trueret		;Time has been reached or passed
	page
;------------------------------------------------------------------------------
;	Handle non-blocked options
;------------------------------------------------------------------------------
;	First, determine if this is a play-only operation

$NoBlock:
	mov	ax,es			;Well?
	or	ax,ax
	jz	$notbufs2		;Not dealing with buffers.  Good

;	We are now in the mode b operation, so we had better be in play mode.

	test	bx,INPLAY		;We can do this because it should
					;have started if we intend to block

	jz	$falseret		;Not running - USER ERROR

;----------------------------------------------------------------------------
;	Here we check if the specified sound has been queued to be played
;----------------------------------------------------------------------------
	mov	ax,es:[di].sndticket
	sub	ax,dma_ticket		;was curticket
	jz	$trueret		;Is next
	cmp	ax,300			;Have we wrapped?
	ja	$trueret		;We have wrapped,
					;so it has already played
					;300 buffers cant fit in 640k
	jmp	short $falseret		;No wrap, so it has not


;------------------------------------------------------------------------------
;	Now we process requests that are idle/not idle or time-based.
;------------------------------------------------------------------------------
$notbufs2:
	or	di,di			;Was it an option or a time?
	jnz	$timetest		;Test based on time

;----------------------------------------------------------------------------
;	Here we just check the play/record status
;----------------------------------------------------------------------------
	call	near ptr _snd_chkidle
	jnz	$timeret		;Return the time when we stop.
	jmp	$falseret		;Not running, return false.

	page
;------------------------------------------------------------------------------
;	Now we want to wait until the player/recorder has been active
;	for a certain amount of time.  To prevent deadlocks, we also
;	test for the recorder or player going idle due to disk errors
;	or other problems.
;------------------------------------------------------------------------------

$timetest:
	call	_snd_chkidle		;Are we idle?
	jz	$falseret		;Abort

	cmp	di,word ptr _snd_clock	;Amount of time we have been active
	jc	$falseret
	jmp	$trueret		;Time has been reached or passed


$timeret:
	popf	;------------------------------------------------------------
	mov	ax,_snd_clock		
	or	ax,ax			;<30>Is it zero?
	jnz	$return			;<30>No, return real value
	inc	ax			;<30>Force non-zero (a.k.a TRUE)
	jmp	short $return

$trueret:
	popf	;------------------------------------------------------------
	mov	ax,offset TRUE
	jmp	short $return

$falseret:
	popf	;------------------------------------------------------------
	mov	ax,offset FALSE
$return:pop	es	;::::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	ds	;======================================================
	pop	si
	pop	di
	pop	bp
	ret				;NEAR or FAR

_snd_wait	endp

;------------------------------------------------------------------------------
;	This routine tests the current state of the player/recorder
;	and returns Z if idle and NZ if active.
;------------------------------------------------------------------------------
	public	_snd_chkidle
_snd_chkidle	proc near

	mov	ax,word ptr snd_mode	;<22>Get player/recorder status
	test	ax,INPLAY OR INRECORD OR DISKPLAY OR DISKRECORD	;<22>Well?
	ret
_snd_chkidle	endp

sndseg		ends
	end

