	page	60,132
;-----------------------------------------------------------------------------
;	Record.asm - snd_record() function for the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	snd_play_on:NEAR
	extrn	snd_play_off:NEAR
	extrn	_snd_stop:FAR
	extrn	round_dssi:NEAR
	extrn	round_esdi:NEAR
	extrn	roundup:NEAR
	extrn	snd_fragmove:NEAR
	extrn	snd_dma_stop:NEAR
	extrn	snd_cat_buf:NEAR	;<32>
	extrn	_snd_clock:word		;<34>
	extrn	snd_residue:word	;<34>

MAKERECORD=1
	include	external.inc

	include	sound.inc

DMACLR	equ	0ch
snddata	segment	public	'DATA'
byte_per_mil	db	0		;<12>Invalid	
		db	11		;5500Hz		.999 msec x 2
		db	22		;11000Hz	.999 msec x 2
		db	44		;22000Hz	.999 msec x 2
		db	0
		db	0

ticktbl		dw	0		;<34>Dummy
		dw	550		;<34>5.5KHz
		dw	1100		;<34>11 KHz
		dw	2200		;<34>22 Khz
		dw	0		;<34>Time stands still
		dw	0		;<34>Time stands still

	public	rec_len,rec_sndaddr,get_rec_next,rec_count,rec_hdr	;<32>
	public	rec_depth,rec_limit,nextrec_queue	;<32>
rec_frag	dd	0
rec_hdr		dd	0
rec_len		dd	0
rec_sndaddr	dd	0
rec_depth	dw	0		;<32>Number of buffers pending
rec_limit	dw	1		;<32>Number of pending allowed
nextrec_queue	dd	0		;<32>Chain of pointers
snd_adjtbl	dd	0
snd_threshold	dw	0		;Only using LSB now
snd_sillen	dw	0
qcount		dw	0
snddata	ends

recparms	struc
		dw	?
		dw	(@codesize+1) dup (?)

recaddr		dd	?
recmaxTime	dw	?
recrate		dw	?
recadjust	dd	?		;<4>
recblock	dw	?		;<5>
reclimit	dw	?		;<32>Number of buffers we hold
recthresh	dw	?		;<29>
recsillen	dw	?		;<29>
recparms	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata

;------------------------------------------------------------------------------
;	Snd_Record	- Checks the users buffers for validity and
;			  starts the recorder if needed.
;	- By Frank Durda IV
;------------------------------------------------------------------------------

	public	_snd_record
_snd_record	proc far		;(*sp)

	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	cld				;<25>

	mov	ax,snddata
	mov	ds,ax	;=====================================================
	assume	DS:snddata
	push	es

;	See if the recorder is initialized (running).  If so, skip
;	a bunch of other stuff.

	mov	al,byte ptr snd_mode	;<22>
	test	al,INRECORD
	jnz	$recactive		;<33>Recorder is active.

;	See if we are playing anything.  If so, let it finish.
;	If they wanted to stop, they would have done it themselves.

$chkplay:
	test	al,INPLAY
	jnz	$chkplay		;<13>Player is still running

;	Okay, the player is not running.  See if we have to turn off
;	output hardware first.

$notplay:
	test	al,RAMPUP
	jz	$alreadydown
	call	snd_play_off		;Turn off playback hardware
	page
;	Okay, we are ready to switch into record mode.
;	First thing we do is initialize the recorder environment

$alreadydown:
	xor	bx,bx			;<33>
	mov	qcount,bx		;<33>Reset quiet counter
	mov	rec_depth,bx		;<33>Reset depth marker
	mov	word ptr nextrec_queue,bx	;<33>If idle then empty
	mov	word ptr nextrec_queue[2],bx	;<33>

;	Determine how many standby buffers are to be allowed

	mov	ax,[bp].reclimit	;<33>Determine how many buffers
	or	ax,ax			;<33>We should keep
	jnz	$notdef1		;<33>They gave a value
	inc	ax			;<33>Default = 1 (Toolkit I)
$notdef1:
	mov	rec_limit,ax		;<33>Store standby buffer count

;	Get the rate to be used during this recording session

	mov	bx,[bp].recrate		;Get rate to use
	mov	sndrate,bl		;Store that rate
					;BX is used below

;	Handle compensation flag

	and	snd_mode2,NOT (COMPENSATE OR THRESHOLD);<29>Turn comp flag off
	mov	cx,word ptr [bp].recadjust	;<29>
	mov	word ptr snd_adjtbl,cx	;<29>
	mov	dx,word ptr [bp+2].recadjust	;<29>
	mov	word ptr snd_adjtbl[2],dx	;<29>
	or	cx,dx			;<29>
	jz	$nocom			;<29>
	or	snd_mode2,COMPENSATE	;<29>Turn on compensation flag
$nocom:	mov	bx,word ptr [bp].recsillen;<34>
	mov	cx,word ptr [bp].recthresh	;<29>
	or	cx,cx			;<29>
	jz	$reccom2		;<34>
	jns	$notneg			;<34>Is it negative?
	neg	cx			;<34>Convert to positive value
	mov	qcount,bx		;<34>Start with VOX off
$notneg:or	snd_mode2,THRESHOLD	;<29>
	mov	snd_sillen,bx		;<34>
	mov	snd_threshold,cx	;<34>Put value or zero in here
$reccom2:
	jmp	short	$reccom1


;	Here the recorder is active, so this must be an attempt to 
;	provide an additional buffer - see if this will work

$recactive:
;<5>	See if they are willing to hang around

	mov	bx,[bp].recblock	;<5>Get the flag
	or	bx,bx			;<5>
	jnz	$normblk		;<7>TRUE waits

	mov	bx,rec_depth		;<32>Get current number of buffers
					;<32>queued
	cmp	bx,rec_limit		;<32>How many do we allow?
	jc	$normblk		;<32>room if depth < limit

;<5>	Here we would block and they dont wanna, so exit.

	mov	ax,WOULDBLOCK		;<5>Note that we have been
	jmp	$recexit		;<5>from certain blocking

$normblk:
	mov	bl,sndrate		;All recordings at same rate

;	Now for common code to all recordings BX = rate to use on this
;	buffer

$reccom1:
	les	di,[bp].recaddr	;::::::::Get sound structure:::::::::::::::::::
	mov	ax,[bp].recmaxTime	;Get number of msecs to run
	or	ax,ax
	jz	$max			;Fill entire buffer
;	Resolution is at 2msec 
	shr	ax,1
	jnc	$nofudge
	inc	ax
	page
;	Here an upper length on the recording has been specified.
;	So figure out what that equals in bytes

$nofudge:
	mov	si,offset byte_per_mil
	mov	dl,[si+bx]		;Get bytes per second BX=RATE
	xor	dh,dh
	mul	dx			;AX x DX

	mov	cx,word ptr es:[di].sndblen	;Get size of memory
	mov	bx,word ptr es:[di].sndblen[2]	;Get size of memory

	cmp	bx,dx			;<2>Test upper half (first)
	jc	$badsize
	jnz	$sizeok			;<2>
	cmp	cx,ax			;<2>Lower half now
	jnc	$sizeok

;	The number of bytes needed for the time won't fit in the
;	buffer they gave us.

$badsize:
	mov	ax,BADSIZE		;Won't fit in buffer
	jmp	$recexit

$sizeok:mov	word ptr es:[di].sndlen,ax	;Make this tenative size
	mov	word ptr es:[di].sndlen[2],dx	;of the recorded sound
	jmp	short $sizcom

;	Here they want us to use all the buffer they gave us.

$max:	mov	cx,word ptr es:[di].sndblen	;Get size of memory
	mov	bx,word ptr es:[di].sndblen[2]	;Get size of memory
	or	bx,bx
	jnz	$ok64
	cmp	cx,101			;<33>
	jc	$badsize		;Don't allow real short buffers
$ok64:	mov	word ptr es:[di].sndlen,cx	;Make this tenative size
	mov	word ptr es:[di].sndlen[2],bx	;of the recorded sound

;	Now check to see if we are recording already

$sizcom:mov	al,byte ptr snd_mode	;<22>
	test	al,INRECORD
	jz	$notonyet		;This is the first call
	page
;	Okay, the recorder is active.  So all we can do is set up our
;	buffers and go

$checkhold:
	mov	al,byte ptr snd_mode	;<22>
	test	al,INRECORD
	jz	$recabort		;Someone issued a STOP

	mov	ax,rec_depth		;<32>Get current number of buffers
					;<32>queued
	cmp	ax,rec_limit		;<32>How many do we allow?
	jnc	$checkhold		;<32>Wait until space is avail.
	
;	Okay, no one is using the holding buffer, so we will load it up
;	with information on our current buffer

	pushf				;<32>
	cli	;<32>---------------------------------------------------------
	les	di,nextrec_queue	;<32>
	mov	ax,es
	or	ax,di
	jnz	$lpchn
	mov	di,word ptr [bp].recaddr	;<32>Put first buffer on
	mov	word ptr nextrec_queue,di	;<32>record chain
	mov	ax,word ptr [bp+2].recaddr	;<32>
	mov	word ptr nextrec_queue+2,ax	;<32>
	mov	es,ax			;<32>Pointer fixed-up
	jmp	short $zerochn		;<32>

$lpchn:	mov	ax,word ptr es:[di].sndchain	;<32>
	or	ax,word ptr es:[di+2].sndchain	;<32>
	jz	$endchn			;<32>
	les	di,es:[di].sndchain	;<32>Advance to next item on chain	
	jmp	$lpchn			;<32>

$endchn:mov	ax,word ptr [bp].recaddr	;<32>Add new buffer to record
	mov	word ptr es:[di].sndchain,ax	;<32>chain
	mov	ax,word ptr [bp+2].recaddr	;<32>
	mov	word ptr es:[di+2].sndchain,ax	;<32>
	les	di,es:[di].sndchain	;<32>Advance to end of next buffer
$zerochn:
	xor	ax,ax				;<32>
	mov	word ptr es:[di].sndchain,ax	;<32>Set NULL pointer
	mov	word ptr es:[di+2].sndchain,ax	;<32>

	inc	rec_depth		;<32>Note that a buffer was added
	popf	;<32>---------------------------------------------------------	

;	Okay, exit

$recabort:
$recexitok:
	xor	ax,ax

$recexit:
	pop	es	;:::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	ds	;=====================================================
	pop	di
	pop	si
	pop	bp
	ret
	page
;	First time, so start the recorder, DMA and everything else.

$notonyet:
	les	di,[bp].recaddr	;:::::::::::::::::::::::::::::::::::::::::::::
	call	rec_expand

	or	byte ptr snd_mode,INRECORD	;<22>Turn on the record flag

	mov	al,sndrate		;Program DAC rate
	dec	al			;Zero-based now
	shl	al,1			;x2
	shl	al,1			;x4
	shl	al,1			;x8
	mov	ah,machine
	add	al,ah
	xor	ah,ah
	mov	si,offset intbl
	add	si,ax
	mov	al,[si]
	mov	dx,DacBase
	inc	dx
	inc	dx			;306
	out	dx,al

	mov	dx,DacBase
	mov	al,RECMODE OR DMAIEI	;Switch into record
	out	dx,al
	mov	al,RECMODE OR DMAIEICL OR DMAIEI	;Allow interrupts
	out	dx,al
	inc	dx			;C5/305
	in	al,dx			;Read & toss sample
					;kick start approximater
	in	al,21h
	and	al,imask
	out	21h,al
	page
;	Clear LSB/MSB flip flip DMA kludge

	mov	dx,DMACLR
	mov	al,0ffh
	out	dx,al

	mov	dx,dma_mask_port
	mov	bl,dma_mask_value
	mov	al,bl
	or	al,4
	out	dx,al

	inc	dx			;dma_mode_port
	mov	al,01010101B		;Record
	or	al,bl			;Add in channel field
	out	dx,al

	mov	dx,dma_page_port
	mov	al,merrygo_phys_page
	out	dx,al

	mov	dx,dma_addr_port
	mov	ax,merrygo_phys_offs
	out	dx,al

	mov	al,ah
	out	dx,al

	inc	dx
	mov	ax,MERRYGO_SIZE_BYTES-1
	out	dx,al

	mov	al,ah
	out	dx,al
	page
;	This code eats the first few samples so that the DMA will not
;	pick them up.  The first is always wrong, the next two may
;	be wrong depending on how quickly the internal cap can slew
;	to the correct position.

	mov	dx,DacBase
	mov	cl,2			;Don't do TOO MANY
					;This is a minimum of
					;45usec x cl  delay
$nordy:	in	al,dx
	test	al,SAMPLRDY		;Approx done?
	jnz	$nordy			;ACTIVE LOW
	inc	dx
	in	al,dx			;Read & toss
	dec	dx
	dec	cl
	jnz	$nordy			;Read another

;	Okay, the first few samples have been eaten

	mov	al,RECMODE OR DMADRQ OR DMAIEICL OR DMAIEI	;Now for DMA
	out	dx,al

	mov	dx,dma_mask_port
	mov	al,dma_mask_value
	out	dx,al

	call	record_safety
	jmp	$recexitok
_snd_record	endp
	page
;	This routine takes the address in ES:DI and makes it the
;	active recording buffer

rec_expand proc NEAR
	call	round_esdi
	mov	word ptr rec_hdr,di	;Save address of header
	mov	word ptr rec_hdr[2],es	;so we can fill in length
					;in case of an abort
	push	bx			;<13>Safety expects BX intact
	mov	ax,word ptr es:[di].sndbuf	;<13>
	mov	bx,word ptr es:[di].sndbuf[2]	;<13>
	call	roundup			;<13>
	mov	word ptr rec_sndaddr,ax	;<13>
	mov	word ptr rec_sndaddr[2],bx	;<13>
	pop	bx			;<13>


	mov	al,machine
	mov	es:[di].sndbias,al	;Note where it came from
	mov	al,sndrate
	mov	es:[di].sndrecrate,al	;Note the recording rate
	mov	ax,word ptr es:[di].sndlen	;Maximum recording size
	mov	word ptr rec_len,ax
	mov	ax,word ptr es:[di].sndlen[2]	;Maximum recording size
	mov	word ptr rec_len[2],ax

	ret
rec_expand endp
	page
;	This routine handles the safety area

	public record_safety
record_safety	proc NEAR
	cld				;<11>

;	Now wait until the buffer is ready before taking action.
;	Sadly, we have to burn these cycles.

$passsafety:
	mov	dx,DMACLR
	mov	al,0ffh
	out	dx,al
	mov	dx,dma_count_port
	in	al,dx
	mov	bl,al
	in	al,dx
	mov	bh,al

	cmp	bx,MERRYGO_SPLIT
	jae	$passsafety		;<15>Was ja.

;<29>	Now we perform compensation and thresholding checks

	les	di,merrygo_buf	;==============================================
	mov	cx,SPLIT_FILL_BYTES	;<29>was WORDS
	call	rec_convert		;<29>Do it!
	jnz	$noxfer1		;<29>Don't perform transfer

;<29>	The data has been adjusted and is to be recorded
;	Now, how much room have we got?

	mov	si,word ptr rec_len[2]	;How many bytes left in 
	or	si,si			;the user buffer
	jnz	$dosafe			;Lots, so skip this
	mov	cx,word ptr rec_len	;the user buffer
	cmp	cx,SPLIT_FILL_BYTES	;Less than safety?
	jc	$safetyexhaust		;then lots of work to do

;	There are more than 4 bytes requested to be filled at this
;	point, so transfer the full safety area.

$dosafe:mov	cx,SPLIT_FILL_BYTES	;<29>was WORDS

;	DMA has cleared the safety area 

	les	di,rec_sndaddr	;::::::::::::::::::::::::::::::::::::::::::::::
	push	ds			;<29>
	lds	si,merrygo_buf	;==============================================
	call	snd_fragmove		;<29>Transfer data
	pop	ds		;==============================================
	call	round_esdi
	mov	word ptr rec_sndaddr,di	;Store updated pointer
	mov	word ptr rec_sndaddr[2],es

	mov	ax,SPLIT_FILL_BYTES
	call	rec_count		;Store updated length
	jz	$full			;All done
$noxfer1:
	ret

$full:	call	get_rec_next		;See if another buffer is ok
	jz	$stoprec		;No, out of buffers
	ret				;New buffer selected


;	This code runs if a buffer ends in the middle of the safety area
;	We transfer what will fit, then try to get another buffer.
;	If the user has not called with another one, we stop.
;	If a new buffer is available, It becomes the current buffer and
;	the remaining bytes are transferred.

$safetyexhaust:
	les	di,rec_sndaddr	;::::::::::::::::::::::::::::::::::::::::::::::
	push	ds			;<29>
	lds	si,merrygo_buf	;==============================================
	mov	bx,cx			;Save a copy of length
	call	snd_fragmove		;<29>Move part of safety area
	mov	ax,ds
	pop	ds	;======================================================
	mov	word ptr rec_frag,si	;<2>Point to remaining amount
	mov	word ptr rec_frag[2],ax	;<2>in circular queue
	call	get_rec_next		;Get buffer in queue
	jz	$stoprec		;No more buffers, stop

	mov	cx,SPLIT_FILL_BYTES	;<2>Size of circular queue
	sub	cx,bx			;<2>Subtract amount we did
	mov	bx,cx			;<2>and get amount to do 
					;<2>this time.

	les	di,rec_sndaddr	;::::::::::::::::::::::::::::::::::::::::::::::
	push	ds
	lds	si,rec_frag	;========Start here============================
	call	snd_fragmove		;<29>Xfer rest of safety area
	pop	ds		;==============================================
	call	round_esdi
	mov	word ptr rec_sndaddr,di	;Store updated pointer
	mov	word ptr rec_sndaddr[2],es

	mov	ax,bx
	call	rec_count
	jz	$full			;Time to switch buffers
	ret

;	Here there are no more buffers, so stop the hardware
;	When we get here, the last user buffer should be complete
;	(all bytes transferred, fields correct, etc.)

$stoprec:
	call	snd_dma_stop		;<30>STOP DMA
	and	byte ptr snd_mode,NOT (INRECORD)	;<32>
					;<22>Turn off RECORD flag
	ret

;	Handle swapping from one buffer to the next

get_rec_next:
	pushf
	cli	;--------------------------------------------------------------
	les	di,nextrec_queue	;<32>Get pointer
	mov	ax,es			;<32>
	or	ax,di			;<32>Is it a null pointer
	jz	$outtaspace		;<32>Time to stop then

	push	es			;<32>
	les	ax,es:[di].sndchain	;<32>Read next pointer
	mov	word ptr nextrec_queue,ax	;<32>Put second buffer at top
	mov	word ptr nextrec_queue+2,es	;<32>of chain
	pop	es			;<32>
	dec	rec_depth		;<32>Decrement depth count

	call	rec_expand		;<32>Process new buffer
	or	al,1			;Prepare NZ state

$outtaspace:
	popf	;--------------------------------------------------------------
	or	al,al			;Set Z flag
	ret


record_safety	endp
	page
rec_count	proc	near
	mov	cx,word ptr rec_len	;Store updated length
	mov	bx,word ptr rec_len[2]
	sub	cx,ax			;Count to decrement
	jnc	$norm

;	LSW has gone negative - there had better be a place to go

	or	bx,bx			;Is this the end?
	jz	$bug			;INDICATES BUG!!!!
	mov	word ptr rec_len,cx
	dec	bx			;<11>Adjust MSW before writing
	mov	word ptr rec_len[2],bx
	or	al,1			;Force NZ state
	ret				;Exactly 64K to go

;	LSW is non-negative, so check it and MSW for zeroness
$norm:	mov	word ptr rec_len,cx
	mov	word ptr rec_len[2],bx
	mov	ax,bx
	or	ax,cx
	ret				;Z buffer is full,
					;NZ more space remaining
$bug:	mov	word ptr rec_len,cx
	mov	word ptr rec_len[2],bx
	ret				;Z buffer is full
rec_count	endp
	page
;------------------------------------------------------------------------------
;	rec_convert	- performs compensation and thresholding checks
;
;	Accepts		COMPENSATE and THRESHOLD flags in snd_mode
;		CX	Number of bytes to process
;		ES:DI	Address of data
;
;	Returns
;		AX	(THRESHOLD mode only)
;			0 = Buffer should be recorded
;			!0= Buffer should not be recorded
;		Z	Buffer should be recorded
;		NZ	Buffer should not be recorded
;		BX	Unchanged
;		CX	Unchanged
;		DX	Unchanged
;		SI	trash
;------------------------------------------------------------------------------

	public	rec_convert
rec_convert	proc	near
	push	cx
	push	bx			;<33>
	push	dx			;<34>

	xor	bh,bh			;<30>
	mov	bl,sndrate		;<30>Get recording rate
	shl	bl,1			;<34>Word
	add	bx,offset ticktbl	;<30>
	xor	dx,dx			;<34>Zero MSW
	mov	ax,cx			;<34>Get byte count
	add	ax,word ptr snd_residue	;<34>Left-overs from last time
	mov	bx,[bx]			;<34>Get value in a register
					;<34>So divide will be faster
	div	bx			;<34>Divide by bytes per tick
	mov	si,ax			;<34>Put new tick count here
					;<34>residue is in DX - DONT LOSE

	mov	ax,snd_mode2
	test	ax,COMPENSATE OR THRESHOLD
	jnz	$modea
$dexit:	mov	qcount,0		;Reset quiet counter
$cexit:	add	word ptr _snd_clock,si	;<34>Advance clock
	mov	word ptr snd_residue,dx	;<34>Save this for next time

	pop	dx			;<34>
	pop	bx			;<33>
	pop	cx
	xor	ax,ax
	ret				;Should not have entered, just exit

;	At least one of the options was selected

$modea:	test	ax,COMPENSATE
	jz	$tronly			;Threshold check only
	test	ax,THRESHOLD
	jnz	$comtr			;Have to do both - yucko

;	Here we only have to perform compensation

	push	ds
	lds	bx,snd_adjtbl		;Get previous parm
					;NO CHECK FOR VALID POINTER - 
					;presence of flag implies this was done

$cmp1:	mov	al,byte ptr es:[di]	;Read a byte
	xlatb				;Convert it
	stosb				;Store it back and increment pointer
$cmp2:	loop	$cmp1			;Do next
	pop	ds
	jmp	$dexit			;All done, get out
	page
;	Here we want to do both compensation and threshold detection
;	this is the slowest combination

$comtr:	mov	ah,byte ptr snd_threshold	;Value to key on
	push	ds
	lds	bx,snd_adjtbl		;Get previous parm
$comlp:	mov	al,byte ptr es:[di]	;Read a byte
	xlatb				;Convert it
	stosb				;Store it back and increment pointer
	sub	al,80h			;Make zero-based
	jnc	$abv			;was 0x80 or greater, now 0-0x7f
	neg	al			;Make all values positive
$abv:	cmp	al,ah			;Threshold value
	jnc	$cmp2			;Value is equal or greater than trigger
					;The threshold check need not continue
					;so revert to just performing compensate
	loop	$comlp			;Keep processing and searching
	pop	ds
$isquiet:
	mov	ax,qcount
	cmp	ax,snd_sillen		;Have we been silent long enough?
	jnc	$still			;<34>Still silent

;	Bump counter based on current sampling rate slower==more time ticks

	add	ax,si			;Computed on entry!  DO not disturb
	mov	qcount,ax		;Update counter
	cmp	ax,snd_sillen		;<34>Have we been silent long enough?
	jc	$cexit			;<34>Not long enough

;Here, we have been silent the required amount, so return "no write" signal

$still:	or	ax,1			;Signal that threshold was not reached
	pop	dx			;<34>
	pop	bx			;<33>
	pop	cx
	ret
	page
;	They only want threshold detection

$tronly:mov	ah,byte ptr snd_threshold	;Value to key on
$comlp1:mov	al,es:[di]		;Read a byte
	inc	di
	sub	al,80h			;Make zero-based
	jnc	$abv1			;was 0x80 or greater, now 0-0x7f
	neg	al			;Make all values positive
$abv1:	cmp	al,ah			;Threshold value
	jnc	$dexit			;Value is equal or greater than trigger
					;so stop
	loop	$comlp1			;Keep processing and searching
	jmp	$isquiet		;Signal threshold was not reached
rec_convert	endp

sndseg	ends
	end

