	page	60,132
;-----------------------------------------------------------------------------
;	Init.Asm - Snd_Init()  Initialize the PSSJ Digital Sound Toolkit
;			drivers and functions.
;			One chore is to go through the callers buffer list
;			looking for a buffer to use for the DMA buffer (must
;			not span 64k boundary).  Because this call is made
;			before anything happens, rampup must occur later
;			after caller has a chance to set volume.
;	Snd_Init is part of the PSSJ Digital Sound Toolkit.
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	_snd_exit:FAR
	extrn	player_irq:NEAR
	extrn	snd_play_on:NEAR
	extrn	round_esdi:NEAR
	extrn	_snd_version:FAR	;<36>
	extrn	_snd_clock:word
	extrn	snd_residue:word	;<34>
	extrn	_snd_clock_t:word

MAKEINIT=1
	include	external.inc
	include	sound.inc

	public	machine,imask,iirq	;<32>
snddata	segment public	'DATA'
machine	db	0
imask	db	0
iirq	db	0			;<32>
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata
	public	_snd_init
_snd_init	proc far		;(init_trigger,init_dma_chan,
					; init_irq,options)
	push	bp
	mov	bp,sp
	push	si
	push	di

	push	ds
	mov	ax,snddata
	mov	ds,ax		;=============================================
	assume	DS:snddata

	mov	al,byte ptr snd_mode	;<22>Only thing we rely on
	xor	al,UNINITIALIZED
	jz	$ok			;Okay
	call	_snd_exit

;	Determine where the sound hardware is
;	This is done entirely different starting with Edit 18.

$ok:	mov	ax,8100h		;<18>Issue a status command to
	int	1ah			;<18>the sound BIOS call
	cmp	ah,80h			;<18>See what the result is
	jc	$maybe			;<18>There may be iron
	page
;<18>	No reasonable response from the stub - assume no hardware
;<18>	However, this forces you to load the stub on adapter systems
;<18>	even though we never use it.  So for now assume add-on board at
;<18>	old port range and let the other checks catch it.

;<18>	mov	ax,NOIRON		;<18>Prepare for failure
;<18>	jmp	$abtexit		;<18>and exit
	mov	ax,0304h		;<18>Add-on board range for now

;<18>	Here the BIOS has returned something in AX - by the treaty of
;<18>	1989, we are to consider this value to be the base port number

$maybe:	mov	DacBase,ax		;<18>Set address

;<18>	Now, make sure the hardware is there
;	We run this test even if it is a TL or SL - chip may be missing
;	or faulty.

	pushf
	cli	;--------------------------------------------------------------
	mov	dx,ax
	inc	dx
	inc	dx
	in	al,dx			;C6/306
	mov	ah,al			;Save old value
	not	al			;make test value
	out	dx,al			;Invert whatever it is
	mov	bh,al			;Save that
	dec	dx			;305
	in	al,dx			;Force different I/O cycle
	inc	dx			;306
	in	al,dx
	cmp	bh,al			;Should be indentical
	mov	al,ah
	out	dx,al			;Put old value back
	jz	$hdok			;Hardware appears to be there

	popf	;--------------------------------------------------------------
	mov	ax,NOIRON		;<18>Prepare for failure
	jmp	$abtexit		;<18>and exit
	page
;	Turn off the TI sound stuff so it will quit hooting

$hdok:	mov	dx,DacBase		;C4/304
	sub	dx,SNDCHNL		;Amount to fudge (4)
	mov	al,0ffh
	out	dx,al			;C0/300
	mov	al,0bfh
	out	dx,al			;C0/300
	mov	al,0dfh
	out	dx,al			;C0/300
	mov	al,09fh
	out	dx,al			;C0/300

	mov	dx,DacBase		;Put in joystick mode
	mov	al,DMAIEI		;Take irqs out of TRISTATE
	out	dx,al			;C4/304
	xor	ax,ax
	add	dx,3			;C7/307
	out	dx,al			;Set volume to zero
	popf	;--------------------------------------------------------------

;<18>	Now, we need to determine if we have the new PSSJ chip.  If we
;<18>	do not, then we must determine the machine type so we can skew
;<18>	accordingly.

;<18>	The agreed-on test is to load two values into Bit 4 of C7/307.
;<18>	If it is always the same, it is the old version.
;<18>	Differences indicate newer revisions of the chip (as yet non-existant)

	mov	dx,DacBase		;<18>
	inc	dx			;<18>
	inc	dx			;<18>
	inc	dx			;<18>
	xor	ch,ch			;<18>
	in	al,dx			;<18>
	or	al,10h			;<18>Set bit
	out	dx,al			;<18>
	in	al,dx			;<18>
	test	al,10h			;<18>
	jz	$differ1		;<18>
	or	ch,2			;<18>
$differ1:				;<18>
	and	al,0efh			;<18>Force bit clear
	out	dx,al			;<18>
	in	al,dx			;<18>
	test	al,10h			;<18>
	jz	$differ2		;<18>
	or	ch,1			;<18>
	page
$differ2:				;<18>
	cmp	ch,2			;<18>If CH=2, then old chip
	je	$oldchip		;<18>
	cmp	ch,1			;<18>Revision 2
	je	$chipr2			;<18>New (1989) chip
	cmp	ch,3			;<18>Revision 3
	je	$chipr2			;<18>

;<18>	Must be revision 4

$chipr2:mov	cl,M1KSLTL2		;<27>No skewing needed
	jmp	short	$loccom		;<18>


;<18>	The bit stayed matched what we wrote both times, so we have an old
;<18>	chip.  So we must ask the BIOS what we are.  This is old code.

$oldchip:				;<18>
	mov	ah,0c0h
	int	15h
	mov	cl,M3000
	jc	$loccom
	cmp	byte ptr es:[bx+2],0ffh
	jnz	$loccom

;	We have a SL or TL

	mov	cl,M1000SL
	cmp	byte ptr es:[bx+3],0	;1988/89 SL
	jz	$loccom
	mov	cl,M1000TL
	cmp	byte ptr es:[bx+3],1	;1988 TL
	jz	$loccom
	cmp	byte ptr es:[bx+3],5	;1989 TL
	jz	$loccom
	mov	cl,M3000

$loccom:mov	machine,cl		;Save machine type
	page
;	Initialize all data areas
;	Some of this is overkill and should be removed

	xor	ax,ax			;<18>Needed again
	mov	word ptr req_len,ax
	mov	word ptr req_len[2],ax
	mov	word ptr ld_buf,ax
	mov	word ptr ld_buf[2],ax
	mov	_snd_clock,ax		;<30>Reset the clock
	mov	snd_residue,ax		;<34>Reset the clock
	mov	_snd_clock_t,ax		;<30>Reset the clock
	mov	ld_rate,al
	mov	word ptr srcbuf,ax
	mov	word ptr srcbuf[2],ax
	mov	sndrate,al
	mov	word ptr queue_play,ax
	mov	word ptr queue_play[2],ax
	mov	word ptr queue_last,ax
	mov	word ptr queue_last[2],ax
	mov	dma_ticket,ax
	mov	dma_bias,al
	mov	dma_trip,al

	mov	al,80h
	mov	emptyfill,al
	mov	ld_last_sample,al

	mov	ax,0ffffh
	mov	curticket,ax


	les	di,queue_free		;Get free list
	mov	ax,es
	or	ax,di			;Did we get a NULL pointer
	jz	$invalid		;Abort - nothing allocated yet
	page
;	We have a pointer to the first block.  Check the address

	call	round_esdi		;Force to nearest paragraph
	mov	word ptr queue_free,di	;Store converted form
	mov	word ptr queue_free[2],es

;	Now scan through the buffers searching for one to use as the
;	DMA buffer

	lea	si,queue_free		;Point at queue_free pointer
					;(Pretend it is a block for a sec)
	push	ds

$lookat:mov	ax,es
	and	ah,0fh			;Lose upper nibble
	add	ax,(MERRYGO_SIZE_BYTES+HEADER_SIZE)/16	;See if buffer spans
	test	ah,0f0h			;Are any upper bits on?
	jz	$foundbuf		;This buffer will not span

	mov	ax,es
	mov	ds,ax
	mov	si,di			;Save previous pointer

	les	di,es:[di].play_buf_next;Get next buffer
	mov	ax,es
	or	ax,di
	jz	$allspan		;All buffers span?
	jmp	short  $lookat

;	When things go wrong

$allspan:
	mov	ax,INITDMA		;No buffers could be used for DMA
	pop	ds
	jmp	$abtexit

$invalid:
	mov	ax,INITBUF		;Failed on buffer error
	jmp	$abtexit
	page
;	Here we have located a buffer.  Now remove it from the free-chain

$foundbuf:
	push	es
	push	di			;Save pointer to DMA buffer
	les	di,es:[di].play_buf_next
	mov	word ptr [si].play_buf_next,di		;Point previous at next
	mov	word ptr [si].play_buf_next[2],es
	pop	di
	pop	es			;Get back DMA buffer
	pop	ds			;Get back snddata
	xor	ax,ax
	mov	word ptr es:[di].play_buf_next,ax
	mov	word ptr es:[di].play_buf_next[2],ax	;Zero next pointer

	add	di,HEADER_SIZE		;Until we exit, point to actual
					;start of data
	mov	word ptr merrygo_buf,di
	mov	word ptr merrygo_buf[2],es	;Store buffer to use for DMA
	
;	Now compute all the other items the DMA will need to know.

	mov	ax,es			;Get segment
	mov	bh,ah
	shl	ax,1
	shl	ax,1
	shl	ax,1
	shl	ax,1
	add	ax,di			;Get real address (di should be 0-15)
					;We already checked for carry
	mov	merrygo_phys_offs,ax	;Store DMA starting offset
					;Header already skipped above
	shr	bh,1
	shr	bh,1
	shr	bh,1
	shr	bh,1
	mov	merrygo_phys_page,bh	;Store 64K page number for DMA

;	Now handle remaining initialization tasks

	xor	ax,ax
	mov	word ptr queue_play,ax
	mov	word ptr queue_play[2],ax	;Set play queue to null

	mov	ax,[bp].init_trigger	;Get play threshold
	mov	dma_trip,al		;Store the number
	mov	ax,[bp].init_options	;Get switch option
	xor	bx,bx
	test	al,1
	jz	$nofast
	or	bx,FASTRAMP
$nofast:mov	snd_mode2,bx
	page
;	Get the interrupt vector and DMA channel

	mov	ax,[bp].init_dma_chan
	or	al,al
	jz	$setone			;Default
	cmp	al,1
	jz	$setone
	cmp	al,3
	jz	$setthree

;	Sorry, don't know about any other channels

	mov	ax,BADDMA
	jmp	$abtexit

$setone:mov	ax,1
	mov	dma_mask_value,al	;1
	inc	ax
	mov	dma_addr_port,ax	;2
	inc	ax	
	mov	dma_count_port,ax	;3
	mov	ax,83h
	mov	dma_page_port,ax	;83h
	jmp	short $dmacom1

$setthree:
	mov	ax,3
	mov	dma_mask_value,al	;3
	mov	ax,6
	mov	dma_addr_port,ax	;6
	inc	ax	
	mov	dma_count_port,ax	;7
	mov	ax,82h
	mov	dma_page_port,ax	;82h

	page
;	Now set up interrupt stuff (tm)

$dmacom1:
	mov	ax,[bp].init_irq
	or	al,al
	jnz	$chkirqs
	mov	al,7			;Default setting
	jmp	short $irqset
$chkirqs:
	cmp	al,02
	jb	$badirq
	cmp	al,06
	jz	$badirq
	cmp	al,07
	ja	$badirq

;	ISR requested is valid (I guess)  Hook into chain
	
$irqset:mov	iirq,al			;<32>Need plain IRQ in some places
	mov	cl,al
	xor	ch,ch
	stc
	inc	cl			;Ones based
	rcl	ch,cl
	not	ch			;Make a mask
	mov	imask,ch

	shl	al,1			;x2
	shl	al,1			;x4
	xor	ah,ah
	add	ax,20h			;Start of this in MS-DOS systems
	mov	di,ax			;Location of IRQ vector n
	mov	irq_vect_addr,di	;Store address for when we pull out

	xor	bx,bx
	mov	es,bx			;IRQ's are in segment 0, of course
	pushf
	cli	;--------------------------------------------------------------
	mov	cx,es:[di]
	mov	dx,es:[di+2]		;Get old vector

	mov	ax,offset player_irq	;Our routine
	mov	es:[di],ax
	mov	es:[di+2],cs		;Our segment

	mov	word ptr cs:irq_next_task,cx
	mov	word ptr cs:irq_next_task[2],dx

	mov	al,20h			;Reset interrupt controller
	out	20h,al
	popf	;--------------------------------------------------------------
	page
;	Now finish up
	
	xor	ax,ax			;<22>Clear all flags
	mov	word ptr snd_mode,ax	;<22>NOT UNINITIALIZED

$abtexit:
	pop	ds
	pop	di
	pop	si
	pop	bp
	ret				;NEAR or FAR
	call	_snd_version		;<36>Force string into memory
					;<36>YES, I KNOW WE DON'T GET HERE

$badirq:mov	ax,BADIRQ
	jmp	short	$abtexit
_snd_init	endp
sndseg		ends
		end

