	page	60,132
;-----------------------------------------------------------------------------
;	Decompr.asm - Snd_Decompress_Part() - Decompress a block of sound
;	Snd_Decompress_Part is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	.lall
	extrn	round_esdi:near

	public	STATE_INIT

snddata	segment	'DATA'
EOF_flag	dw	0		;EOF flag
curbufcount	dw	0		;current buffer count
curbufptr	dd	0		;current buffer pointer
stateptr	dw	?		;state pointer
blanks		dw	?		;remaining blanks to deliver
snddata	ends

sndseg	segment	public	'CODE'
	assume	cs:sndseg

;	_st_decompress_start()
;	Initializes a decompression

	public _st_decompress_start
_st_decompress_start PROC far 		;uses ds
	push	ds
	mov	ax,snddata		;set up data segment
	mov	ds,ax
	assume	ds:snddata	;::::::::::::::::::::::::::::::::::::::::::::::

	mov	ax,0
	mov	EOF_flag,ax		;clear EOF flag
	mov	curbufcount,ax		;clear current buffer count
	mov	WORD PTR (curbufptr),ax	;clear current buffer pointer
	mov	WORD PTR (curbufptr+2),ax
	mov	stateptr,OFFSET STATE_INIT ;initialize state
	mov	blanks,ax		;blank count
	pop	ds
	ret
_st_decompress_start ENDP

;	_st_decompress_supply_buffer(src, srclen)

@codesize	equ	1

supbuf	struc			;_st_decompress_supply_buffer(src,srclen)
	dw	?
	dw	(@codesize+1) dup (?)
src	dd	?
srclen	dw	?
supbuf	ends

	public	_st_decompress_supply_buffer
_st_decompress_supply_buffer PROC far	;uses ds es di, src:FAR PTR, srclen:WORD
	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	di
	mov	ax,snddata		;set up data segment
	mov	ds,ax
	assume	ds:snddata	;::::::::::::::::::::::::::::::::::::::::::::::

	mov	ax,curbufcount		;Still working on buffer?
	or	ax,ax
	jnz	reterror		;Yes, error.

	mov	ax,[bp].srclen		;Is this an EOF?
	or	ax,ax
	jnz	noteof			;No.

					;Yes.
	mov	EOF_flag,1		;EOF_flag = 1
	xor	ax,ax			;return 0
	jmp	exit
noteof:	les	di,[bp].src		;get current buffer pointer
	call	round_esdi
	mov	WORD PTR curbufptr,di	;set current buffer pointer
	mov	WORD PTR curbufptr+2,es	
	mov	ax,[bp].srclen
	mov	curbufcount,ax		;set count
	xor	ax,ax
		
exit:	pop	di
	pop	es
	pop	ds
	pop	bp
	ret

reterror:
	mov	ax,-1			;return error
	jmp	exit
_st_decompress_supply_buffer ENDP


getdat	struc			;_st_decompress_supply_buffer(src,srclen)
	dw	?
	dw	(@codesize+1) dup (?)
dest	dd	?
destlen	dw	?
getdat	ends

	public	_st_decompress_get_data
_st_decompress_get_data PROC far ;uses ds es di bx, dest:FAR PTR, destlen:WORD
count	equ	2			;REALLY SHOULD BE A STRUC
	push	bp
	mov	bp,sp
	sub	sp,2
	push	ds
	push	es
	push	di

	mov	ax,snddata		;set up data segment
	mov	ds,ax
	assume	ds:snddata	;::::::::::::::::::::::::::::::::::::::::::::::

	xor	ax,ax
	mov	[bp-count],ax

loop1:	mov	ax,[bp].destlen
	dec	ax
	mov	[bp].destlen,ax
	cmp	ax,0FFFFh		;done?
	jz	retcount

	call	FAR PTR _st_decompress_get_byte
	cmp	ax,0ffffh		;EOF?
	jz	retcorcount
	cmp	ax,0fffeh		;MOREDATA?
	jz	retcorcount

	les	di,[bp].dest		;*dest++ = c
	mov	es:[di],al
	mov	ax,es
	add	di,1
	jnc	nc1
	add	ah,10h			;propagate carry
nc1:	mov	WORD PTR [bp].dest,di
	mov	WORD PTR [bp+2].dest,ax

	inc	word ptr [bp-count]	;count++
	jmp	loop1

retcorcount:
	mov	bx,[bp-count]
	or	bx,bx
	jnz	retcount
	pop	di
	pop	es
	pop	ds
	mov	sp,bp
	pop	bp
	ret
retcount:
	mov	ax,[bp-count]
	pop	di
	pop	es
	pop	ds
	mov	sp,bp
	pop	bp
	ret
_st_decompress_get_data ENDP	
	

	public	_st_decompress_get_byte
_st_decompress_get_byte	PROC far 		;uses ds es si di cx
;	Register usage

;	es:si	Source pointer
;	cx	count of source bytes left
;	dx	scratch for getbyte/putbyte normalization
;	ax	scratch, in/out register for getbyte/outbyte macros
;	stateptr	continuation location
;	blanks		silence counter

getbyte	MACRO
	local	foo,foo2
	sub	cx,1			;decrement remaining count
	jnc	foo2
	jmp	bufempty
foo2:	mov	al,es:[si]		;get the byte
	inc	si			;advance pointer
	jnz	foo			;propogate carry
	mov	dx,es
	add	dh,10h
	mov	es,dx
foo:
	ENDM

	push	bp
	mov	bp,sp
	sub	sp,2
	push	ds
	push	es
	push	si
	push	di
	mov	ax,snddata		;set up data segment
	mov	ds,ax
	assume	ds:snddata	;::::::::::::::::::::::::::::::::::::::::::::::

	les	si,curbufptr
	mov	cx,curbufcount
	jmp	[stateptr]

SET_INIT:
	mov	dx,OFFSET STATE_INIT
	mov	stateptr,dx
STATE_INIT	LABEL	NEAR
	getbyte
SET_IN2:mov	dx,OFFSET STATE_IN2
	mov	stateptr,dx		;set state
STATE_IN2:
	getbyte
SET_IN3:mov	dx,OFFSET STATE_IN3
	mov	stateptr,dx		;set state
STATE_IN3:
	getbyte
SET_IN4:mov	dx,OFFSET STATE_IN4
	mov	stateptr,dx		;set state
STATE_IN4:
	getbyte

SET_NORM:
	mov	dx,OFFSET STATE_NORM
	mov	stateptr,dx		;set state
STATE_NORM:
	getbyte
	cmp	al,0fbh
	jz	SET_FB
	cmp	al,0fch
	jz	SET_FC
	cmp	al,0fdh			;short silence prefix
	jz	SET_FD
	cmp	al,0feh			;long silence prefix
	jz	SET_FEa
	mov	ah,0
	jmp	return

SET_FEa:jmp	SET_FE


;	fc prefix seen

SET_FC:	mov	dx,OFFSET STATE_FC
	mov	stateptr,dx		;set state
STATE_FC:
	getbyte
	mov	dx,OFFSET STATE_NORM
	mov	stateptr,dx
	cmp	al,0			;FC 00 (EOF)
	jz	reteofa
	cmp	al,1
	jz	SET_NORM		;FC 01 (BOF) ignore
	neg	al			;else return two's complement
	mov	ah,0
	jmp	return
reteofa:mov	ax,1
	mov	EOF_flag,ax
	jmp	SET_EOF


;	fd prefix seen

SET_FD:	mov	dx,OFFSET STATE_FD
	mov	stateptr,dx		;set state
STATE_FD:
	getbyte
	mov	ah,0
	add	ax,3
	mov	blanks,ax		;set blank count
	jmp	SET_BLK


;	fb prefix seen

SET_FB: mov	dx, OFFSET STATE_FB
	mov	stateptr,dx		;set state
STATE_FB:
	getbyte				;throw byte away
SET_NORMa:
	jmp	SET_NORM


;	fe prefix seen

SET_FE:	mov	dx,OFFSET STATE_FE
	mov	stateptr,dx		;set state
STATE_FE:
	getbyte
	inc	al
	mov	ah,254
	mul	ah			;(N+1)*254
 	mov	blanks,ax		;set blank count
	jmp	SET_BLK			;go output silence

bufempty:
	mov	ax,-2			;MOREDATA
	add	ax,EOF_flag		;EOF if EOF_flag set to 1
	xor	cx,cx			;empty buffer
	jmp	return

SET_EOF:mov	dx,OFFSET STATE_EOF
	mov	stateptr, dx		;set state
STATE_EOF:
reteof:	mov	ax,-1			;EOF
return: mov	curbufcount,cx
	mov	WORD PTR (curbufptr),si
	mov	WORD PTR (curbufptr+2),es

	pop	di
	pop	si
	pop	es
	pop	ds
	mov	sp,bp
	pop	bp
	ret


;	Outputting silence

SET_BLK:mov	dx,OFFSET STATE_BLK
	mov	stateptr,dx		;set state
STATE_BLK:
	mov	ax,080h			;silence
	mov	dx,blanks		;decrement silence counter
	sub	dx,1
	mov	blanks,dx
	jc	SET_NORMa		;all done; get next code
	jmp	return


_st_decompress_get_byte ENDP
sndseg	ends
	end

