	page	60,132
;-----------------------------------------------------------------------------
;	Cue.asm - Snd_Cue  Gets the hardware ready for whatever you are doing
;		  Snd_Cue is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;
;	Accepts:	(mode to enter)
;
;	Returns:	No result
;-----------------------------------------------------------------------------
	extrn	snd_play_on:NEAR
	extrn	snd_play_off:NEAR

	include	external.inc

	include	sound.inc

snddata	segment	public	'DATA'
snddata	ends
	page	
sndseg	segment public 'CODE'
	assume 	cs:sndseg

;------------------------------------------------------------------------------

	public _snd_cue
_snd_cue	proc  far
	push	bp
	mov	bp,sp
	push	ds
	mov	ax,snddata
	mov	ds,ax
	assume ds:snddata


	mov	ax,snd_mode		;<30>
	test	ax,INPLAY OR INRECORD OR UNINITIALIZED OR DISKPLAY OR DISKRECORD	;<30>
	jnz	$fail

	mov	ax,[bp+6]		;Get Flag
	cmp	al,TORECORD		;
	jz	$dorecord
	cmp	al,TOPLAY
	jz	$doplay

$fail:	mov	ax,INVALID
	pop	ds
	pop	bp
	ret

$dorecord:
	mov	al,byte ptr snd_mode	;<22>
	test	al,RAMPUP		;<17>was BIAS and that is wrong
	jz	$done
	call	snd_play_off

$done:	xor	ax,ax
	pop	ds
	pop	bp
	ret
	page
$doplay:
	mov	al,byte ptr snd_mode	;<22>
	test	al,RAMPUP		;<17>was BIAS and that is wrong
	jz	$doit
	mov	al,db_level		;If it is set for play,
	cmp	al,cur_db_level		;check for a gain level
	jz	$done			;change - if same exit
	call	snd_play_off		;New gain, turn play off
$doit:	call	snd_play_on		;Switch to play
	jmp	short $done

_snd_cue	endp
sndseg		ends
	end

