.if t  .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 15th, 1994\"
.TH SND_WAIT PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_WAIT troff documentation \- Version 1(7) 15\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.SH Name
.br
snd_wait, snd_buf_wait \- Determine player/recorder status.

.SH Syntax
.br
.B short far snd_wait(options, (short) 0, wait);
.br
.B unsigned short options;
.br
.B unsigned short wait;
.br
.sp
.B short far snd_buf_wait(pSound, wait);
.br
.B SNDHDR far *pSound;
.br
.B unsigned short wait;
.br

.SH Description
\fISnd_wait\fR returns information on how long a
play or record operation has been in progress and whether the sound
hardware is performing operations or is idle at a given moment.

If \fIoptions\fR is \fBFALSE\fR and \fIwait\fR is \fBTRUE\fR,
\fIsnd_wait\fR will not return until playback or recording has
stopped.  (See Notes).

If \fIoptions\fR is \fBFALSE\fR and \fIwait\fR is \fBFALSE\fR,
\fIsnd_wait\fR will return immediately with \fBFALSE\fR if the
player/recorder is no longer running.  If player or recorder is currently
running, \fIsnd_wait\fR will return the amount of time the toolkit 
has been playing or recording in hundreds of milliseconds.  The elapsed
time counter resets to zero when the player/recorder stops.  For example,
if a sound has been playing for 3 minutes and 15.7 seconds,
\fIsnd_wait\fR would return \fB1957\fR  (3 min x 60 sec/min =
180 + 15.7 = 195.7 seconds).
This can be used to display the equivalent of a tape counter and if the
amount of available disk space was computed earlier, that value combined
with the recording time can be used to alert the user that recording must
end in a certain amount of time.

If \fIoptions\fR is non-zero and \fIwait\fR is \fBTRUE\fR,
\fIsnd_wait\fR will not return until the time the playback or
recording has run equals or exceeds the time specified in \fIoptions\fR
(in hundreds of milliseconds.)  Returns \fBFALSE\fR immediately if the
player/recorder is not running.

If \fIoptions\fR is non-zero and \fIwait\fR is \fBFALSE\fR,
\fIsnd_wait\fR will return immediately with \fBFALSE\fR if the time
specified in \fIoptions\fR has not been reached or if the player/recorder
is not running.  It returns \fBTRUE\fR if the specified time has been
reached or exceeded.

\fISnd_wait\fR can be used with \fIsnd_play\fR(PSSJ),
\fIsnd_file_play\fR(PSSJ), 
\fIsnd_file_record\fR(PSSJ) or
\fIsnd_record\fR(PSSJ).
.if t .sp
.if n .bp
\fISnd_buf_wait\fR allows applications to determine when
a particular buffer of sound data is being played or a particular buffer
is being used for recording.
This can provide tighter synchronization than the elapsed counter that
the \fIsnd_wait\fR function provides.

If \fIpSound\fR is a pointer to a play structure and \fIwait\fR is equal
to \fBTRUE\fR, \fIsnd_buf_wait\fR will wait until the beginning of that
sound is within approximately 100 msec. of being played, and then
return \fBTRUE\fR.
If the sound is not on the play queue (perhaps it has already started
playing), \fIsnd_buf_wait\fR returns \fBTRUE\fR immediately.

If \fIpSound\fR is \fBNULL\fR and \fIwait\fR is \fBTRUE\fR,
\fIsnd_buf_wait\fR waits for all sounds to be completely played or for
all recording buffers to be filled and then \fIsnd_buf_wait\fR returns
\fBTRUE\fR.
.if t .bp
.if n .sp
If \fIpSound\fR is a pointer to a play structure and \fIwait\fR is
\fBFALSE\fR, \fIsnd_buf_wait\fR will return \fBTRUE\fR if the beginning
of that sound is within approximately 100 msec. of being played, it has
already started playing, or it has been played already.  It will return
\fBFALSE\fR otherwise.

If \fIpSound\fR is \fBNULL\fR and \fIwait\fR is equal to \fBFALSE\fR, 
\fIsnd_buf_wait\fR will return a non-zero value if the player or
recorder is running, and \fBFALSE\fR if not.

The \fIpSound\fR parameter is ignored while the driver is in the record
mode.

If the caller queues a single (or the first) sound buffer and then calls 
\fIsnd_buf_wait\fR with \fIpSound\fR pointing to the first sound and
\fIwait\fR equal to TRUE, \fIsnd_buf_wait\fR will call
\fIsnd_flush(PSSJ)\fR which assures that the player starts.
\fISnd_buf_wait\fR then returns immediately since the player is always
started when \fIwait\fR is \fBTRUE\fR.  The second and subsequent sounds
on the queue can be waited on, provided sufficient sound buffers were
provided via the \fIsnd_addbuf\fR(PSSJ) call.  See the
\fIsnd_addbuf\fR(PSSJ) description for information on computing the
appropriate number of buffers.

\fISnd_buf_wait\fR can be used with \fIsnd_play\fR(PSSJ) or
\fIsnd_record\fR(PSSJ) functions.  \fISnd_buf_wait\fR cannot be used
with \fIsnd_file_play\fR(PSSJ) or \fIsnd_file_record\fR(PSSJ) functions.

.SH Return Values
\fBTRUE\fR, \fBFALSE\fR or the elapsed time are returned as noted above.
.if n .bp
.if t .sp
.SH Notes
If the threshold mode is used with recording, \fIsnd_wait\fR may wait
an indefinite amount of time before returning if \fIwait\fR is set to TRUE.
This is the case for both \fIsnd_record\fR(PSSJ) and
\fIsnd_file_record\fR(PSSJ).
This could prevent your code from being run at a time when it
could detect and respond to a command from the keyboard, such as to cease
recording.  Therefore, consider the impact of using this option.

Also note that the elapsed recording time used by and returned
by \fIsnd_wait\fR does not increase during these periods of silence
since they are not being written to disk.

The ability to synchronize on a sound structure using \fIsnd_buf_wait\fR
returns meaningless results when used during \fIsnd_file_play\fR(PSSJ)
or \fIsnd_file_record\fR(PSSJ) calls, and should not be used.

The longest recording that \fIsnd_wait\fR can time is 6553.4 seconds
(1.8 hours).

\fISnd_wait\fR and \fIsnd_buf_wait\fR are actually the same
function. The two names are provided to simplify prototyping.

.SH See Also
snd_play(PSSJ), snd_file_play(PSSJ),
snd_record(PSSJ), snd_file_record(PSSJ),
snd_stop(PSSJ), snd_flush(PSSJ)

.SH Credit
\fISnd_wait\fR(PSSJ) and \fIsnd_buf_wait\fR(PSSJ) are part of the PSSJ
Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402157

