.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH DISK_FORMAT PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
DISK_FORMAT troff documentation \- Version 1(3) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
Disk Format \- Describes the file format used by \fIsnd_file_record\fR(PSSJ)
and \fIsnd_file_play\fR(PSSJ).

.SH Description
Files created by the \fIsnd_file_record\fR(PSSJ) function and used by
the \fIsnd_file_play\fR(PSSJ) function contain information before the
actual sound data that describes details about the sound data
in the file.

In addition to describing the amount of sound it contains, the file header
indicates what sampling rate was used when recording the audio,
if any playback speed adjustment is needed due to errors in the
recording, and other control information.  A text description can
also be added to the file that will be displayed when the file
is viewed using the MS-DOS TYPE command.

.ta 1.5i 2.0i 3.5i
.in 3.5i
.ti -3.5i
;       This structure describes the header on a PSSJ sound file.
.ti -3.5i
hd_name 44 bytes                ;Description of the file.
.br
;For Deskmate instrument files, the
.br
;instrument name goes here.  The ASCII
.br
;text is terminated with CR/LF/^Z
.br
.ti -3.5i
hd_kludge       1 byte          ;Extra ^Z
.br
.ti -3.5i
hd_format       1 byte          ;File format - Current format is 0x80
.br
.ti -3.5i
hd_count        1 word          ;Number of sounds in the file (==1
.br
;for normal files. Deskmate
.br
;instrument files use > 1.
.br
.ti -3.5i
hd_inst 1 byte          ;Instrument number (0 for
.br
;non-instrument files.
.br
.ti -3.5i
hd_res1 17 bytes                ;Reserved for future use -
.br
;set all bytes to zero.
.br
.ti -3.5i
hd_compress     1 word          ;Compression type (0 for none)
.br
.ti -3.5i
hd_compinfo     20 bytes                ;Compression information
.br
.ti -3.5i
hd_rate 1 word          ;Sampling rate
.br
.ti -3.5i
hd_rate_msw     1 word          ;Reserved for future use - 
.br
;set all bytes to zero.
.br
.ti -3.5i
hd_bias 1 word          ;Skew value for hardware
.br
.ti -3.5i
hd_res2 20 bytes                ;Reserved for future use - 
.br
;set all bytes to zero.
.br
.ti -3.5i
disk_header     ends
.br
.if t .sp
.if n .bp
.ti -3.5i
disk_sound      struc
.br
.ti -3.5i
hd_next 1 longword      ;Pointer to next sound block
.br
.ti -3.5i
hd_option       1 word          ;Sound options
.br
.ti -3.5i
hd_pitch        1 byte          ;Pitch info (instrument only)
.br
.ti -3.5i
hd_mystery      1 byte          ;Used only by SOUND.PDM
.br
.ti -3.5i
hd_low  1 byte          ;Low range of scaling
.br
.ti -3.5i
hd_high 1 byte          ;High range of scaling
.br
.ti -3.5i
hd_offset       1 longword      ;Offset in file for start of sound
.br
.ti -3.5i
hd_length       1 longword      ;Length of sound 
.br
.ti -3.5i
hd_truelen      1 longword      ;Decompressed size
.br
.ti -3.5i
hd_st_sust      1 longword      ;Sustain mark
.br
.ti -3.5i
hd_end_sust     1 longword      ;Sustain end
.br
.ti -3.5i
hd_res4 16 bytes                ;Reserved for future use - 
.br
.ti -3.5i
disk_sound      ends
.br
.fi

.SH Notes
The PSSJ disk file format (.SND) was created in 1989 and predates other
sound formats that have since become widely used, such as .WAV
and .VOC.  It is trivial to convert data between the .SND format and these
other formats.

However, information will be lost during conversion.
In particular, if the original recording was made on a 1000SL or 1000TL,
the playback rate should always be adjusted slightly to compensate for errors
in the recording speeds that occur in the hardware of those systems.
Failure to adjust the playback speed results in slight pitch errors
when the audio is played-back.  Recordings made on newer (PSSJ and
other systems) need no special correction, even when played on these
older systems.

The files used by the Deskmate Sound and Music programs Tandy
distributed in 1988 and
1989 are not compatible with the PSSJ disk file format.  These files can
be converted to the PSSJ disk file format by using the 1990 version 
of the Deskmate Sound editor.

.SH See Also
snd_file_play(PSSJ), snd_file_record(PSSJ)

.SH Credit
The PSSJ disk file format is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
410183

