;----------------------------------------------------------------------------
; 	SOUND.INC -	Include file for use with PSSJ digital sound toolkit
;			as of Version 3(39)
;
;	SOUND.INC is part of the PSSJ Digital Sound Toolkit.
;	Copyright 1994 Frank Durda IV, all rights reserved.
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;----------------------------------------------------------------------------
IFNDEF SHOWINC
.xlist
ENDIF

;	Machine type flags

MMAC		equ	0		;Accurate sample rate
MSYNTH		equ	0		;Synthetically produced
M3000		equ	1		;286 8.0 MHZ 1W
M1000SL		equ	2		;8086 7.16 MHZ
M1000TL		equ	3		;286 8.0 MHZ
MTAN2		equ	4		;<27>Double buffering hides CPU type

;	Error flags and other things

INVALID		equ	-1		;Call made when driver uninitialized
					;or call simply not legal at this point
NOERROR		equ	0
INITBUF		equ	1		;No buffers were allocated
					;before snd_init was called
INITDMA		equ	2		;All buffers spanned 64K physical
					;addresses - player cannot initialize
BADDMA		equ	3		;DMA Channel requested is invalid
BADIRQ		equ	4		;The IRQ number requested is invalid
NOIRON		equ	5		;Can't find our hardware
BADSIZE		equ	6		;Record buffer is too small or
					;too small for requested time.
WOULDBLOCK	equ	7		;<5>Record failed because the queue
					;<5>was full. (BLOCK is non-zero)


TRUE		equ	1
FALSE		equ	0
INPLAY		equ	0001H		;Player DMA is running
INRECORD	equ	0002H		;Recorder DMA is running
TORECORD	equ	INRECORD	;<5>
TOPLAY		equ	INPLAY		;<5>
EOF		equ	-1		;<24>
MOREDATA	equ	-2		;<24>


;	Sampling rate defines

R5500		equ	1		;5.5k sampling rate
R11000		equ	2		;11k sampling rate
R22000		equ	3		;22k sampling rate

@codesize	equ	1

;	SP overlay, for passed parameter to snd_play and others

sptr	struc
	dw	?
	dw	(@codesize+1) dup (?)
spptr	dd	?			;Points to a soundhdr
spint	dw	?			;Integer arg
sptr	ends

;	init overlay, for passed parameter to snd_init

sinit	struc
		dw	?
		dw	(@codesize+1) dup (?)
init_trigger	dw	?		;Play threshold
init_dma_chan	dw	?
init_irq	dw	?
init_options	dw	?		;<9>
sinit	ends
	page
;	soundhdr overlay.  A SP-> to a soundhdr which points to
;	a soundstr which points to the actual sound data.
;	Confused?  Wait till you see the segment overrides....

;	This structure does not exist when recording

soundhdr	struc
sndstrptr	dd	?		;Pointer to a soundstr
sndst		dd	?		;LONG of where to start in sound
sndend		dd	?		;LONG of where to end in sound
sndticket	dw	?		;Ticket of buffer sound ended up in.
sndplayrate	db	?		;Rate to play sound at
sndreserved	db	?		;Get around MS compiler foolishness
sndresv1	dd	?		;<8>Reserved
sndresv2	dd	?		;<8>I see the future - Reserved
soundhdr	ends

SNDHDR_SIZE	=	size soundhdr
	
;	This structure describes the sound and its "fixed" properties
;	This area is written to only when recording.

soundstr	struc
sndbuf		dd	?		;The sound itself
sndlen		dd	?		;Length of the sound in the buffer
sndblen		dd	?		;Length of the buffer containing
sndrecrate	db	?		;Sampling rate it was recorded at
sndbias		db	?		;1 if we have to kludge timing
sndchain	dd	?		;<32>Chain field
sndresv4	dd	?		;<8>I see the future - Reserved
soundstr	ends

SOUND_SIZE	=	size soundstr

;	This structure is what the sound buffer the user gives us
;	look like

play_buffers	struc
play_buf_next	dd	?		;Pointer to next buffer
play_buf_ticket	dw	?		;Ticket number
		dw	?
play_buffers	ends

HEADER_SIZE	=	size play_buffers

sptr	struc
	dw	?
	dw	(@codesize+1) dup (?)
sndhdl	dw	?			;Sound File Handle number
sndopt	dw	?			;Sound options
sptr	ends
page

recparms	struc
		dw	?
		dw	(@codesize+1) dup (?)

recaddr		dd	?
recmaxTime	dw	?
recrate		dw	?
recadjust	dd	?		;<4>
recblock	dw	?		;<5>
reclimit	dw	?		;<32>Number of buffers we hold
recthresh	dw	?		;<29>
recsillen	dw	?		;<29>
recparms	ends

stpstr	struc
	dw	?
	dw	(@codesize+1) dup (?)
offs	dw	?			;Spell it out and confuse masm
segm	dw	?
stpstr	ends


;	This structure describes the header on a PSSJ sound file.

disk_header	struc
hd_name		db	44 dup (?)	;Instrument or other description
					;Terminated with CR/LF/^Z
hd_kludge	db	?		;Extra ^Z
hd_format	db	?		;Accept 0x80 only for now
hd_count	dw	?		;Sound Count (=1 for normal files)
hd_inst		db	?		;Instrument # (0 for normal files)
hd_res1		db	17 dup (?)	;Reserved
hd_compress	dw	?		;Compression type (0 for none)
hd_compinfo	db	20 dup (?)	;Compression info
hd_rate		dw	?		;Sampling rate
hd_rate_msw	dw	?		;Reserved
hd_bias		dw	?		;Skew value for hardware
hd_res2		db	20 dup (?)	;Reserved
disk_header	ends

disk_sound	struc
hd_next		dd	?		;Pointer to next sound block
hd_option	dw	?		;Sound options
hd_pitch	db	?		;Pitch info (instrument only)
hd_mystery	db	?		;Something that sound uses
hd_low		db	?		;Low range of scaling
hd_high		db	?		;High range of scaling
hd_offset	dd	?		;Offset in file for start of sound
hd_length	dd	?		;Length of sound 
hd_truelen	dd	?		;Decompressed size
hd_st_sust	dd	?		;Sustain mark
hd_end_sust	dd	?		;Sustain end
hd_res4		db	16 dup (?)	;Reserved
disk_sound	ends


IFNDEF SHOWINC
.list
ENDIF

