/*----------------------------------------------------------------------------
	Show_time -	Displays the elapsed time since recording or
			playback started.
			2-Jul-94

			This function expects no options.  Each time
			it is called, it will determine if the elapsed
			recording or playback time has increased by at
			least a second since the last time the show_time()
			function ran.  If at least a second has passed,
			the new time is output to the display, overwriting
			the previous time value.

	DTIME is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include "dtime.h"
#include "sound.h"

static int	last_time=0;

int show_time()
{
int	running_time;

	running_time = snd_wait(0, 0, 0);	/*Get current elapsed time*/
	if (running_time && running_time != last_time) {/*Has at least one*/
							/*elapsed?*/
		printf("%d.%1d\r",running_time/10,	/*Yes, so display*/
		       running_time % 10);		/*New time*/
		last_time = running_time;	/*Update last displayed time*/
	}
	return(running_time);			/*Return current time*/
}

