/*-----------------------------------------------------------------------------
	Do_decompress_and_load -	
			Reads a file that was created by
			do_compress_and_save(), decompresses the contents in
			memory and places the decompressed sound in the
			buffers that were allocated by set_up_buffers().
			2-Jul-94

			Note:	This function is used by demo3.  Refer to
				DEMO3.C for more information.

			The format of the file is:
				(Repeat the following for each SOUND structure):
				+0	A long integer indicating the length
					of the compressed data.
				+4	A long integer indicating the length
					of the sound data uncompressed.
				+8	An unsigned character (byte) containing
					the recording sampling rate.
				+9	An unsigned character (byte) containing
					the system id (machine type) that was
					used to record the sound.
				+10	Start of the compressed data. 
				Next SOUND structure goes here.
				A long integer containing 0 marks the end of
				the file.

	DLOAD is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <io.h>
#include "sound.h"
#include "dgetbuf.h"
#include "dload.h"

#ifdef __STDC__
void do_decompress_and_load(char *filename)
#else
void do_decompress_and_load(filename)
#endif
{
	int	fd;			/*File handle for save file */
	COMPINFO Info;			/*Compress scratch area */
	unsigned char	filebuffer[512]; /*Buffer for file writes */
	long chunklength;		/*Length of compressed data for
					  this SOUND structure */
	unsigned short datalen;		/*Usable data length in filebuffer */
	int	bufno;			/*Index for SOUND structures */
	int	firsttime;		/*First-time-through flag */
	u_char	rate;			/*Speed sound was recorded at */
	u_char	system;			/*Machine used to record sound */
	u_long	uncomplen; 		/*Uncompressed length of sound */
	long	ret;			/*Return value from decompress */

/*	Open the save file */

	if ( (fd = open(filename, O_RDONLY|O_BINARY)) < 0) {
		printf("Cannot open the sound data file %s\n", filename);
		exit(1);
	}

	for (bufno = 0; bufno < numbuffers; bufno++) {	/*For each SOUND*/
							/*structure*/

/*	Read the length of the compressed data */

		if (read(fd, (char *) &chunklength, sizeof(chunklength)) != 
		    sizeof(chunklength)) {
			perror("Error reading save file");
			exit(1);
		}

		if (chunklength == 0)	/*Test for the end-of-file*/
			return;

/*	Read the length of the data uncompressed */

		if (read(fd, (char *) &uncomplen,
		    sizeof(uncomplen)) != sizeof(uncomplen)) {
			perror("Error reading save file");
			exit(1);
		}
		sndheaders[bufno]->sndp->sndlen = uncomplen;

/*	Read the recording rate */

		if (read(fd, &rate, sizeof(rate)) != sizeof(rate)) {
			perror("Error reading save file");
			exit(1);
		}
		sndheaders[bufno]->sndp->rate = rate;

/*	Read the system */

		if (read(fd, &system, sizeof(system)) != sizeof(system)) {
			perror("Error reading save file");
			exit(1);
		}
		sndheaders[bufno]->sndp->system = system;

		firsttime = 1;
		while (chunklength > 0) { 

/*	Read smaller of remaining data or buffer size */ 

			datalen = (int)((chunklength < 512) ? 
				chunklength : 512);
			if (read(fd, filebuffer, datalen) != datalen) {
				perror("Error reading save file");
				exit(1);
			} 

/*	Decompress the data that was read*/

			ret = snd_decompress_part(firsttime ? (SOUND far *)
				sndheaders[bufno]->sndp : (SOUND far *) 0,
				(COMPINFO far *) &Info, 
				(u_char far *) filebuffer, datalen);

/*	First time for each compressed chunk, pass the SOUND struct;
	on subsequent pieces, pass a null pointer.
*/

			if (ret == BADFMT)
			{
				printf("Sound compressed using unsupported algorithm (or corrupted)\n");
				exit(1);
			}
			firsttime = 0;

/*	Subtract off data we just read from total */

			chunklength -= datalen;
		}

/*	Final call to decompress, get last of the data */

		snd_decompress_part((SOUND far *) 0, (COMPINFO far *)&Info, 
			(u_char far *) filebuffer, 0);


	}				/*Process any remaining sound data*/

	close(fd);			/*Close the file*/
	return;
}

