/*-----------------------------------------------------------------------------
	Demo5 -		Creates a file containing digital sound data as
			it is recorded, allowing for recordings that are
			larger than available memory.
			18-Oct-94

			Note:	The file that is created should be placed on
				a hard disk, Iomega or other high speed device.
				A floppy is not fast enough to be used
				with the 11,000 and 22,000 Hz sampling rates.
				Use of slow disk devices will result in
				fragmented recording and/or playback.

	DEMO5 is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include "sound.h"
#include "dsetup.h"
#include "dtime.h"
#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <dos.h>

/*	VOX_THRESHOLD specifies that a sample that is more than +/- n from
	the centerline is not silence.  If this value is 0, the VOX mode
	is disabled and recording will continue regardless of the input level.

	VOX_LENGTH specifies the amount of time of silence (in 100's of
	milliseconds) must be found in a row before the recorder will pause.
*/

#ifndef VOX_THRESHOLD
#define	VOX_THRESHOLD		0
#define	VOX_LENGTH		0
#endif
#define BUFFERSIZE 65516

#ifdef __STDC__
int	main(int argc, char *argv[])
#else
int	main(argc, argv)
int	argc;
char	*argv[];
#endif

{
	int	infile;
	int	k;
	unsigned char	compensate_tab[256];	/*Array for sound compensation*/
	char far *cp;			/*pointer to last allocated buffer */

	printf("Demonstration #5 - Record sounds and write them to a file.\n");
	printf("Version  2(2)  18-Oct-94\n");
	printf("Copyright 1994 Frank Durda IV.  All rights reserved.\n");

/*	Print the version number */

	printf("Sound Toolkit ");
	for (cp = snd_version()->version; *cp; putchar(*cp++));
	printf("\n");

	if (argc != 2)			/*Make sure a filename was specified*/
	{
		printf("Usage:  demo5 [C|D]:savefile\n");/*Wrong number of*/
		exit(1);				/*parameters.*/
	}

/*	Allocate buffers that are used internally by the sound toolkit.
	At least 25 buffers (55K) of buffers are required for file-record
	operation at the higher sampling rates on the slower machines.
	The more buffers, the higher the reliability on slower systems with
	highly fragmented hard disks.  Fewer buffers can be used if the high
	sampling rates are not to be used or if the computer is fast.
*/

	set_up_sound(25, 0, 0, 0, 0);

/*	Open the file that was specified on the command line.  The
	handle will be passed to the sound toolkit.
*/

	if (_dos_creat(argv[1],0,&infile) || infile==NULL) {
		printf("Can't open file %s\n",argv[1]);
		snd_exit();
		exit(1);
	}

	snd_cue(TORECORD);		/*Set up for recording */

/*	Prompt the operator and wait for a response */

	printf("Press ENTER to perform calibration.  There must be no sound");
	printf(" input while\nthe calibration is performed.\n");

	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

	snd_compensate(compensate_tab);	/*Generate the table that will be
					  used to perform adjustments*/

	printf("About to call snd_file_record() - Press ENTER to begin.\n");
	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

/*	Begin recording.  As data is accumulated, it is written to disk.
	It will stop only if snd_stop is called or there is a disk error,
	including running out of space.
*/

	snd_file_record(infile,
			(unsigned short) R11000,
			(unsigned short) 0,
			compensate_tab,
			(unsigned short) 0,
			(unsigned short) VOX_LENGTH,
			(unsigned short) VOX_THRESHOLD,
			(unsigned short) 0);

/*	Since the actual recording of the file is performed by interrupt-
	driven code, we are free to perform other operations while the
	sound is being recorded provided we do not tie-up MS-DOS so that
	disk I/O is not possible, and we do not disable interrupts for
	extended periods of time.

	In this demonstration, we will just keep track of how long
	the recording is and display that information on the screen.
	The elapsed recording time is obtained by calling the toolkit.
*/

	printf("Back in main() - press any key to stop recording\n");
	printf("0.0    Seconds of Elapsed Time\r");

/*	Now we poll the keyboard, waiting for a keystroke to appear.
	When a key is pressed, a call to snd_stop terminates the
	recording.  We also limit our loop using the value returned
	from show_time (which is the return value from snd_wait)
	in case the recording process stopped by itself.
*/

	while(show_time()) {
		if (kbhit()) {		/*If a key is pressed, read*/
			k=getch();	/*and discard the key, then*/ 
			snd_stop(0,0);	/*stop the recording*/
		}
	}

/*	When control reaches this point, the recorder has stopped.  As soon
	as all buffers are written to disk, the toolkit will update the
	header on the file and close it.   Calling snd_exit() will ensure that
	everything has stopped before shutting the sound toolkit down.
*/

	printf("\r\nExiting\n");

	snd_exit();			/*Shutdown the sound toolkit*/

	return(0);
}

