/*----------------------------------------------------------------------------
	Demo3 -		Records as much sound as will fit in memory,
			compresses the data and then stores it onto disk.
			18-Oct-94

			This program expects a filename to be specified
			on the command line.  The syntax is:
				demo3 filename
			The file may be written to any type of disk.

			Demo4 will play the contents of this file.

			Note:	The file that this program produces is not
				compatible with the DeskMake Sound Editor.
				It is intended to be read by DEMO4.EXE.

	DEMO3 is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "sound.h"
#include "dsetup.h"
#include "dgetbuf.h"
#include "drecord.h"
#include "dsave.h"

/*	VOX_THRESHOLD specifies that a sample that is more than +/- 8 from
	the centerline is not silence.  If this value is 0, the VOX mode
	is disabled and recording will continue regardless of the input level.

	VOX_LENGTH specifies the amount of time of silence (in 100's of
	milliseconds) must be found in a row before the recorder will pause.
*/

#ifndef VOX_THRESHOLD
#define	VOX_THRESHOLD		8
#define	VOX_LENGTH		5
#endif

#ifdef __STDC__
int	main(int argc, char *argv[])
#else
int	main(argc, argv)
int	argc;
char	*argv[];
#endif
{
	char far *cp;			/*pointer to last allocated buffer */
	printf("Demonstration #3 - Record sounds, compress them and store the");
	printf(" data on disk.\n");
	printf("Version  2(1)  18-Oct-94\n");
	printf("Copyright 1994 Frank Durda IV. All rights reserved.\n");

/*	Print the version number */

	printf("Sound Toolkit ");
	for (cp = snd_version()->version; *cp; putchar(*cp++));
	printf("\n");

	if (argc != 2)			/*Make sure a filename was specified*/
	{
		printf("Usage:  demo3 savefile\n");	/*Wrong number of*/
		exit(1);				/*parameters.*/
	}

/*	Allocate buffers that are used by the sound toolkit, then initialize
	the sound toolkit for operation.
*/

	set_up_sound((u_short) 5, (u_short) 0, (u_short) 0, (u_short) 0,
		(u_short) 0);


	set_up_buffers();		/*Allocate buffers to store sound in
					  that will be recorded by the sound
					  toolkit.*/

	do_record_sound(VOX_THRESHOLD,VOX_LENGTH);	/*Record the sound,
							  placing the data
					  		  in memory.*/

/*	Now that all the data has been recorded, go back and compress
	the data.  As it is compressed, write the data to the output file.
*/
	do_compress_and_save(argv[1]);


	snd_exit();			/*Turn off the sound toolkit.  This
					  also disables the hardware.*/

	return(0);			/*Exit*/
}

