;-------------------------------------------------------------------------
;
; DMGUF.INC GUF resources include file.
;
; Last update: 05/24/89
;
;-------------------------------------------------------------------------

WILD                      equ 1
NO_WILD                   equ 0

FILE_HEADER_LENGTH  equ 22      ; length of file header

OPEN_FOR_READ             equ 0       ; file access modes
OPEN_FOR_WRITE            equ 1
OPEN_FOR_UPDATE           equ 2

;  file sharing modes ( OR with a file access mode from above )
EXCLUSIVE                 equ        090h
DENY_WRITE                equ        0A0h
DENY_READ                 equ        0B0h
DENY_NONE                 equ        0C0h        ; share

OPEN_FOR_UPDATE_SHARE     equ 0A2h
OPEN_READ_DENY_NONE       equ 0C0h

OPEN_NO_DIALOG            equ 1       ; do not use a dialog box
OPEN_WITH_DIALOG          equ 0       ; use a dialog box on the open

MERGE_NO_DIALOG           equ 1       ; file menu merge
MERGE_WITH_DIALOG         equ 0

LOAD_NO_DIALOG            equ 3       ; file menu load
LOAD_WITH_DIALOG          equ 2

FIO_OPEN                  equ 1       ; used for dlgbox_Generic
FIO_MERGE                 equ 2       ; used for dlgbox_Generic
FIO_LOAD                  equ 3       ; used for dlgbox_Generic

FIO_CHAR_XEXT             equ 100     ; these are the same in dmcsr.inc
FIO_CHAR_YEXT             equ 220     ; same as in dmcsr.inc world coordinate
FIO_SCREEN_WIDTH          equ (80 * FIO_CHAR_XEXT)
FIO_SCREEN_HEIGHT         equ (25 * FIO_CHAR_YEXT)

FIO_PB_YEXT               equ (2 * FIO_CHAR_YEXT)


MAX_FILE_NAME_SIZE        equ 65
MAX_FILES                 equ 50
MAX_BUFFER_SIZE_FOR_FILES equ 650

op_col       equ  26 * FIO_CHAR_XEXT + FIO_CHAR_XEXT/2  ; starting column for dlgbox_Generic
op_row       equ   7 * FIO_CHAR_YEXT  ; starting row for dlgbox_Generic
op_width     equ  27 * FIO_CHAR_XEXT  ; width of the dlgbox_Generic
op_height    equ  12 * FIO_CHAR_YEXT  ; height of dlgbox_Generic

sa_col       equ  24 * FIO_CHAR_XEXT  ; starting column for dlgbox_SaveAs
sa_row       equ   9 * FIO_CHAR_YEXT  ; starting row for dlgbox_SaveAs
sa_width     equ  32 * FIO_CHAR_XEXT  ; width of dlgbox_SaveAs
sa_height    equ   7 * FIO_CHAR_YEXT  ; height of dlgbox_SaveAs

FIO_RUN_WIDTH  equ    (36 * FIO_CHAR_XEXT)
FIO_RUN_HEIGHT equ    ((6 * FIO_CHAR_YEXT) + FIO_PB_YEXT)
FIO_RUN_XORG   equ    ((FIO_SCREEN_WIDTH - FIO_RUN_WIDTH) /2)  
FIO_RUN_YORG   equ    ((FIO_SCREEN_HEIGHT - FIO_RUN_HEIGHT) /2 )

FIO_PRINT_WIDTH  equ    (35 * FIO_CHAR_XEXT)
FIO_PRINT_HEIGHT equ    ((11 * FIO_CHAR_YEXT / 2) + FIO_PB_YEXT)
FIO_PRINT_XORG   equ    ((FIO_SCREEN_WIDTH - FIO_PRINT_WIDTH) /2 )
FIO_PRINT_YORG   equ    ((FIO_SCREEN_HEIGHT - FIO_PRINT_HEIGHT) /2 )

DM_ERROR                    equ  -1

DMERR_INVALID_START_POINT   equ   1
DMERR_FILE_NOT_FOUND        equ   2
DMERR_INVALID_FILENAME      equ   3
DMERR_TOO_MANY_OPEN_FILES   equ   4
DMERR_INVALID_PATHNAME      equ   5
DMERR_INVALID_FILE_HANDLE   equ   6
DMERR_INVALID_ACCESS_CODE   equ  12
DMERR_OUT_OF_DISK_SPACE     equ  28
DMERR_FILE_LOCKED           equ  32
DMERR_READ_ONLY_FILE        equ  65

DMERR_NONDESTRUCTIVE_ABORT  equ 101
DMERR_DESTRUCTIVE_ABORT     equ 102
DMERR_INVALID_FILE_TYPE     equ 103
DMERR_INVALID_LOCK_LENGTH   equ 104
DMERR_NO_EEPROM             equ 105
DMERR_INVALID_DRIVE         equ 106
DMERR_INVALID_DIRECTORY     equ 107
DMERR_BASE_TOO_LONG         equ 108
DMERR_EXTENSION_TOO_LONG    equ 109
DMERR_INVALID_FILENAME_CHAR equ 110
DMERR_NO_BASE               equ 111
DMERR_EXPANDED_PATH_TOO_LONG equ 112

PERSONAL_TEXT_FILE          equ   1
OLD_WORKSHEET_FILE          equ   2
FILER_FILE                  equ   3
PERSONAL_TEXT_ASCII_FILE    equ  10
MAIL_FILE                   equ  11
MUSIC_FILE                  equ  12
OFFICE_TEXT_FILE            equ  13
WORKSHEET_FILE              equ  14
OFFICE_TEXT_ASCII_FILE      equ  15
DRAW_FILE                   equ  16
CALENDAR_FILE               equ  17
TELECOM_FILE                equ  18
PAINT_FILE                  equ  19
DRAW88_FILE                 equ  20

VENDOR_TAG                  equ  50



DATAFILE    struc
            DATAFILE_FileType           db  ?   ;file owner (app)
            DATAFILE_Modified           db  ?   ;flag for save data prompt
            DATAFILE_FileHandle         dw  ?   ;file handle
            DATAFILE_FileSize           dd  ?   ;number of bytes in file
            DATAFILE_pFilename          dw  ?   ;ptr to filename string
            DATAFILE_pExtension         dw  ?   ;ptr to application extension
            DATAFILE_pStart             dw  ?   ;ptr to beginning of data block
            DATAFILE_pEnd               dw  ?   ;ptr to end of block to write
            DATAFILE_pTop               dw  ?   ;ptr to top of available memory
            DATAFILE_pTmpfil            dw  ?   ;temporary filename pointer
DATAFILE    ends



MERGEFILE   struc
            MERGEFILE_FileType          db  ?   ;file owner (app)
            MERGEFILE_Modified          db  ?   ;flag for save data prompt
            MERGEFILE_FileHandle        dw  ?   ;file handle
            MERGEFILE_FileSize          dd  ?   ;number of bytes in file
            MERGEFILE_pFilename         dw  ?   ;ptr to filename string
            MERGEFILE_pExtension        dw  ?   ;ptr to application extension
            MERGEFILE_pStart            dw  ?   ;ptr to beginning of data block
            MERGEFILE_pEnd              dw  ?   ;ptr to end of block to write
            MERGEFILE_pTop              dw  ?   ;ptr to top of available memory
            MERGEFILE_pTmpfil           dw  ?   ;temporary filename pointer
MERGEFILE   ends


ENVDATA        STRUC
        pEnvFileName         dw        ?
        pDosEnvString        dw        ?
        bSwap                db        ?
        pDmEnvString         dw        ?
        pDataInfo            dd        ?
        DataLen              dw        ?
ENVDATA        ENDS



; defines for bSwap flag

ENV_SWAP_DISABLED        equ        0
ENV_SWAP_ENABLED         equ        1
ENV_SWAP_CREATE          equ        2
ENV_NO_CREATE            equ        3
ENV_CANCEL               equ        -2


;        internal and external international
;        information structure declarations

; Information as it comes back from the DOS 38h country information call

pdm_intl struc
intl_date             dw        ?                ; Date format
intl_cursym           db        5 dup (?)        ; Currency symbol, null terminated
ext_thdsep            db        2 dup (?)        ; 1000's separator, Null terminated
intl_decsep           db        2 dup (?)        ; Decimal separator, null terminated
intl_datsep           db        2 dup (?)        ; Date separator, null terminated
intl_timsep           db        2 dup (?)        ; Time separator, null terminated
ext_curfmt            db        ?                ; Currency format flags
intl_sigdec           db        ?                ; Significant digits in currency
intl_timfmt           db        ?                ; Time format
intl_mono             dd        ?                ; Monocase conversion entry point
ext_data              db        2 dup (?)        ; Data list separator
ext_zeros             dw        5 dup (0)        ; Reserved.  Do not use.
pdm_intl ends

USA_DATEFMT           equ        0
EUROPE_DATEFMT        equ        1
CURFMT_0              equ        0                ; symbol precedes, no spaces
CURFMT_1              equ        1                ; symbol follows, no spaces
CURFMT_2              equ        2                ;symbol precedes, 1 space
CURFMT_3              equ        3                ; symbol follows, 1 space
CURFMT_4              equ        4                ; symbol replaces decimal separator
TIMEFMT_12            equ        0
TIMEFMT_24            equ        1
DATE_SEPARATOR        equ        '-'

; defines for EEPROM calls - NOT IN GUF!!!

LC_ENGLISH            equ        0
LC_FRENCH             equ        1
LC_GERMAN             equ        2
LC_SPANISH            equ        3
LC_DUTCH              equ        4

UK_CCODE              equ        44


DEFAULT_CODE_PAGE     equ        437

intl_tab        struc
                      db        ?                ; (info id)
far_ptr               dd        ?                ; table pointer
intl_tab        ends

; Information at beginning of DOS 65h extended country information call

pdm_exthdr struc
ext_id                db        ?                ; info id = 1
ext_sz                dw        ?                ; size = 38
ext_ccode             dw        ?                ; current country code
ext_cd_pg             dw        ?                ; current code page
pdm_exthdr ends





APPL_VERSION            STRUC
        papp_title         dw        ?
        papp_name          dw        ?
        pversion           dw        ?
        pcopyright_one     dw        ?
        pcopyright_two     dw        ?
APPL_VERSION        ENDS

NOTIFY_STR	struc
	notify_pre_help	  dd	?
	notify_post_help  dd	?
	notify_ds	  dw	?
	notify_sp	  dw	?
	notify_psp	  dw	?
NOTIFY_STR	ends

;end of DMGUF.INC
