/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRFORM.H Form Resource Include File                                   */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRFORM_INCLUDED
#define CSRFORM_INCLUDED 1

/* Form Manager */
struct form_hdr_defn
{
    char    bNewList;          /* new list flag */
    char    bVideo;            /* video output flag */
    int     list_size;         /* size of form in words */
    int     stroke_size;       /* size of the stroke section in bytes */
    int     next_entry;        /* for internal use only */
    int     last_def;          /* for internal use only */
    int     tag_cnt;           /* for internal use only */
    int     *pGroup;           /* pointer to group header */
    int     *pFormList;        /* pointer to the form buffer */
    int     *pStrokes;         /* pointer to the stroke list */
};
typedef struct form_hdr_defn FORM_HDR;

struct form_size_buf_defn
{
    int     list;       /* size of list */
    int     strokes;    /* size of strokes */
};
typedef struct form_size_buf_defn FORM_SIZE_BUF;

struct form_dst_defn
{
    int     x0;     /* x origin integer */
    int     x0f;    /* x origin fraction */
    int     y0;     /* y origin integer */
    int     y0f;    /* y origin fraction */
    int     x1;     /* x end integer */
    int     x1f;    /* x end fraction */
    int     y1;     /* y end integer */
    int     y1f;    /* y end fraction */
};
typedef struct form_dst_defn FORM_DST;

struct element_defn
{
    char    type;   /* element type */
    char    mod;    /* element attribute */
    int     x0;     /* x origin integer */
    int     x0f;    /* x origin fraction */
    int     y0;     /* y origin integer */
    int     y0f;    /* y origin fraction */
    int     x1;     /* x end integer */
    int     x1f;    /* x end fraction */
    int     y1;     /* y end integer */
    int     y1f;    /* y end fraction */
};
typedef struct element_defn ELEMENT;

#define FORM_SYS_TEXT       1

#define FORM_POLY_TYPE      'P'
#define FORM_ELLIP_TYPE     'E'
#define FORM_LINE_TYPE      'L'
#define FORM_BEV_TYPE       'B'
#define FORM_RECT_TYPE      'R'
#define FORM_TEXT_TYPE      'T'
#define FORM_OTHER          'U'

#define FORM_U_ARC_TYPE         'A'
#define FORM_U_IMAGE_TYPE       'I'
#define FORM_U_POLYLINE_TYPE    'P'

#define FORM_ROT0       0
#define FORM_ROT90      1
#define FORM_ROT180     2
#define FORM_ROT270     3

struct form_line_defn
{
    ELEMENT element;
    char    color;      /* line color */
    char    width;      /* line width */
};
typedef struct form_line_defn FORM_LINE;

struct form_rect_defn
{
    ELEMENT element;
    char    lncolor;    /* rectangle color */
    char    lnwidth;    /* rectangle width */
    char    lnstyle;    /* rectangle line style */
    char    bgnd_color; /* background color of pattern */
    char    fgnd_color; /* foreground color of pattern */
    char    pad;
};
typedef struct form_rect_defn FORM_RECT;

struct form_bev_defn
{
    ELEMENT element;
    char    lncolor;    /* rectangle color */
    char    lnwidth;    /* rectangle width */
    char    lnstyle;    /* rectangle line style */
    char    bgnd_color; /* background color of pattern */
    char    fgnd_color; /* foreground color of pattern */
    char    pad;
};
typedef struct form_bev_defn FORM_BEV;

struct form_ellipse_defn
{
    ELEMENT element;
    char    lncolor;    /* rectangle color */
    char    lnwidth;    /* rectangle width */
    char    lnstyle;    /* rectangle line style */
    char    bgnd_color; /* background color of pattern */
    char    fgnd_color; /* foreground color of pattern */
    char    pad;
};
typedef struct form_ellipse_defn FORM_ELLIPSE;

struct form_text_defn
{
    ELEMENT element;
    char    attr;         /* character attribute for the string */
    char    color;        /* foreground color of string */
    char    nChars;       /* number of characters in the string */
    char    rot;          /* character rotation */
    char    *pString;     /* pointer to the string */
};
typedef struct form_text_defn FORM_TEXT;

struct form_u_defn
{
    ELEMENT element;
    int     size;
};
typedef struct form_u_defn FORM_U;

struct form_gattr_defn
{
    char    line_fgnd_color;       /* line pattern foreground color */
    char    line_bgnd_color;       /* line pattern background color */
    char    line_style;            /* line style */
    char    line_width;            /* line width */
    char    pattern;               /* line pattern/fill pattern */
    char    bgnd_color;            /* fill pattern background color */
    char    fgnd_color;            /* fill pattern foreground color */
    char    pad;                   /* padding */
};
typedef struct form_gattr_defn FORM_GATTR;

struct form_tattr_defn
{
    char    color;
    char    attr;
    char    rot;
    char    font;
};
typedef struct form_tattr_defn FORM_TATTR;

struct form_u_arc_defn
{
    FORM_U      u_header;       /* type U mod A */
    FORM_GATTR  attr;
    int         xext;           /* Original x extent of bounding rect */
    int         yext;           /* Original y extent of bounding rect */
    ARC         arc;            /* arc definition */
};
typedef struct form_u_arc_defn FORM_U_ARC;

struct form_u_polyline_defn
{
    FORM_U      u_header;   /* type U mod P */
    FORM_GATTR  attr;
    int         xext;       /* original x extent of bounding rectangle */
    int         yext;       /* original y extent of bounding rectangle */
    char        bFill;      /* fill flag for polygon */
    char        bConnect;   /* 1st & last point connect flag */
    int         nPoints;    /* number of points in polygon */
};
typedef struct form_u_polyline_defn FORM_U_POLYLINE;

struct form_u_image_defn
{
    FORM_U      u_header;       /* type U mod B */
    FORM_GATTR  attr;
    char        bTransparent;   /* transparency flag for COLOR1 */	  
    int         bitmap_xext;    /* x extent of image in pels */
    int         bitmap_yext;    /* y extent of image in pels */
    char        nColors;        /* number of colors in image */
};
typedef struct form_u_image_defn FORM_U_IMAGE;

struct form_attr_defn
{
    char    text_color;
    char    text_attr;
    char    text_rot;
    char    font;
    char    line_fgnd_color;
    char    line_style;
    char    line_width;
    char    fill_pattern;
    char    bgnd_color;
    char    fgnd_color;
    char    bev_pad;
    char    line_bgnd_color;
    char    pad;
};
typedef struct form_attr_defn FORM_ATTR;

struct form_grp_defn
{
    ELEMENT element;
    int     num_parts;
    int     parts;
};
typedef struct form_grp_defn FORM_GRP;

#endif

/* end of CSRFORM.H */
