; PIANO.ASM
;
; Version 1.6 - September 30, 1996.  Chip detection routine modified.
; Version 1.5 - April 19, 1996.  Modified to use Int 48h on the PCjr - should
;   finally run on it.
; Version 1.4 - August 30, 1994.  Modified to use Int 9 rather than Int 15h
;   function 4Fh - should finally run on old Tandy's.
; Version 1.3 - July 29, 1994.  Modified for compatibility with older 1000's
;   and 2500-series.
; Version 1.2 - July 13, 1994.  Modified to set the sound multiplexer.
;
; This is a silly little program to play the SN76496-equivalent circuitry
; on the Tandy 1000-series like a piano.  The following keys are used:
;
;      Key	       Note
;	caps lock	not used
;	left shift	A2
;	A		A#2
;	Z		B2
;	S		not used
;	X		C3
;	D		C#3
;	C		D3
;	F		D#3
;	V		E3
;	G		not used
;	B		F3
;	H		F#3
;	N		G3
;	J		G#3
;	M		A3
;	K		A#3
;	,		B3
;	L		not used
;	.		C4
;	;		C#4
;	/		D4
;	'		D#4
;	right shift	E4
;	enter		not used
;	`		not used
;	tab		F4
;	1		F#4
;	Q		G4
;	2		G#4
;	W		A4
;	3		A#4
;	E		B4
;	4		not used
;	R		C5
;	5		C#5
;	T		D5
;	6		D#5
;	Y		E5
;	7		not used
;	U		F5
;	8		F#5
;	I		G5
;	9		G#5
;	O		A5
;	0		A#5
;	P		B5
;	-		not used
;	[		C6
;	=		C#6
;	]		D6
;	backspace	D#6
;	\		E6
;
; <esc> exits the program.  In accordance with the sound chip's capabilities,
; up to 3 notes can be played at a time.  Notes given are American Standard
; Pitch, Equal Tempered Scale, or as close as I can get; C4 (period) is
; middle C.  High notes are not as close to the true frequency as low ones.
;
; The output frequency of the three sound chip channels is computed by dividing
; the base frequency of 111,860 Hz by a 10-bit divider.  The lowest note
; possible is thus 109.3 Hz, while the lowest standard note possible is A2.
; An additional bit of division is available on the Tandy PSSJ (SN76496
; equivalent), but this program doesn't use that capability.  It may also be
; possible to play a fourth note, but I haven't tried that.
;
; The sound chip is programmed with three OUT instructions, first:
;
; OUT   DX,AL		where AL = 1yy0_zzzz
; OUT   DX,AL		where AL = 00xx_xxxx, and
;			  xxxxxx = high 6 bits of divider
;			  yy = channel number (0-2)
;			  zzzz = low 4 bits of divider
; Then:
;
; OUT	DX,AL		where AL = 1xx1_yyyy, and
;			  xx = channel number (0-2)
;			  yyyy = attenuation (one's complement of volume)
;
; This program always plays notes at the maximum volume; there is no volume
; control.
;
; Make/break scan codes are used to start/stop notes.  Int 9 is used to get
; those.
;

	JMP	START
;
; Data.
;
; Default Int 9/Int 48h vector.
;
INT48OFFS	LABEL	WORD
INT9OFFS	DW	0
INT48SEG	LABEL	WORD
INT9SEG		DW	0
		;
		; I/O port for 3-voice chip.  Now a variable (for use with
		; 2500-series).
		;
SOUNDPORT	DW	0C0h
		;
		; Divider table for allowed notes.
		;
DIVIDERS	LABEL	WORD		; offset - note
		DW	1017		; 0 - A2
		DW	960		; 2 - A#2
		DW	906		; 4 - B2
		DW	855		; 6 - C3
		DW	807		; 8 - C#3
		DW	762		; 10 - D3
		DW	719		; 12 - D#3
		DW	679		; 14 - E3
		DW	641		; 16 - F3
		DW	605		; 18 - F#3
		DW	571		; 20 - G3
		DW	539		; 22 - G#3
		DW	508		; 24 - A3
		DW	480		; 26 - A#3
		DW	453		; 28 - B3
		DW	428		; 30 - C4
		DW	404		; 32 - C#4
		DW	381		; 34 - D4
		DW	360		; 36 - D#4
		DW	339		; 38 - E4
		DW	320		; 40 - F4
		DW	302		; 42 - F#4
		DW	285		; 44 - G4
		DW	270		; 46 - G#4
		DW	254		; 48 - A4
		DW	240		; 50 - A#4
		DW	226		; 52 - B4
		DW	214		; 54 - C5
		DW	202		; 56 - C#5
		DW	190		; 58 - D5
		DW	180		; 60 - D#5
		DW	170		; 62 - E5
		DW	160		; 64 - F5
		DW	151		; 66 - F#5
		DW	143		; 68 - G5
		DW	135		; 70 - G#5
		DW	127		; 72 - A5
		DW	120		; 74 - A#5
		DW	113		; 76 - B5
		DW	107		; 78 - C6
		DW	101		; 80 - C#6
		DW	95		; 82 - D6
		DW	90		; 84 - D#6
		DW	84		; 86 - E6
		;
		; Keyboard break code to divider table offset translate table.
		; For a given break code, use XLAT with this table to get
		; offset into the divider table, then use the offset to get the
		; divider.  Value -1 indicates key not used.  (Overlaps the
		; following table.)
		;
KEYBREAK	LABEL	BYTE
		DB	128 DUP (-1)
		;
		; Keyboard make code to divider table offset translate table.
		; For a given make code, use XLAT with this table to get offset
		; into the divider table, then use the offset to get the 
		; divider.  Value -1 indicates key not used.
		;
KEYMAKE		LABEL	BYTE		; scan code - comment
		DB	-1		; 00 - high "black" keys
		DB	-1		; 01 - escape
		DB	42		; 02 - 1
		DB	46		; 03 - 2
		DB	50		; 04 - 3
		DB	-1		; 05 - 4
		DB	56		; 06 - 5
		DB	60		; 07 - 6
		DB	-1		; 08 - 7
		DB	66		; 09 - 8
		DB	70		; 0A - 9
		DB	74		; 0B - 0
		DB	-1		; 0C - hyphen
		DB	80		; 0D - =
		DB	84		; 0E - backspace
		DB	40		; 0F - high "white" keys - tab
		DB	44		; 10 - q
		DB	48		; 11 - w
		DB	52		; 12 - e
		DB	54		; 13 - r
		DB	58		; 14 - t
		DB	62		; 15 - y
		DB	64		; 16 - u
		DB	68		; 17 - i
		DB	72		; 18 - o
		DB	76		; 19 - p
		DB	78		; 1A - [
		DB	82		; 1B - ]
		DB	-1		; 1C - enter
		DB	-1		; 1D - left control
		DB	2		; 1E - low "black" keys - a
		DB	-1		; 1F - s
		DB	8		; 20 - d
		DB	12		; 21 - f
		DB	-1		; 22 - g
		DB	18		; 23 - h
		DB	22		; 24 - j
		DB	26		; 25 - k
		DB	-1		; 26 - l
		DB	32		; 27 - ;
		DB	36		; 28 - '
		DB	-1		; 29 - `
		DB	0		; 2A - lowest note (A2) - left shift
		DB	86		; 2B - highest note (E6) - \
		DB	4		; 2C - low "white" keys - z
		DB	6		; 2D - x
		DB	10		; 2E - c
		DB	14		; 2F - v
		DB	16		; 30 - b
		DB	20		; 31 - n
		DB	24		; 32 - m
		DB	28		; 33 - ,
		DB	30		; 34 - .
		DB	34		; 35 - /
		DB	38		; 36 - right shift
		DB	201 DUP (-1)	; rest of the keys
		;
		; Channel play table.  If a note is playing on channel n,
		; the corresponding entry in this table contains the divider
		; being used.  Otherwise (the channel is free), the entry in
		; this table is zero.
		;
CHANNELS	LABEL	WORD
		DW	3 DUP (0)
		;
		; Stop flag.  When the break code for the escape key (81h)
		; is received, the Int 9 handler sets this byte to 1.
		; The main program consists of little more than a polling
		; loop that tests this flag.
		;
STOPFLAG	DB	0
		;
		; Count for extended scan codes, equal to the number of bytes
		; of the code yet to be received.  Normally 0 for 1-byte scan
		; codes.
		;
EXTCODE		DB	0
		;
		; Message if no 3-voice chip.
		;
NOCHIPMSG	DB	"This program requires a PC-Jr or Tandy 1000 or "
		DB	"2500 with a 3-voice tone",0Dh,0Ah
		DB	"generator.  It will not run on your machine."
		DB	0Dh,0Ah,"$"
		;
		; Intro message.
		;
INTROMSG	DB	"                 -- Tandy Piano --"
	DB	0Dh,0Ah
	DB	0Dh,0Ah
	DB	"   1   2   3       5   6       8   9   0       =  backsp"
	DB	0Dh,0Ah
	DB	"  F#4 G#4 A#4     C#5 D#5     F#5 G#5 A#5     C#6  D#6"
	DB	0Dh,0Ah
	DB	0Dh,0Ah
	DB	"tab  Q   W   E   R   T   Y   U   I   O   P   [   ]   \"
	DB	0Dh,0Ah
	DB	" F4  G4  A4  B4  C5  D5  E5  F5  G5  A5  B5  C6  D6  E6"
	DB	0Dh,0Ah
	DB	0Dh,0Ah
	DB	"       A       D   F       H   J   K       ;   '"
	DB	0Dh,0Ah
	DB	"      A#2     C#3 D#3     F#3 G#3 A#3     C#4 D#4"
	DB	0Dh,0Ah
	DB	0Dh,0Ah
	DB	"  shift  Z   X   C   V   B   N   M   ,   .   /  shift"
	DB	0Dh,0Ah
	DB	"   A2    B2  C3  D3  E3  F3  G3  A3  B3  C4  D4  E4"
	DB	0Dh,0Ah
	DB	0Dh,0Ah
	DB	"Period is middle C.  Hit <escape> to halt the program."
	DB	0Dh,0Ah,"$"

;
; Subroutine to detect 3-voice chip.  Returns I/O port of chip in AX, 0 if
; not present.  If necessary, also sets bit 5 at port 61h to enable the 3-
; voice chip.  (Modified, September 30, 1996.)
;
DETECT:	
	PUSH	CX
	PUSH	DX
	PUSH	ES
	;
	; Detect PCMCIA Socket Services.
	;
	XOR	CX,CX
	MOV	AX,8000h
	INT	1Ah
	CMP	CX,5353h
	JE	DETECT_NODAC	; Skip detecting the DAC if PCMCIA present
	;
	; Detect Tandy DAC (can't do this if PCMCIA present).
	;
	MOV	AX,8100h		; get the DAC base port
	INT	1Ah
	CMP	AX,8000h		; was a resonable port returned?
	JAE	DETECT_NODAC		; if not, no DAC present
	MOV	DX,AX			; DX = base DAC port + 2
	ADD	DX,2
	CLI
	IN	AL,DX			; get current value and save in CL
	MOV	CL,AL
	MOV	CH,0			; set CH=0 (assume no DAC)
	XOR	AL,AL			; clear all the bits
	OUT	DX,AL
	IN	AL,DX			; read them back
	OR	AL,AL			; all clear?
	JNZ	DETECT_DACCHKDONE	; if not, no DAC
	NOT	AL			; set all the bits
	OUT	DX,AL
	IN	AL,DX			; read them back
	NOT	AL			; all set?
	JNZ	DETECT_DACCHKDONE	; if not, no DAC
	MOV	CH,1			; CH=1 (definitely a DAC here)
DETECT_DACCHKDONE:
	MOV	AL,CL		; restore previous value at DAC base + 2
	OUT	DX,AL
	STI
	OR	CH,CH		; did the port check out?
	JZ	DETECT_NODAC	; if not, go see if it's Tandy 1000 or PCjr
	MOV	AX,DX		; it checked out - 3-voice is at DAC base - 4
	SUB	AX,6
	JMP	DETECT_EXIT
	;
	; No Tandy DAC present.  Detect Tandy 1000-series.
	;
DETECT_NODAC:
	MOV	AX,0FFFFh
	MOV	ES,AX
	CMP	BYTE PTR ES:[0Eh],0FFh
	JNE	DETECT_NOTANDY
	MOV	AX,0FC00h
	MOV	ES,AX
	CMP	BYTE PTR ES:[0],21h
	JE	DETECT_SETUP
	;
	; Not a Tandy.  Check for a PCjr.
	;
DETECT_NOTANDY:
	MOV	AX,0FFFFh
	MOV	ES,AX
	XOR	AX,AX		; last chance - return 0 if this fails
	CMP	BYTE PTR ES:[0Eh],0FDh
	JNE	DETECT_EXIT
	;
	; PC-jr found or old Tandy 1000.  Set sound source.
	;
DETECT_SETUP:
	CLI
	IN	AL,61h		; get byte from port 61h
	JMP	$+2
	OR	AL,60h		; set bits 5 and 6
	AND	AL,0FEh		; clear bit 0
	OUT	61h,AL		; write back to enable sound chip
	JMP	$+2
	STI
	MOV	AX,0C0h
DETECT_EXIT:
	POP	ES
	POP	DX
	POP	CX
	RET

;
; Subroutine, called when a make code for a "white" or "black" key is received.
; On entry, AL is the offset into the divider table.  On exit, the note will
; be playing on one of the sound chip channels if one is available.
;
DOMAKE:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	;
	; Get the divider in AX.
	;
	MOV	BL,AL
	MOV	BH,0
	MOV	AX,DIVIDERS[BX]
	;
	; Check the three channels to see if the note is already playing.
	;
	MOV	CX,3
	XOR	BX,BX
DOMAKE_LOOP1:
	CMP	AX,CHANNELS[BX]
	JE	DOMAKE_EXIT
	INC	BX
	INC	BX
	LOOP	DOMAKE_LOOP1
	;
	; Note is not playing now.  See if there is a free channel to play it
	; on.
	;
	MOV	CX,3
	XOR	BX,BX
DOMAKE_LOOP2:
	CMP	CHANNELS[BX],0
	JE	DOMAKE_FREEFOUND
	INC	BX
	INC	BX
	LOOP	DOMAKE_LOOP2
	JMP	DOMAKE_EXIT
	;
	; BX is twice the channel number for the free channel, AX is the
	; divider to use.  Allocate the channel.
	;
DOMAKE_FREEFOUND:
	MOV	CHANNELS[BX],AX
	;
	; Start playing the note.
	;
	MOV	CL,4
	SHL	BL,CL
	SHL	AX,CL
	SHR	AL,CL
	OR	AL,BL
	OR	AL,80h
	MOV	DX,SOUNDPORT
	OUT 	DX,AL
	MOV	AL,AH
	OUT	DX,AL
	MOV	AL,BL
	OR	AL,90h
	OUT	DX,AL
	;
	; Return.
	;
DOMAKE_EXIT:
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Subroutine, called when a break code for a "white" or "black" key is
; received.  On entry, AL is the offset into the divider table.  On exit,
; the note will not be playing.
;
DOBREAK:
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	;
	; Get the divider in AX.
	;
	MOV	BL,AL
	MOV	BH,0
	MOV	AX,DIVIDERS[BX]
	;
	; Check the three channels to see if the note is playing.
	;
	MOV	CX,3
	XOR	BX,BX
DOBREAK_LOOP:
	CMP	AX,CHANNELS[BX]
	JE	DOBREAK_FOUND
	INC	BX
	INC	BX
	LOOP	DOBREAK_LOOP
	JMP	DOBREAK_EXIT
	;
	; The note is playing.  BX is twice the channel number.  Deallocate
	; this channel and stop the sound.
	;
DOBREAK_FOUND:
	MOV	CHANNELS[BX],0
	MOV	CL,4
	MOV	AL,BL
	SHL	AL,CL
	OR	AL,9Fh
	MOV	DX,SOUNDPORT
	OUT	DX,AL
DOBREAK_EXIT:
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET

;
; Subroutine, called when the <esc> key is released.  Stops all currently
; playing notes.
;
; OUT	0C0h,AL		where AL = 1xx1_yyyy, and
;			  xx = channel number (0-2)
;			  yyyy = attenuation (one's complement of volume)
STOPALL:
	PUSH	AX
	PUSH	CX
	PUSH	DX
	MOV	AL,9Fh
	MOV	DX,SOUNDPORT
	MOV	CX,4
STOPALL_LOOP:
	OUT	DX,AL
	ADD	AL,20h
	LOOP	STOPALL_LOOP
	POP	DX
	POP	CX
	POP	AX
	RET

;
; Subroutine, called by keystroke handlers.  On entry, DS addresses our
; data and AL is the scancode from the keyboard.
;
; When this subroutine receives a scancode, it checks to see if the scan
; code is 81h, the break code for the escape key; if so, sound output is
; stopped and the stop flag is set.  Otherwise, the subroutine checks to
; see if the scan code is the make code for one of the "white" or "black"
; keys above.  If so, a subroutine is called to see if the note is already
; playing on one of the three sound chip channels, and if not, to allocate
; a channel if one is available and play the note.  Otherwise, the subroutine
; checks to see if the scan code is the break code for one of the "white"
; or "black" keys above.  If so, a subroutine is called to see if the note
; is playing and to stop playing it if it is.  If all these tests fail, the
; scan code is ignored and the subroutine returns.
;
DOSCAN:
	PUSH	BX		; caller already saved AX, if needed
	;
	; Check for stop key (break code for escape).
	;
	CMP	AL,81h
	JNE	DOSCAN_CHKMAKE
	MOV	STOPFLAG,1
	CALL	STOPALL			; stop all sound output
	JMP	DOSCAN_EXIT
	;
	; Check for make code for "white" or "black" key.
	;
DOSCAN_CHKMAKE:
	MOV	AH,AL
	MOV	BX,OFFSET KEYMAKE
	XLATB
	CMP	AL,-1
	JE	DOSCAN_CHKBREAK
	CALL	DOMAKE
	JMP	DOSCAN_EXIT
	;
	; Check for break code for "white" or "black" key.
	;
DOSCAN_CHKBREAK:
	MOV	AL,AH
	MOV	BX,OFFSET KEYBREAK
	XLATB
	CMP	AL,-1
	JE	DOSCAN_EXIT
	CALL	DOBREAK
DOSCAN_EXIT:
	POP	BX
	RET

;
; Int 9 handler.  Whenever a key is pressed or released (or, in the case of
; typematic keys, held down) on a normal PC-compatible keyboard, hardware
; interrupt 9 occurs.  The scancode is then available to be read from port
; 60h.
;
; This handler first checks to see if the scan code is a subsequent byte of
; a multibyte extended scan code; if so, it discards the code and returns.
; Next, it checks to see if the scan code is the first byte (0E0h or 0E1h)
; of a multibyte code; if so, it sets a count so that the subsequent bytes
; of the code will be discarded and returns.  Otherwise, if the scan code
; is a single-byte code, it calls DOSCAN, above, to handle the keystroke.
;
; Save registers.
;
INT9HDLR:
	CLI
	PUSH	AX
	PUSH	DS
	;
	; Disable the AT keyboard.
	;
	MOV	AL,0ADh
	OUT	64h,AL
	;
	; DS addresses local data.
	;
	PUSH	CS
	POP	DS
	;
	; Get the scan code.
	;
	IN	AL,60h
	;
	; Check if subsequent byte of a multi-byte scan code.
	;
	CMP	EXTCODE,0
	JE	INT9HDLR_FIRSTBYTE
	DEC	EXTCODE
	JMP	INT9HDLR_EXIT
	;
	; Check if first byte of a multi-byte scan code.
	;
INT9HDLR_FIRSTBYTE:
	CMP	AL,0E0h
	JB	INT9HDLR_ONEBYTE
	CMP	AL,0E1h
	JA	INT9HDLR_ONEBYTE
	SUB	AL,0DFh
	MOV	EXTCODE,AL
	JMP	INT9HDLR_EXIT
	;
	; Single-byte scancode.  Pass it to the internal subroutine for
	; handling.
	;
INT9HDLR_ONEBYTE:
	CALL	DOSCAN
	;
	; Clean up and exit.
	;
INT9HDLR_EXIT:
	IN	AL,61h		; send acknowledgement to XT keyboard
	JMP	$+2
	OR	AL,80h
	OUT	61h,AL
	JMP	$+2
	AND	AL,7Fh
	OUT	61h,AL
	JMP	$+2
	MOV	AL,0AEh		; reenable the AT keyboard
	OUT	64h,AL
	MOV	AL,20h		; issue EOI to the interrupt controller
	OUT	20h,AL
	STI
	POP	DS
	POP	AX
	IRET

;
; Interrupt 48h handler.  When a key is pressed or released on the PCjr
; keyboard, an NMI (Int 2) occurs, and the jr reads the keystroke bit-by-
; bit from the keyboard over a serial link.  When the scancode has been
; constructed, the NMI handler calls Int 48h with the scancode in AL.  The
; default Int 48h handler translates the scancode from the jr's 62-key
; keyboard using various shift states in effect and converts it to appear
; as though it came from an 83-key keyboard, then invokes Int 9 with the
; converted scancode in both PPI port A (I/O port 60h) and in AL, the idea
; being that (some) programs that handle keyboard input through Int 9 will
; be able to run on the jr, even though its keyboard hardware is completely
; different.  Unfortunately, the result with *this* program is a solid
; lockup, using the Int 9 handler above.  So, on the jr we intercept Int
; 48h instead and skip the translation - all the scancodes we're interested
; in, except one (the highest note), are the same on the jr's 62-key keyboard
; as on the normal PC keyboards.
;
; The NMI handler on the PCjr already saves and restores all registers, so
; we don't need to save them here.  We also don't need to give an acknow-
; ledgement to the keyboard or issue EOI to the interrupt controller, since
; no hardware interrupt has occurred.
;
INT48HDLR:
	CLI
	;
	; DS addresses local data.
	;
	PUSH	CS
	POP	DS
	;
	; Pass the scancode to the internal subroutine for handling.
	;
	CALL	DOSCAN
	STI
	IRET

;
; Main program.
;
; Detect/initialize 3-voice chip.
;
START:
	CALL	DETECT
	OR	AX,AX
	JNZ	CHIPOK
	MOV	AH,9
	MOV	DX,OFFSET NOCHIPMSG
	INT	21h
	JMP	TERMINATE
CHIPOK:
	MOV	SOUNDPORT,AX
	;
	; Display intro message.
	;
	MOV	AH,9
	MOV	DX,OFFSET INTROMSG
	INT	21h
	;
	; Turn all SN76496 tone and noise channels off, just to make sure.
	;
	CALL	STOPALL
	;
	; Set the sound multiplexer for the 3-voice chip.  (This is unneces-
	; sary on the 1000TL, but may be needed on older machines.)
	;
	MOV	AX,8003h
	INT	1Ah
	;
	; Check for a PCjr.
	;
	MOV	AX,0FFFFh
	MOV	ES,AX
	CMP	BYTE PTR ES:[0Eh],0FDh
	JE	USE_INT48
	;
	; Not a PCjr - save default Int 9 handler address.
	;
	MOV	AX,3509h
	INT	21h
	MOV	INT9OFFS,BX
	MOV	INT9SEG,ES
	;
	; Hook Int 9.
	;
	MOV	AX,2509h
	MOV	DX,OFFSET INT9HDLR
	INT	21h
	JMP	MAINLOOP
	;
	; PCjr - save default Int 48h handler address.
	;
USE_INT48:
	MOV	AX,3548h
	INT	21h
	MOV	INT48OFFS,BX
	MOV	INT48SEG,ES
	;
	; Hook Int 48h.
	;
	MOV	AX,2548h
	MOV	DX,OFFSET INT48HDLR
	INT	21h
	;
	; Poll the stop flag until it becomes true.
	;
MAINLOOP:
	CMP	STOPFLAG,1
	JNE	MAINLOOP
	;
	; Check for a PCjr.
	;
	MOV	AX,0FFFFh
	MOV	ES,AX
	CMP	BYTE PTR ES:[0Eh],0FDh
	JE	UNHOOK_INT48
	;
	; Not a PCjr - unhook Int 9.
	;
	MOV	AX,2509h
	MOV	DX,INT9SEG
	MOV	DS,DX
	MOV	DX,CS:INT9OFFS
	INT	21h
	JMP	TERMINATE
	;
	; PCjr - unhook Int 48h.
	;
UNHOOK_INT48:
	MOV	AX,2548h
	MOV	DX,INT48SEG
	MOV	DS,DX
	MOV	DX,CS:INT48OFFS
	INT	21h
	;
	; Terminate.
	;
TERMINATE:
	MOV	AX,4C00h
	INT	21h