/*
    Prn2file.c

    Converts a print file created with Filer to an editable file.
*/

#include <stdio.h>      /* Standard I/O functions header file */

    /* Array to read the file into. */
char far FilArray[800][80];


    /* Main function. */
void main( void )
{
    int row;        /* row (line) in the file */
    int column;     /* column (character on a line) */
    int newchar;    /* character read/written from/to file */

    /* Clear the FilArray to all spaces. */
    for ( row=0; row<800; row++ )
        for ( column=0; column<80; column++ )
            FilArray[row][column] = ' ';

    /* Read characters from stdin, converting as necessary. */
    row = column = 0;
    while ( (newchar = getchar()) != EOF )
    {
        /* Convert formfeeds into CR/LF pairs. */
        if ( newchar == 0x0c )
        {
            newchar = 0x0d;
            ungetc( 0x0a, stdin );
        }

        /* Process the character. */
        switch ( newchar )
        {
            /* If the character is a carriage return, go back to the 
               beginning of the line. */
            case 0x0d:
                column = 0;
                break;

            /* If the character is a line feed, go to the next line. */
            case 0x0a:
                row++;
                break;

            /* If the character is a space, go to the next column, but do 
               not overwrite the existing character (thus mimicking a 
               printer. */
            case 0x20:
                column++;
                break;

            /* If the character is printable, print it. */
            default:
                FilArray[row][column++] = newchar;
                break;
        }
    }

    /* Cut off trailing blanks and set empty lines to null strings. */
    for ( row=0; row<800; row++ )
    {
        /* Find the column containing the last nonblank character on the 
           line. */
        column = 79;
        while ( column >= 0 && FilArray[row][column] == ' ' )
            column--;

        /* Go to the next column.  If there is at least one nonblank 
           character on the line, put a CR/LF there, then a null.  If the 
           line consists entirely of blanks, put a null in the first 
           position. */
        column++;
        if ( column == 0 )
            FilArray[row][column] = '\0';
        else
        {
            FilArray[row][column++] = '\x0a';
            FilArray[row][column] = '\0';
        }
    }

    /* Write out the results. */
    for ( row=0; row<800; row++ )
        for ( column=0; column<80; column++ )
        {
            if ( FilArray[row][column] )
                putchar( FilArray[row][column] );
            else
                break;
        }
    putchar( '\x1a' );
}
