/*---------------------------------------------------------------------------*/
/* This is the main Zmodem program which controls the main general routines. */
/*                                                                           */
/* (C) Copyright M. Jose, 1990 ->                                            */
/* See MPMODEM.DOC for more details about the usage of this source in your   */
/* programs.                                                                 */
/* Written by Mark Jose, Oct-Nov, 1990.                                      */
/*---------------------------------------------------------------------------*/

[...]

/*
 Read the header (either binary or hex.)
*/
int pascal GetHeader(BYTE *hdr)
{
[...]
    switch (c = TimedRead()) {
       case XON:
               goto Again;
       case RCDO:
       case ZTIMEOUT:
               goto Finish;
       case CAN:
gotcancel:
               if (--cancount <= 0)
                   return ZCAN;
               switch((c = GetByte(1))) {
                  case ZTIMEOUT:
                              goto Again;
                  case ZCRCW:
                  case ZCRCW_C:                 /* ---** Add this **--- */
                              switch(GetByte(1)) {
                                 case ZTIMEOUT:
                                             c = ZERROR;
                                             goto Finish;
                                 case RCDO:
                                             return RCDO;
                                 default:
                                             goto Agn2;
                              }     /* Fall through */
                  case RCDO:
                              goto Finish;
                  default:
                              break;
                  case CAN:
                              if (--cancount <= 0)
                                 return ZCAN;
                              goto Again;
               }                /* fallthrough... */
       default:
TryAgain2:
[...]
    Rxframeind = c = TimedRead();

    switch (c) {
       case ZBIN:
               RxType = 0;
               c = GetBinaryHeader(hdr);
               break;
       case ZHEX:
               RxType = 0;
               c = GetHexHeader(hdr);
               break;
       case ZBIN32:
               RxType = 1;
               c = GetBinaryHeader32(hdr);
               break;

/* There are now two extra indicators - compressed transmission with    */
/* CRC-32 and compression with CRC-16.                                  */
       case ZBINC32:                            /* ---** Add this **--- */
               RxType = 3;                      /* ---** Add this **--- */
               c = GetBinaryHeader32(hdr);      /* ---** Add this **--- */
               break;                           /* ---** Add this **--- */
       case ZBINC:                              /* ---** Add this **--- */
               RxType = 4;                      /* ---** Add this **--- */
               c = GetBinaryHeader(hdr);        /* ---** Add this **--- */
               break;                           /* ---** Add this **--- */
/*  ---- END OF NEW CODE ----  */

       case CAN:
                goto gotcancel;
       case RCDO:
       case ZTIMEOUT:
                goto AllDone;
       default:
                goto TryAgain2;

    }
[...]
}

[...]

/*
 Read a byte, checking for ZMODEM escape encoding
*/
int pascal GetZDLE()
{
    static int ch;

Again:
    if ((ch = GetByte(timeout)) & 0x60)
        return ch;

    if (ch != ZDLE)
       if ( ((!UsingFast) && (ch == 17 || ch == 19)) ||  /* ---** Add this **--- */
            (ZCtlEsc && ((ch & 0x60) == 0)) ) {
          goto Again;
       } else
           return ch;

Again2:
    if ((ch = GetByte(timeout)) < 0)
       return ch;
    if (ch == CAN && (ch = GetByte(timeout)) < 0)
       return ch;
    if (ch == CAN && (ch = GetByte(timeout)) < 0)
       return ch;
    if (ch == CAN && (ch = GetByte(timeout)) < 0)
       return ch;
    switch (ch) {
       case CAN:
                 return GOTCAN;
       case ZCRCE:
       case ZCRCG:
       case ZCRCQ:
       case ZCRCW:
/* These are compression packets. */
       case ZCRCE_C:         /* ---** Add this **--- */
       case ZCRCG_C:         /* ---** Add this **--- */
       case ZCRCQ_C:         /* ---** Add this **--- */
       case ZCRCW_C:         /* ---** Add this **--- */
                 return(ch|GOTOR);
       case ZRUB0:
                 return 127;     /* return(0177); */
       case ZRUB1:
                 return 255;     /* return(0377); */
       case XOFF:
       case 147:
       case XON:
       case 145:
                 if (!UsingFast)                  /* ---** Add this **--- */
                    goto Again2;
                 else
                    return ch;
       default:
                 if (ZCtlEsc && !(ch & 0x60))
                    goto Again2;
                 if ((ch & 0x60) == 0x40)
                    return (ch ^ 0x40);
                 else if (ch >= 1 && ch <= 31)
                    return ch;
                 break;
    }
    return ZERROR;
}

[...]
