#define NEWSRC      "NEWSRC.SLR"
#define NEWSRC_TMP  "NEWSRC.TMP"

enum Exit_Codes { x_success, x_usage, x_fatal };   /* Exit codes */
enum SOUP_Types { u, M, m, n, C, c, i, b, B };  /* Supported types */

/* External Data */
extern int  verbose;
extern char _slrerr[80];
extern char user_path[MAXPATH];                   /* From config.c */
extern char temp_path[MAXPATH];                   /* From config.c */
extern char config_path[MAXPATH];                 /* From config.c */
extern char log_path[MAXPATH];                    /* From config.c */
extern char newsgroups_path[MAXPATH];             /* From config.c */
extern int  news_type;                            /* From config.c */
extern int  news_index;                           /* From config.c */
extern int  kill_summary;                         /* From config.c */
extern long news_area_bytes;                      /* From config.c */
extern long news_area_messages;                   /* From config.c */
extern long news_total_bytes;                     /* From config.c */
extern long news_total_messages;                  /* From config.c */
extern int  use_fossil;                           /* From config.c */
extern int  port; 																/* From config.c */
extern char area_name[80];                        /* From newsrc.c */
extern char keyword;                              /* From newsrc.c */
extern long index_high;                           /* From newsrc.c */
extern long msg_high;                             /* From newsrc.c */
extern char logbuf[128];                          /* From logit.c  */

typedef struct forum_type {
  char   forum_path[MAXPATH];
  struct forum_type *next;
} FORUM;
extern FORUM *forum;

/* External Functions */
extern int  load_static(char username[10]);       /* From config.c */
extern int  load_config();                        /* From config.c */
extern int  user_defaults();                      /* From config.c */
extern int  set_default_path();                   /* From forums.c */
extern long pack_group();                         /* From packet.c */

/* Common Functions */
extern int  getopt(int argc, char *argv[], const char *optionS);
extern int  set_directory(char *path);
extern int  get_batch_prefix();
extern int  read_doors();                         /* From doors.c   */
extern int  kill_newsrc(const char *newsrc_type); /* From newsrc.c  */
extern int  read_newsrc(FILE *newsrc);            /* From newsrc.c  */
extern int  update_newsrc();                      /* From newsrc.c  */
extern int  write_newsrc(const char *newsrc_type, const char *open_mode);
extern int  logit(const char *facility);          /* From logit.c */
extern FILE *open_newsrc(const char *newsrc_type, const char *open_mode);

/* Local functions */
void usage();

long totbyte_count;
