/*===========================================================================
SOLAR :: ..\common\decomp.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

/* Header files */
#include <stdio.h>
#include <process.h>
#include <string.h>
#include <dir.h>
#include <stdlib.h>
#include "..\common\decomp.h"

/*
 * Function: decompress_packet()
 * Purpose : spawn decompression program to decompress packet.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int decompress_packet()
{
  struct  ffblk ffblk;
  char    drive[MAXDRIVE];
  char    dir[MAXDIR];
  char    file[MAXFILE];
  char    ext[MAXEXT];
  int     flags,
          x,
          ext_len,
          done;

  /* Initialize global variables */

  strcpy(decompress,"NON");
  strcpy(program,"NONE");
  options[0] = '\0';

  /* Scan solarwork directory for first file, assume
     it is the packet. */

  done = findfirst("*.*",&ffblk,0);

  /* Check to make sure there was a packet found */

  if (done != 0)
  {
    sprintf(_slrerr,"no reply packet found");
    goto ErrorExit;
	}

  /* Parse the packet filename to get extention */

  flags = fnsplit(ffblk.ff_name,drive,dir,file,ext);

  /* make sure packet filename _has_ an extention */

  if (flags & EXTENSION)
	{
    /* strip off the leading '.' and save
       extention as compression format */

    ext_len = strlen(ext);
		for (x = 0; x < ext_len; x++)
		{
			decompress[x] = ext[x+1];
		}
		decompress[x] = '\0';

    /* load the decompression program command line
       from config file */

    if (load_decompress_parms() != 0)
      goto ErrorExit;

    /* Initialize the SPAWNO routine to swap to disk */

    if (diskswap == YES)
    {
      if (verbose == YES)
        RPrintf("Initializing swap to %s\n",swap_path);
      init_SPAWNO(swap_path,SWAP_DISK);
    }

    /* Spawn the decompression program */

    RPrintf("\nDecompressing %s format packet...\n",decompress);
    if (spawnlp(P_WAIT,program,program,options,ffblk.ff_name,NULL) != 0)
    {
      sprintf(_slrerr,"error spawning %s",program);
      goto ErrorExit;
    }
  }
  else /* No extension, unknown packet archive format */
  {
    sprintf(_slrerr,"packet filename has no extension, format unknown");
    goto ErrorExit;
  }

GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: load_decompress_parms()
 * Purpose : Load the appropriate decompress parameters from the Solar
 *           configuration file.
 * Return  : 0 on success, non-zero on error.
*/

int load_decompress_parms()
{
	FILE *config_file = fopen(config_path,"rt");

	int idx  = 0;

	char buf[128];
	char search_string[20];
	char *p = NULL;

  /* Set some values */
  strcpy(program,"NONE");
  options[0] = '\0';
  strcpy(search_string,"decompress-");
  strcat(search_string,decompress);

  /* Make sure the config file is open */

  if (!config_file)
  {
    sprintf(_slrerr,"config file %s not found",config_path);
    goto ErrorExit;
  }

  /* Read through the config file */

  while (fgets(buf,128,config_file) != NULL)
	{
    /* Look for a decompress parameter */

    if (strnicmp(buf,"decompress",10) == 0)
		{
      /* Get everything before the '=' seperator */

      if ((p = strtok(buf,"=")) != NULL)
			{
        /* Replace trailing LF with NULL */

        idx = 0;
        while (p[idx] != '\n')
        {
          p[idx] = p[idx++];
        }
        p[idx] = '\0';

        /* Check to see if this line has archive type we want */

        if (stricmp(p,search_string) == 0)
        {
          /* Get everything after the '=' separator */

          if ((p = strtok(NULL,"=")) == NULL)
          {
            sprintf(_slrerr,"incomplete configuration: %s",buf);
            goto ErrorExit;
          }

          /* Again, replace trailing LF with NULL */

          idx = 0;
          while (p[idx] != '\n')
          {
            buf[idx] = p[idx++];
          }
          buf[idx] = '\0';

          /* Get the first word, which is the decompress program */

          if ((p = strtok(buf," ")) != NULL)
          {
            idx = 0;
            while (p[idx] != '\n')
            {
              program[idx] = p[idx++];
            }
            program[idx] = '\0';

            /* Get any program options there might be. Better not use '|' */

            if ((p = strtok(NULL,"|")) != NULL)
            {
              /* La dee da dee da */
              idx = 0;
              while (p[idx] != '\n')
              {
                options[idx] = p[idx++];
              }
              options[idx] = '\0';
            }
            else
            {
              options[0] = '\0';
            }
          }
          /* Well, this was the one we wanted, so exit loop */
          break;
        }
      }
    }
  }

  /* Make sure the program got set to something */
  if (strcmp(program,"NONE") == 0)
  {
    sprintf(_slrerr,"unknown archive file format");
    goto ErrorExit;
  }

GoodExit:
  if (config_file) fclose(config_file);
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}


