'
'  BUFFER.BAS
'
'  The same as SIMPLE, except uses Buf1024Seg
'  to get buffer(s).
'
'  See BUF1024.OBJ (source is BUF1024.ASM).
'
'  To run from the VB IDE, first create a QLB with BUF1024.OBJ
'  in it (see BUF_QLB.BAT),
'
'    LINK /Q BUF1024.OBJ PCL4VB1.LIB VBDOS.LIB,PCL4VB1.QLB,,VBDOSQLB.LIB;
'    LINK /Q BUF1024.OBJ PCL4VB2.LIB VBDOS.LIB,PCL4VB2.QLB,,VBDOSQLB.LIB;
'    COPY PCL4VB2.QLB PCL4VB.QLB
'
'  Then type
'
'    VBDOS /LPCL4VB.QLB BUFFER.BAS
'
'$INCLUDE: 'PCL4VB.BI'

DECLARE FUNCTION Buf1024Seg CDECL()

DIM BugSeg AS INTEGER
DIM TxBufSeg AS INTEGER
DIM RxBufSeg AS INTEGER
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM RxCode AS INTEGER
DIM TxCode AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM LibVer AS INTEGER
DIM BaudCode AS INTEGER
DIM AnyKey AS STRING
DIM Rates(9) AS STRING
DIM UartString(4) AS STRING
DIM PARMS AS STRING
DIM ARG1 AS STRING
DIM ARG2 AS STRING
'init baud rate strings
Rates$(1) = "300"
Rates$(2) = "1200"
Rates$(3) = "2400"
Rates$(4) = "4800"
Rates$(5) = "9600"
Rates$(6) = "19200"
Rates$(7) = "38400"
Rates$(8) = "57600"
Rates$(9) = "115200"

'init UART type strings
UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

'get command line arguments
PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: BUFFER <Port> <BaudRate>"
  PRINT "Example: BUFFER 1 9600"
  END
END IF
L = LEN(PARMS$)
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
BaudCode = -1

'Get COM port
Port = VAL(ARG1$) - 1

'Get baud code
FOR I = 1 TO 9
  IF Rates$(I) = ARG2$ THEN
     BaudCode = I
     EXIT FOR
  END IF
NEXT I

'Verify good baud rate
IF BaudCode = -1 THEN
  PRINT "Cannot recognize baud rate "; ARG2$
  STOP
END IF

' set parmameters for the port
Code = SioParms(Port,NoParity,OneStopBit,WordLength8)
'setup RX buffer

'get segment for 1024 byte buffer area
BufSeg = Buf1024Seg()

Code = SioRxBuf(Port, RxBufSeg, Size512)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

IF SioInfo(ASC("I")) = 0 THEN
  'use all of buffer for RX buffer (1024 bytes)
  RxBufSeg = BufSeg
  RxCode = SioRxBuf(Port, RxBufSeg, Size1024)
  PRINT "Using 1024 RX buffer ";Hex$(RxBufSeg)
ELSE
  'use 1st half of buffer (offset 0) for RX buffer (512 bytes).
  RxBufSeg = BufSeg
  RxCode = SioRxBuf(Port, RxBufSeg, Size512)
  PRINT "Using 512 RX buffer ";Hex$(RxBufSeg)
  'use 2nd half of buffer (offset 512) for TX buffer (512 bytes).
  TxBufSeg = BufSeg + (512/16)
  TxCode = SioTxBuf(Port, TxBufSeg, Size512)
  PRINT "Using 512 TX buffer ";Hex$(TxBufSeg)
END IF

IF RxCode < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF
IF TxCode < 0 THEN
  PRINT "Error "; Code; " returned from SioTxBuf()"
  Code = SioError(Code)
  STOP
END IF

'Reset port
Code = SioReset(Port, BaudCode)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF

CLS
'display info
PRINT "BUFFER 12/31/97"
PRINT "   Port : COM"; LTRIM$(STR$(1+Port))
PRINT "   Baud : ";Rates$(BaudCode)
LibVer = SioInfo(ASC("V"))
PRINT "Library : "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))
PRINT "TX Intr : ";
IF SioInfo(ASC("I")) <> 0 THEN
   PRINT "enabled."
ELSE
   PRINT "not enabled."
END IF
'set DTR & RTS
Code = SioDTR(Port, SET_LINE)
Code = SioRTS(Port, SET_LINE)
' use FIFO if present
Code = SioFIFO(Port,LEVEL_4TH)
PRINT "   UART : "; UartString(Code)

PRINT
IF SioInfo(ASC("I")) = 0 THEN
  PRINT "Using 1024 RX buffer ";Hex$(RxBufSeg)
ELSE
  PRINT "Using 512 RX buffer ";Hex$(RxBufSeg)
  PRINT "Using 512 TX buffer ";Hex$(TxBufSeg)
END IF
PRINT "Entering TERMINAL loop (^Z to quit)..."

DO
  'Anything incoming ?
  Code = SioGetc(Port, 1)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)

END

 