;****************************************************************
;*                                                              *
;*      LOWER (C) 1997 Ronald Nordberg.                         *
;*                                                              *
;*      A little utility that converts all ascii chars in       *
;*      a file to lower case. I mainly use it to convert        *
;*      source code files so they dont look so messy.           * 
;*      Usage: Lower <filename>.                                *
;*                                                              *
;*                                                              *
;*      Ronald Nordberg.                                        *
;*      Silvervgen 3                                           *
;*      907 50 Ume                                             *
;*      Sweden                                                  *
;*      christine.martinson@swipnet.se                          *
;*      http://home2.swipnet.se/~w-20064                        *
;*                                                              *
;*      THIS IS ALL PUBLIC DOMAIN FREEWARE.                     *
;*      LET E'M KNOW IF YOU USE MY CODE.                        *
;*                                                              *
;****************************************************************

video           equ     10h
kbd             equ     16h             ;keyboard irq
msdos           equ     21h             ;MSDOS irq

getmod          equ     0fh

reset           equ     0dh             ;disk reset
dfopen          equ     0fh             ;open disk file
dfclose         equ     10h             ;close disk file
searchf         equ     11h             ;search first
searchn         equ     12h             ;search next
seqread         equ     14h             ;sequential disk read
seqwrite        equ     15h             ;     "       "  write
setdta          equ     1ah             ;set disk transfer area [address]
setdir          equ     3bh             ;set current directory
createf         equ     3ch             ;create file with handle
openf           equ     3dh             ;open file with handle
closef          equ     3eh             ;close file with handle
readf           equ     3fh             ;read from file with handle
writef          equ     40h             ;write to file with handle
seek            equ     42h             ;set file pointer
allocmem        equ     48h             ;allocate memory
freemem         equ     49h             ;free memory
changebs        equ     4ah             ;change block size
findfirst       equ     4eh             ;find first file
findnext        equ     4fh             ;find next file
exit            equ     4c00h           ;msdos exit

[BITS 16]
[ORG 0x100]

progstart:
        mov     ax,cs
        mov     ds,ax
        mov     [comseg],ds

        mov     si,0080h                ;DOS command line page 0
        lodsb                           ;load size of command line
        cmp     al,0                    ;anything on command line ?
        jbe     usage                   ;noo, show usage
        cbw                             ;extend AL to AX
        xchg    bx,ax                   ;swap size to bx for indexing
        mov     byte [bx+si],0          ;null terminate command line
        call    parse                   ;parse command line
        jmp     linok                   ;go on with main
usage:  mov     bx,utext                ;pointer usage text
        jmp     errout                  ;write it out
linok:
        mov     ah,setdta               ;set our DTA-area
        mov     dx,mydta
        int     msdos
        
        mov     ah,findfirst            ;see if the file's out there
        mov     cx,0fh                  ;all files
        mov     dx,inbuff               ;our NULL terminated filname
        int     msdos                   ;do the stuff
        jnc     gotfile                 ;it was there
        mov     bx,errt1                ;error
        jmp     errout
gotfile:
        mov     eax,[mydta+26]
        mov     [filesize],eax          ;save filesize

        mov     ah,openf                ;open file
        mov     al,12h                  ;READ/WRITE/NO SHARE
        mov     dx,inbuff               ;filename
        int     msdos                   ;do the request
        jnc     fopok
        mov     bx,errt1                ;could'nt open
        jmp     errout
fopok:
        mov     [filehandle],ax         ;save filehandle
        mov     word [bytes],256        ;our buffer size
        mov     word [count1],0         ;clear out those
        mov     word [count2],0
readlop:
        mov     ah,readf                ;read from file
        mov     bx,[filehandle]
        mov     cx,[bytes]              ;read buffer full
        mov     dx,address              ;buffer
        int     msdos                   ;call dos
        cmp     ax,0                    ;nothing read ? (end of file)
        ja      main                    ;nooo, do the work
        jmp     wok                     ;yeahh, we're done
main:
        mov     [bytes],ax              ;bytes read
        mov     cx,ax                   ;counter
        mov     si,address              ;file buffer
mloop:  
        mov     byte al,[si]            ;load AL with char
        cmp     al,''                  ;fix the swedish stuff
        je      dos1
        cmp     al,''
        je      dos2
        cmp     al,''
        je      dos3
        cmp     al,'A'                  ;char < A ?
        jb      charok                  ;yeahh, keep it
        cmp     al,'Z'                  ;char <= Z ?
        ja      charok                  ;nooo, keep it
        add     al,32                   ;adjust
        jmp     charok
dos1:   mov     al,''
        jmp     charok
dos2:   mov     al,''
        jmp     charok
dos3:   mov     al,''
charok: mov     byte [si],al
        inc     byte si
        loop    mloop

        mov     ah,seek                 ;set file position
        mov     al,000                  ;offset beginning
        mov     bx,[filehandle]         ;filehandle
        mov     cx,[count1]             ;most significant part of offset
        mov     dx,[count2]             ;least significant part of offset
        int     msdos                   ;adjust file pointer

        mov    cx,[bytes]               ;get offset size
        mov    dx,[count1]              ;the most significant part
        mov    ax,[count2]              ;the least significant part
        add    ax,cx                    ;add offset to least sig part
        adc    dx,0                     ;add with carry
        mov    [count1],dx              ;save them back for next loop
        mov    [count2],ax         

        mov     ah,writef               ;write to file
        mov     bx,[filehandle]         ;handle
        mov     cx,[bytes]              ;write bytes read
        mov     dx,address              ;buffer
        int     msdos                   ;do the write
        jc      werr                    ;error
        cmp     word [bytes],256        ;less than 256 bytes left ?
        jb      wok                     ;yeahh, must be last read
        jmp     readlop                 ;noo, go on reading
werr:   mov     bx,errt4                ;write failure
        jmp     errout                  ;let us know
wok:
        mov     bx,text1                ;let us know we're done
errout:
        call    write
quit:                         
        cmp     word [filehandle],0     ;any filehandle
        je      nofile                  ;noo
        mov     bx,[filehandle]         ;yeahh, get it
        mov     ah,closef
        int     msdos                   ;close file
        jnc     nofile
        mov     bx,errt5
        call    write
nofile: 
        xor     eax,eax
        mov     ax,exit                 ;function 4Ch - terminate process
        int     msdos                   ;dos service call
        
;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*       OR writes out data,BX and size,CX if called at lwrite.          *
;*************************************************************************
write:  pusha
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop:  lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      lwrite                   ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
lwrite: mov     dx,bx                   ;text [address] in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,writef               ;MS-DOS writefile with handle is 040
        int     msdos                   ;write buffer to standard output
        popa
        ret                             ;done

;*************************************************************************
;*      My kind of command line parsing. It just checks if there is
;*      any blankspaces between the options. The parameters ends up
;*      in the inbuff separated by 0:s, binary zeroes.
;*************************************************************************
parse:
        mov     di,inbuff               ;our buffer
dospc:  cmp     byte [si],32            ;any leading spaces ?
        jne     nospc                   ;nooo
        inc     si                      ;yeahh, dump it
        jmp     dospc                   ;check next
nospc:  mov     cx,1                    ;we're here, so we got one arg
copy1:  lodsb                           ;load byte SI to AL
        cmp     al,0                    ;0 ?(end of line)
        je      done                    ;yeahh
        cmp     al,32                   ;SPACE ?
        je      cop2                    ;yeah
        stosb                           ;noo, move AL to DI, incrase DI
        jmp     copy1                   ;go on
cop2:   mov     byte [di],0             ;null terminate
        add     cx,1
        inc     di                      ;dump that byte(SPACE)
        jmp     copy1                   ;back
done:   mov     byte [di],0             ;null terminate
        ret                             ;return

;*********************************************************************
;       Convert binary to ascii decimal.
;       Input EDX binary DWORD                   
;       Result NULL terminated in numbuff                             
;**********************************************************************       
bindec: pushad
        mov     di,numbuff
        mov     cx,10                  ;10 chars
        mov     al,32                  ;blankspaces
        stosb                          ;copy AL,DI
        repe    stosb                  ;repeat 10 times
        mov     byte [di],0            ;null terminate buffer
        sub     di,1                   ;start of buffer
        std                            ;decrease DI,SI
convdec:  
        mov     eax,edx                ;add in numerator
        mov     edx,0                  ;clear top half
        mov     ecx,10                 ;enter decimal divisor
        div     ecx                    ;perform division AX/CX
        xchg    eax,edx                ;get quotient
        add     al,30h                 ;make digit ASCII
        stosb                          ;store digit in buffer
        cmp     edx,0                  ;test for end of binary
        jnz     convdec                ;continue if not end
        cld                            ;restore direction flag
        popad                          ;restore regs
        ret

;****************************** DATA *****************************

filesize        dd      0
offset          dd      0

memsize         dw      0
filehandle      dw      0
bytes           dw      0
comseg          dw      0
count1          dw      0
count2          dw      0
numbuff         times  8 dw 0
inbuff          times 64 dw 0
mydta           times 64 dw 0
address         times 128 dw 0

utext   db      'LOWER (C) 1997 RonSoft.',13,10
        db      'Usage: Lower <filename>.',13,10,0
text1   db      'File converted and saved OK.',13,10,0
errt0   db      'Mem resize error.',13,10,0
errt1   db      'File not found.',13,10,0
errt2   db      'Could not allocate enough memory.',13,10,0
errt3   db      'File read error.',13,10,0
errt4   db      'File write error.',13,10,0
errt5   db      'Could not close file.',13,10,0

progend:
        END
