{ *******************************************************************
  *			    This file is part of the WMFH package				*
  ******************************************************************* }

{ *******************************************************************
  *				 This file comes from the SWAG library	 	  	    *	
  ******************************************************************* }


{
  Complete set of all keyboard scan codes.
  Part of the Heartware Toolkit v2.00 (HTkb.PAS) for Turbo Pascal.
  Author: Jose Almeida. P.O.Box 4185. 1504 Lisboa Codex. Portugal.
          I can also be reached at RIME network, site ->TIB or #5314.
  Feel completely free to use this source code in any way you want, and, if
  you do, please don't forget to mention my name, and, give me and Swag the
  proper credits.
}

{ Modified (1997) by Gianfranco Boggio-Togna (gbt@computer.org)

	-- added codes for the numeric keypad
	-- added KB_read function
	-- made cosmetic changes
}


UNIT KB_unit;


{ ************************************************************************
  *																		 *
  *				        U N I T    I N T E R F A C E  					 *
  *																		 *
  ************************************************************************ }

INTERFACE

USES	Dos ;

CONST

{ letters  }

  KB_AA                  = $1E61;     { a                                }
  KB_A                   = $1E41;     { A                                }
  KB_CtrlA               = $1E01;     { ^A                               }
                                      { SOH - Start Of Header            }
  KB_AltA                = $1E00;     { ALT A                            }

  KB_BB                  = $3062;     { b                                }
  KB_B                   = $3042;     { B                                }
  KB_CtrlB               = $3002;     { ^B                               }
                                      { STX - Start Of Text              }
  KB_AltB                = $3000;     { ALT B                            }

  KB_CC                  = $2E63;     { c                                }
  KB_C                   = $2E43;     { C                                }
  KB_CtrlC               = $2E03;     { ^C                               }
                                      { ETX - End Of Text                }
  KB_AltC                = $2E00;     { ALT C                            }

  KB_DD                  = $2064;     { d                                }
  KB_D                   = $2044;     { D                                }
  KB_CtrlD               = $2004;     { ^D                               }
                                      { EOT - End Of Transmission        }
  KB_AltD                = $2000;     { ALT D                            }

  KB_EE                  = $1265;     { e                                }
  KB_E                   = $1245;     { E                                }
  KB_CtrlE               = $1205;     { ^E                               }
                                      { ENQ - Enquire                    }
  KB_AltE                = $1200;     { ALT E                            }

  KB_FF                  = $2166;     { f                                }
  KB_F                   = $2146;     { F                                }
  KB_CtrlF               = $2106;     { ^F                               }
                                      { ACK - Acknowledge                }
  KB_AltF                = $2100;     { ALT F                            }

  KB_GG                  = $2267;     { g                                }
  KB_G                   = $2247;     { G                                }
  KB_CtrlG               = $2207;     { ^G                               }
                                      { BEL - Bell                       }
  KB_AltG                = $2200;     { ALT G                            }

  KB_HH                  = $2368;     { h                                }
  KB_H                   = $2348;     { H                                }
  KB_CtrlH               = $2308;     { ^H                               }
                                      { BS - BackSpace                   }
  KB_AltH                = $2300;     { ALT H                            }

  KB_II                  = $1769;     { i                                }
  KB_I                   = $1749;     { I                                }
  KB_CtrlI               = $1709;     { ^I                               }
                                      { HT - Horizontal Tab              }
  KB_AltI                = $1700;     { ALT I                            }

  KB_JJ                  = $246A;     { j                                }
  KB_J                   = $244A;     { J                                }
  KB_CtrlJ               = $240A;     { ^J                               }
                                      { LF - Line Feed                   }
  KB_AltJ                = $2400;     { ALT J                            }

  KB_KK                  = $256B;     { k                                }
  KB_K                   = $254B;     { K                                }
  KB_CtrlK               = $250B;     { ^K                               }
                                      { VT - Vertical Tab                }
  KB_AltK                = $2500;     { ALT K                            }

  KB_LL                  = $266C;     { l                                }
  KB_L                   = $264C;     { L                                }
  KB_CtrlL               = $260C;     { ^L                               }
                                      { FF - Form Feed (new page)        }
  KB_AltL                = $2600;     { ALT L                            }

  KB_MM                  = $326D;     { m                                }
  KB_M                   = $324D;     { M                                }
  KB_CtrlM               = $320D;     { ^M                               }
                                      { CR - Carriage Return             }
  KB_AltM                = $3200;     { ALT M                            }

  KB_NN                  = $316E;     { n                                }
  KB_N                   = $314E;     { N                                }
  KB_CtrlN               = $310E;     { ^N                               }
                                      { SO - Shift Out (numbers)         }
  KB_AltN                = $3100;     { ALT N                            }

  KB_OO                  = $186F;     { o                                }
  KB_O                   = $184F;     { O                                }
  KB_CtrlO               = $180F;     { ^O                               }
                                      { SI - Shift In (letters)          }
  KB_AltO                = $1800;     { ALT O                            }

  KB_PP                  = $1970;     { p                                }
  KB_P                   = $1950;     { P                                }
  KB_CtrlP               = $1910;     { ^P                               }
                                      { DEL - Delete                     }
  KB_AltP                = $1900;     { ALT P                            }

  KB_QQ                  = $1071;     { q                                }
  KB_Q                   = $1051;     { Q                                }
  KB_CtrlQ               = $1011;     { ^Q                               }
                                      { DC1 - Device Control 1           }
  KB_AltQ                = $1000;     { ALT Q                            }

  KB_RR                  = $1372;     { r                                }
  KB_R                   = $1352;     { R                                }
  KB_CtrlR               = $1312;     { ^R                               }
                                      { DC2 - Device Control 2           }
  KB_AltR                = $1300;     { ALT R                            }

  KB_SS                  = $1F73;     { s                                }
  KB_S                   = $1F53;     { S                                }
  KB_CtrlS               = $1F13;     { ^S                               }
                                      { DC3 - Device Control 3           }
  KB_AltS                = $1F00;     { ALT S                            }

  KB_TT                  = $1474;     { t                                }
  KB_T                   = $1454;     { T                                }
  KB_CtrlT               = $1414;     { ^T                               }
                                      { DC4 - Device Control 4           }
  KB_AltT                = $1400;     { ALT T                            }

  KB_UU                  = $1675;     { u                                }
  KB_U                   = $1655;     { U                                }
  KB_CtrlU               = $1615;     { ^U                               }
                                      { NAK - Negative Acknowlegde       }
  KB_AltU                = $1600;     { ALT U                            }

  KB_VV                  = $2F76;     { v                                }
  KB_V                   = $2F56;     { V                                }
  KB_CtrlV               = $2F16;     { ^V                               }
                                      { SYN - Syncronize                 }
  KB_AltV                = $2F00;     { ALT V                            }

  KB_WW                  = $1177;     { w                                }
  KB_W                   = $1157;     { W                                }
  KB_CtrlW               = $1117;     { ^W                               }
                                      { ETB - End of Text Block          }
  KB_AltW                = $1100;     { ALT W                            }

  KB_XX                  = $2D78;     { x                                }
  KB_X                   = $2D58;     { X                                }
  KB_CtrlX               = $2D18;     { ^X -                             }
                                      { CAN - Cancel                     }
  KB_AltX                = $2D00;     { ALT X                            }

  KB_YY                  = $1579;     { y                                }
  KB_Y                   = $1559;     { Y                                }
  KB_CtrlY               = $1519;     { ^Y                               }
                                      { EM - End of Medium               }
  KB_AltY                = $1500;     { ALT Y                            }

  KB_ZZ                  = $2C7A;     { z                                }
  KB_Z                   = $2C5A;     { Z                                }
  KB_CtrlZ               = $2C1A;     { ^Z                               }
                                      { SUB - Substitute                 }
  KB_AltZ                = $2C00;     { ALT Z                            }

{ numbers  }

  KB_1                   = $0231;     { 1                                }
  KB_Pad1                = $4F31;     { SHIFT 1      number pad          }
  KB_Alt1                = $7800;     { ALT 1                            }

  KB_2                   = $0332;     { 2                                }
  KB_Pad2                = $5032;     { SHIFT 2      number pad          }
  KB_Alt2                = $7900;     { ALT 2                            }
  KB_Ctrl2               = $0300;     { ^1 (NUL)                         }

  KB_3                   = $0433;     { 3                                }
  KB_Pad3                = $5133;     { SHIFT 3      number pad          }
  KB_Alt3                = $7A00;     { ALT 3                            }

  KB_4                   = $0534;     { 4                                }
  KB_Pad4                = $4B34;     { SHIFT 4      number pad          }
  KB_Alt4                = $7B00;     { ALT 4                            }

  KB_5                   = $0635;     { 5                                }
  KB_Pad5                = $4C35;     { SHIFT 5      number pad          }
  KB_Alt5                = $7C00;     { ALT 5                            }

  KB_6                   = $0736;     { 6                                }
  KB_Pad6                = $4D36;     { SHIFT 6      number pad          }
  KB_Ctrl6               = $071E;     { ^6 (RS)                          }
  KB_Alt6                = $7D00;     { ALT 6                            }

  KB_7                   = $0837;     { 7                                }
  KB_Pad7                = $4737;     { SHIFT 7      number pad          }
  KB_Alt7                = $7E00;     { ALT 7                            }

  KB_8                   = $0938;     { 8                                }
  KB_Pad8                = $4838;     { SHIFT 8      number pad          }
  KB_Alt8                = $7F00;     { ALT 8                            }

  KB_9                   = $0A39;     { 9                                }
  KB_Pad9                = $4939;     { SHIFT 9      number pad          }
  KB_Alt9                = $8000;     { ALT 9                            }

  KB_0                   = $0B30;     { 0                                }
  KB_Pad0                = $5230;     { SHIFT 0      number pad          }
  KB_Alt0                = $8100;     { ALT 0                            }

{ etc: characters  }

  KB_Less                = $333C;     { <                                }
  KB_Great               = $343E;     { >                                }

  KB_Minus               = $352D;     { -                                }
  KB_GrayMinus           = $4A2D;     { -                                }
  KB_CtrlMinus           = $0C1F;     { ^-                               }
  KB_AltMinus            = $8200;     { ALT -                            }
  KB_ShiftGrayMinus      = $4A2D;     { SHIFT -                          }

  KB_Plus                = $1A2B;     { +                                }
  KB_GrayPlus            = $4E2B;     { +                                }
  KB_WhitePlus           = $0D2B;     { +                                }
  KB_ShiftGrayPlus       = $4E2B;     { SHIFT +                          }

  KB_Equal               = $0D3D;     { =                                }
  KB_AltEqual            = $8300;     { ALT =                            }

  KB_Slash               = $352F;     { /                                }

  KB_BackSlash           = $2B5C;     { \                                }
  KB_CtrlBackSlash       = $2B1C;     { ^\                               }
                                      { FS - File Separator              }

  KB_OpenBracket         = $1A5B;     { [                                }
  KB_CtrlOpenBracket     = $1A1B;     { ^[                               }
                                      { ESC - Escape                     }

  KB_CloseBracket        = $1B5D;     { ]                                }
  KB_CtrlCloseBracket    = $1B1D;     { ^]                               }
                                      { GS - Group Separator             }

  KB_OpenParenthesis     = $0A28;     { (                                }

  KB_CloseParenthesis    = $0B29;     { )                                }

  KB_OpenBrace           = $1A7B;     { can't write it                   }

  KB_CloseBrace          = $1B7D;     { can't write it                   }

  KB_Apostrophe          = $2827;     { '                                }
  KB_Grave               = $2960;     { `                                }

  KB_Quote               = $2822;     { "                                }

  KB_Tilde               = $297E;     { ~                                }

  KB_Cater               = $075E;     { ^                                }

  KB_Semicolon           = $273B;     { ;                                }

  KB_Comma               = $332C;     { ,                                }

  KB_Colon               = $273A;     { :                                }

  KB_Period              = $342E;     { .                                }
  KB_GrayPeriod          = $532E;     { SHIFT .      number pad          }

  KB_GrayAsterisk        = $372A;     { *                                }
  KB_WhiteAsterisk       = $1A2A;     { *                                }

  KB_ExclamationPoint    = $0221;     { !                                }

  KB_QuestionMark        = $353F;     { ?                                }

  KB_NumberSign          = $0423;     { #                                }

  KB_Dollar              = $0524;     { $                                }

  KB_Percent             = $0625;     { %                                }

  KB_AmpersAnd           = $0826;     { &                                }

  KB_At                  = $0340;     { @                                }
                                      { ^@  = 00h                        }
                                      { NUL - Null Character             }
  KB_UnitSeparator       = $0C5F;     { _                                }
                                      { ^_  = 1Fh                        }
                                      { US  - Unit Separator             }

  KB_Vertical            = $2B7C;     { |                                }

  KB_Space               = $3920;     { SPACE BAR                        }

{ functions  }

  KB_F1                  = $3B00;     { F1                               }
  KB_ShiftF1             = $5400;     { SHIFT F1                         }
  KB_CtrlF1              = $5E00;     { ^F1                              }
  KB_AltF1               = $6800;     { ALT F1                           }

  KB_F2                  = $3C00;     { F2                               }
  KB_ShiftF2             = $5500;     { SHIFT F2                         }
  KB_CtrlF2              = $5F00;     { ^F2                              }
  KB_AltF2               = $6900;     { ALT F2                           }

  KB_F3                  = $3D00;     { F3                               }
  KB_ShiftF3             = $5600;     { SHIFT F3                         }
  KB_CtrlF3              = $6000;     { ^F3                              }
  KB_AltF3               = $6A00;     { ALT F3                           }

  KB_F4                  = $3E00;     { F4                               }
  KB_ShiftF4             = $5700;     { SHIFT F4                         }
  KB_CtrlF4              = $6100;     { ^F4                              }
  KB_AltF4               = $6B00;     { ALT F4                           }

  KB_F5                  = $3F00;     { F5                               }
  KB_ShiftF5             = $5800;     { SHIFT F5                         }
  KB_CtrlF5              = $6200;     { ^F5                              }
  KB_AltF5               = $6C00;     { ALT F5                           }

  KB_F6                  = $4000;     { F6                               }
  KB_ShiftF6             = $5900;     { SHIFT F6                         }
  KB_CtrlF6              = $6300;     { ^F6                              }
  KB_AltF6               = $6D00;     { ALT F6                           }

  KB_F7                  = $4100;     { F7                               }
  KB_ShiftF7             = $5A00;     { SHIFT F7                         }
  KB_CtrlF7              = $6400;     { ^F7                              }
  KB_AltF7               = $6E00;     { ALT F7                           }

  KB_F8                  = $4200;     { F8                               }
  KB_ShiftF8             = $5B00;     { SHIFT F8                         }
  KB_CtrlF8              = $6500;     { ^F8                              }
  KB_AltF8               = $6F00;     { ALT F8                           }

  KB_F9                  = $4300;     { F9                               }
  KB_ShiftF9             = $5C00;     { SHIFT F9                         }
  KB_CtrlF9              = $6600;     { ^F9                              }
  KB_AltF9               = $7000;     { ALT F9                           }

  KB_F10                 = $4400;     { F10                              }
  KB_ShiftF10            = $5D00;     { SHIFT F10                        }
  KB_CtrlF10             = $6700;     { ^F10                             }
  KB_AltF10              = $7100;     { ALT F1\0                         }

{ cursors  }

  KB_Up                  = $4800;     { UP                               }

  KB_Down                = $5000;     { DOWN                             }

  KB_Left                = $4B00;     { LEFT                             }
  KB_CtrlLeft            = $7300;     { ^LEFT                            }

  KB_Right               = $4D00;     { RIGHT                            }
  KB_CtrlRight           = $7400;     { ^RIGHT                           }

  KB_Home                = $4700;     { HOME                             }
  KB_CtrlHome            = $7700;     { ^HOME                            }

  KB_End                 = $4F00;     { END                              }
  KB_CtrlEnd         	 = $7500;     { ^END                             }

  KB_PgUp                = $4900;     { PG UP                            }
  KB_CtrlPgUp            = $8400;     { ^PG UP                           }

  KB_PgDown              = $5100;     { PG DN                            }
  KB_CtrlPgDown          = $7600;     { ^PG DN                           }

{ etc: keys  }

  KB_Esc                 = $011B;     { ESC                              }

  KB_Enter               = $1C0D;     { RETURN                           }
  KB_CtrlEnter           = $1C0A;     { ^ENTER                           }
                                      { LF - Line Feed                   }


  KB_BackSpace           = $0E08;     { BACKSPACE                        }
  KB_CtrlBackspace       = $0E7F;     { ^BACKSPACE                       }
                                      { DEL - Delete                     }

  KB_Tab                 = $0F09;     { TAB                              }
  KB_ShiftTab            = $0F00;     { SHIFT TAB                        }

  KB_Ins                 = $5200;     { INSERT                           }
  KB_GrayIns             = $5230;     { Gray  Insert                     }

  KB_Del                 = $5300;     { DELETE                           }

  KB_45                  = $565C;     { Key 45                       [2] }
  KB_Shift45             = $567C;     { SHIFT KEY 45                 [2] }

  KB_CtrlPrtSc           = $7200;     { ^PRTSC                       [2] }

  KB_CtrlBreak           = $0000;     { ^BREAK                       [2] }



{ footnotes 

  [1] All key codes refers to Interrupt 16h Services 0 and 1,
      the "Standard Function", that works with all keyboards types.

  [2] These key codes are only availlable in the 101/102-key keyboard,
      the current IBM standard ("Enhanced") keyboard.



INT 16h,  00h (0)        Keyboard Read                                   all

    Returns the next character in the keyboard buffer; if no character is
    available, this service waits until one is available.

       On entry:      AH         00h

       Returns:       AL         ASCII character code
                      AH         Scan code

  

       Notes:         The scan codes are the numbers representing the
                      location of the key on the keyboard. As new keys
                      have been added and the keyboard layout rearranged,
                      this numbering scheme has not been consistent with
                      its original purpose.

                      If the character is a special character, then AL
                      will be 0 and the value in AH will be the extended
                      scan code for the key.

                      Use the scan codes to differentiate between keys
                      representing the same ASCII code, such as the plus
                      key across the top of the keyboard and the gray plus
                      key.

                      After the character has been removed from the
                      keyboard buffer, the keyboard buffer start pointer
                      (at 0:041Ah) is increased by 2. If the start pointer
                      is beyond the end of the buffer, the start pointer
                      is reset to the start of the keyboard buffer.

                      If no character is available at the keyboard, then
                      the AT, XT-286, and PC Convertible issue an INT 15h,
                      Service 90h (Device Busy), for the keyboard,
                      informing the operating system that there is a
                      keyboard loop taking place and thereby allowing the
                      operating system to perform another task.

                      After every character is typed, the AT, XT-286, and
                      PC Convertible issue an INT 15h, Service 91h
                      (Interrupt Complete). This allows the operating
                      system to switch back to a task that is waiting for
                      a character at the keyboard.

                      See Service 10h for an equivalent service that
                      supports the enhanced (101/102-key) keyboard.



INT 16h,  01h (1)        Keyboard Status                                 all
    Checks to see if a character is available in the buffer.

       On entry:      AH         01h

       Returns:       Zero       0, if character is available
                                 1, if character is not available
                      AL         ASCII character code (if character is
                                 available)
                      AH         Scan code (if character is available)

  

       Notes:         If a character is available, the Zero Flag is
                      cleared and AX contains the ASCII value in AL and
                      the scan code in AH. The character is not removed
                      from the buffer. Use Service 00h to remove the
                      character from the buffer. See Service 00h for a
                      complete description of the meaning of AX if a
                      character is available.

                      This service is excellent for clearing the keyboard
                      or allowing a program to be interruptable by a
                      specific key sequence.

                      See Service 11h for an equivalent service that
                      supports the enhanced (101/102-key) keyboard.

 }

FUNCTION KB_Read : Word ;


{ ************************************************************************
  *																		 *
  *					 U N I T	I M P L E M E N T A T I O N				 *
  *																		 *
  ************************************************************************ }

IMPLEMENTATION

FUNCTION KB_Read : Word ;
VAR
	regs:	Registers ;
BEGIN
	regs.ah := 0 ;
	intr($16, regs) ;
	KB_Read := (regs.ah shl 8) + regs.al ;
END ;


END. 


