{$v-}
Program IODEM5_Multiple_Input_Pages;

{
 This Example is designed to illustrate how multiple input forms could be
 presented to the user, and accessed with PGUp and PgDn.

 For illustration, this example uses just two input "pages", but the
 template could be followed to input multiple pages.

 The basic approach is to create one input table for each "page", keep
 track of which table is active, and use a character hook to trap for
 PgUp and PgDn, return End_Input and proceed to other table.
}

USES DOS,CRT,FASTTTT5,WINTTT5,IOTTT5;

const
   HCol = lightgray;
   FCol = white;
   BCol = red;
   Width = 35;

type
   FieldStr  = string[Width];

var
  Name,                  {Input Field Variables}
  Addr1,
  Addr2,
  City,
  State,
  Zip,
  Country,
  Tel,
  Source   : FieldStr;
  Media    : Byte;
  Comments : String;
  Copies   : Byte;
  Shipping,
  Tax,
  Total    : FieldStr;
  Method   : Byte;
  CardNumber,
  ExpDate,
  CardName : FieldStr; 

  Next_Table : byte;

{++++++++++++++++++}
{                  }
{  CHARACTER HOOK  }
{                  }
{++++++++++++++++++}

{$F+}
 procedure PageCharHook(var Ch : char; var CurrentField:byte;var Refresh:byte);
 {Traps for PgUp, PgDn, Esc}
 var ChE : char;
 begin
     Case Ch of
     #201 : begin       {PgUp}
                If Next_Table = 2 then
                begin
                    Next_Table := 1;
                    Refresh := End_Input;
                end;
            end;
     #209 : begin       {PgDn}
                If Next_Table = 1 then
                begin
                    Next_Table := 2;
                    Refresh := End_Input;
                end;
            end;
     #027 : begin       {Esc}
                TempMessageBoxCh(20,12,white,blue,1,'Do you want to abort edit session? (Y/N) ',ChE);
                If Upcase(ChE) = 'Y' then
                begin
                    Next_Table := 0;
                    Refresh := End_Input;
                end
                else
                    Ch := No_Char;
            end;
     end; {case}
 end;
{$F-}

{++++++++++++++++++++++++}
{                        }
{  SCREEN WRITING PROCS  }
{                        }
{++++++++++++++++++++++++}

 Procedure Clear_Page;
 {Sets up Field 1 input form}
 begin
     FBox(1,1,80,24,HCol,BCol,1);
     ClearLine(25,white,black);
     WriteCenter(2,HCol,BCol,'TECHNOJOCK''S TURBO TOOLKIT');
     WriteCenter(3,HCol,BCol,'REGISTRATION');
     WriteCenter(5,HCol,BCol,'Copyright 1986,1989 TechnoJock Software, Inc.');
 end; {of proc Clear_Page}

 Procedure Display_Page1;
 {}
 begin
     Clear_Page;
     WriteAt(69,2,HCol,BCol,'Page 1 of 2');
     WriteCenter(25,lightred,Black,'Press PgDn to enter more information or F10 to finish');
     WriteAt(3,7,FCol,BCol,'Name');
     WriteAt(3,9,FCol,BCol,'Address');
     WriteAt(3,13,FCol,BCol,'City');
     WriteAt(40,13,FCol,BCol,'State');
     WriteAt(60,13,FCol,BCol,'Zip');
     WriteAt(3,15,FCol,BCol,'Country');
     WriteAt(3,17,FCol,BCol,'Telephone');
     WriteAt(3,19,FCol,BCol,'Where did you obtain the Toolkit?');
     WriteAt(3,21,FCol,BCol,'Comments');
 end; {of proc Display_Page1}

 Procedure Display_Page2;
 {}
 begin
     Clear_Page;
     WriteAt(69,2,HCol,BCol,'Page 2 of 2');
     WriteCenter(25,lightred,Black,'Press PgUp to enter more information or F10 to finish');
     WriteAt(3,7,FCol,BCol,'Media');
     WriteAt(15,7,HCol,BCol,'(Enter: 1 for 360K, 2 for 1.2Mb, or 3 for 720k)');
     WriteAt(3,9,FCol,BCol,'No. of Copies required');
     WriteAt(3,11,HCol,BCol,'Shipping & Handling (per Copy)');
     WriteAt(8,12,HCol,BCol,'USA         $5.00');
     WriteAt(8,13,HCol,BCol,'Canada/Mex $10.00');
     WriteAt(8,14,HCol,BCol,'Overseas   $15.00');
     WriteAt(27,14,FCol,BCol,'Shipping');
     WriteAt(3,16,FCol,BCol,'Texas Residents add 8% Sales Tax');
     WriteAt(3,18,FCol,BCol,'Payment Method');
     WriteAt(20,18,HCol,BCol,'(Enter: 1 for MasterCard, 2 for Visa, or 3 for Check)');
     WriteAt(3,20,FCol,BCol,'Card Number');
     WriteAt(55,20,FCol,BCol,'Expiration Date');
     WriteAt(3,22,FCol,BCol,'Name on Card');
 end; {of proc Display_Page2}

{++++++++++++++++++++}
{                    }
{  FIELD INIT PROCS  }
{                    }
{++++++++++++++++++++}
 Procedure Init_Vars;
 {}
 begin
     Name := '';
     Addr1:= '';
     Addr2:= '';
     City:= '';
     State := '';
     Zip := '';
     Country := '';
     Tel := '';
     Source := '';
     Media := 1;
     Comments := '';
     Copies := 1;
     Shipping := '';
     Tax := '';
     Total := '';
     Method := 1;
     CardNumber := '';
     ExpDate := '';
     CardName := '';

     Next_Table := 1;
 end; {of proc Init_Vars}

 Procedure Init_Table1;
 {}
 begin
     Activate_Table(1);
     Create_Fields(10);
     Add_Field(1, 10,2,10,2, 13,7);
     Add_Field(2,  1,3,1,3,  13,9);
     Add_Field(3,  2,4,2,4,  13,11);
     Add_Field(4,  3,5,3,5,  13,13);
     Add_Field(5,  4,6,4,6,  46,13);
     Add_Field(6,  5,7,5,7,  65,13);
     Add_Field(7,  6,8,6,8,  13,15);
     Add_Field(8,  7,9,7,9,  13,17);
     Add_Field(9,  8,10,8,10, 38,19);
     Add_Field(10, 9,1,9,1,  13,21);
     String_Field(1, Name,   Replicate(width,'*'));
     String_Field(2, Addr1,  Replicate(width,'*'));
     String_Field(3, Addr2,  Replicate(width,'*'));
     String_Field(4, City,   Replicate(25,'*'));
     String_Field(5, State,  '!!');
     String_Field(6, Zip,    '#####');
     String_Field(7, Country,Replicate(width,'*'));
     String_Field(8, Tel,    '###################');
     String_Field(9, Source, Replicate(width,'*'));
     String_Field(10,Comments, replicate(60,'*'));
     Assign_CharHook(PageCharHook);
 end; {of proc Init_Table1}

 Procedure Init_Table2;
 {}
 begin
     Activate_Table(2);
     Create_Fields(8);
     Add_Field(1,  8,2,8,2, 12,7);
     Add_Field(2,  1,3,1,3, 40,9);
     Add_Field(3,  2,4,2,4, 40,14);
     Add_Field(4,  3,5,3,5, 40,16);
     Add_Field(5,  4,6,4,6, 18,18);
     Add_Field(6,  5,7,5,7, 18,20);
     Add_Field(7,  6,8,6,8, 74,20);
     Add_Field(8,  7,1,7,1, 18,22);
     Byte_Field(1, Media, '#', 1,3);
     Byte_Field(2, Copies,'##',1,99);
     String_Field(3, Shipping, '#####');
     String_Field(4, Tax, '#####');
     Byte_Field(5, Method, '#', 1,3);
     String_Field(6, CardNumber, Replicate(width,'*'));
     String_Field(7, ExpDate,    '##/##');
     String_Field(8, CardName,   Replicate(width,'*'));
     Assign_CharHook(PageCharHook);
 end; {of proc Init_Table2}

{+++++++++++++++++++}
{                   }
{   PROCESS INPUT   }
{                   }
{+++++++++++++++++++}

    Procedure Process_Table1(Field:byte);
    {}
    begin
        Activate_Table(1);
        Display_Page1;
        Display_All_Fields;
        Process_Input(Field);
    end; {of proc Process_Table1}

    Procedure Process_Table2;
    {}
    begin
        Activate_Table(2);
        Display_Page2;
        Display_All_Fields;
        Process_Input(1);
    end; {of proc Process_Table2}



begin {main}
    ClrScr;
    Create_Tables(2);
    Init_Vars;
    Init_Table1;
    Init_Table2;
    Process_Table1(1);
    Repeat
         If Next_Table = 1 then
            Process_Table1(10)
         else
         If Next_Table = 2 then
            Process_Table2;
    Until (Next_Table = 0) or (I_Char = #196);
    If Next_Table = 0 then
       {The user pressed ESC do something}
    else
       {The user pressed F10 go save the data}
end.
