{----------------------------------------------------------------------------
 |  Program DELAY.PAS                                                       |
 |                                                                          |
 |  This program demonstrates the high resolution delay functionality of    |
 |  TPHRT V3.0.                                                             |
 |                                                                          |
 |  (c) 1989 Ryle Design, P.O. Box 22, Mt. Pleasant, Michigan 48804         |
 |                                                                          |
 |  V3.00  Shareware evaluation version                                     |
 ----------------------------------------------------------------------------}
uses
    tphrt;

var

    min_delay      : longint;
    step_delay     : longint;
    delay_request  : longint;
    hits           : longint;
    elapsed        : longint;
    resolution     : real;
    delay_error    : real;
    delay_ff       : real;
    dp             : tdelay_type;


procedure demo_delay(how_long : longint);
{----------------------------------------------------------------------------
 |  This procedure executes the requested high resolution delay, reports    |
 |  the deviation and percent error, calculates an additional delay         |
 |  optimization, and executes the delay again.                             |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: (longint) how_long - requested delay duration                |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var

    hits           : longint;
    elapsed        : longint;
    min_delay      : longint;
    resolution     : real;

begin
        t_ask_delay(how_long,dp);
        t_reset(1);

        if (delay_request < 54000) then
        begin
            write('Delay with interrupts disabled ... ');
            t_entry(1);
            t_do_delay(dp);
            t_exit(1);
            writeln('complete.');
        end
        else
        begin
            write('Delay with interrupts enabled ... ');
            t_entry(1);
            t_do_delay_wints(dp);
            t_exit(1);
            writeln('complete.');
        end;

        t_ask_timer(1,hits,elapsed);

        delay_error :=  (abs(elapsed - how_long) / how_long) * 100.0;

        writeln('Delay requested: ',how_long,'  Actual: ',elapsed,'  Error: ',delay_error:5:3,'%.');

        writeln;
        write('Calculating additional delay optimization with t_calc_delay_ff ... ');
        if (how_long < 54000) then
            delay_ff := t_calc_delay_ff(how_long,NO_INTS_ON)
        else
            delay_ff := t_calc_delay_ff(how_long,INTS_ON);
        writeln(delay_ff:6:4);

        t_ask_delay(how_long,dp);
        t_reset(1);

        if (how_long < 54000) then
        begin
            write('Delay with interrupts disabled ... ');
            t_entry(1);
            t_do_delay(dp);
            t_exit(1);
            writeln('complete.');
        end
        else
        begin
            write('Delay with interrupts enabled ... ');
            t_entry(1);
            t_do_delay_wints(dp);
            t_exit(1);
            writeln('complete.');
        end;

        t_ask_timer(1,hits,elapsed);

        delay_error := (abs(elapsed - how_long) / how_long) * 100.0;

        writeln('Delay requested: ',how_long,'  Actual: ',elapsed,'  Error: ',delay_error:5:3,'%.');

        t_set_delay_ff(1.0);

end; { demo_delay }


begin

    writeln('Delay Test - TPHRT V3 Demonstration Series');
    writeln(' ');

    t_start;

    min_delay  := t_min_delay;
    resolution := t_res_delay / 10.0;

    writeln('In this hardware environment, minimum delay possible is ',min_delay,' usec.');
    writeln('Delay resolution is ',resolution:3:1,' usec.');

    writeln(' ');
    write('Enter desired delay in microseconds: ',t_min_delay,' - 1000000, 0 to quit >> ');
    readln(delay_request);

    while (delay_request <> 0) do
    begin
        if (delay_request < min_delay) then
            delay_request := min_delay
        else if (delay_request > 1000000) then
            delay_request := 1000000;

        demo_delay(delay_request);

        writeln(' ');
        write('Enter desired delay in microseconds: ',t_min_delay,' - 1000000, 0 to quit >> ');
        readln(delay_request);

    end;

    t_stop;

    writeln(' ');
    writeln('Delay Test complete.');

end. { delay }
