Program TestXMS;

{$M 4096,5000,5000}     {Need about 5k for the XMS Heap Pointers}

Uses CRT,XMSHeap,TPXMS;

Const
  ScreenPtr  : Pointer = Ptr($B800,0);  {Point to Colour Screen, B&W is $B000}

Var
  MaxXMSHeap :Word;
  C          :Byte;
  X          :Word;
  Handle     :Array[33..254] of Word;
  P          :Pointer;

Begin
  If Not IsXMS Then Halt;
  QueryFreeMemXMS;              {How much XMS is there?}
  MaxXMSHeap:=XMSResult;
  WriteLn('Heap Size is ',MaxXMSHeap,' kb.');

  GetXMSHeap(MaxXMSHeap);       {Allocate all XMS to our XMS Heap}

  QueryFreeMemXMS;
  WriteLn('XMS Remaining is ',XMSResult,' kb.');

  ClrScr;
  For C:=33 to 254 do   {Save 254-33+1=222 Screens, that is, 4*222=888kb}
  Begin
    FillChar(ScreenPtr^,1840 * 2,C);    {Fill Screen With Rubbish}
    GotoXY(1,25);
    Write('Conventional Memory: ',DosMem.MaxAvail Div 1024,' kb,   XMS Heap: ',MaxXMSAvail Div 1024,' kb.  ');
    GetXMS(Handle[C],4000);             {Request an XMS block}
    AwakePointer(Handle[C],P,XMSWriteMode);      {Awaken it}
    Move(ScreenPtr^,P^,4000);                    {Write to it}
    SleepPointer(Handle[C]);                     {Let it sleep again}
  End;

  For C:=254 Downto 33 do       {Display all 222 screens again}
  Begin
    AwakePointer(Handle[C],P,XMSReadMode);      {Awaken Block}
    Move(P^,ScreenPtr^,4000);                   {Copy back to Screen}
    SleepPointer(Handle[C]);                    {Let it Sleep}
    FreeXMS(Handle[C]);                         {Free it from the XMS Heap}
  End;

  ClrScr;
  WriteLn('XMS Heap Free: ',XMSAvail,' kb,   Largest Block: ',MaxXMSAvail,' kb.');
End.
