{

                                                      ͻ
                                                          Stack Unit    
                                                        (Simple Array)  
                                                          Rev. 1.01     
                                                      ͼ

}

{$F-} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Unit Stack;

Interface

Const
  MaxData      = 100;

Type

  Data         = LongInt;
  StackArray   = Array [1..MaxData] of Data;

  DataStack = Object

                Procedure Init;
                Function  Empty        :Boolean;
                Function  Full         :Boolean;
                Procedure Push(    Item:Data);
                Procedure Pop (Var Item:Data);
                Procedure Top (Var Item:Data);
                Procedure Drop;
                Procedure Destroy;

              Private

                StackData:StackArray;
                StackPtr :Word;

              {$IFDEF NOTFINAL}

                Procedure Error(Num:Byte);

              {$ENDIF}

              End;

Implementation

{Include Error Checking if Debug Information is Required}

{$IFDEF NOTFINAL}

Procedure DataStack.Error(Num:Byte);
Begin

  WriteLn;
  Write('Runtime Error Stack-',Num,'  ');

  Case Num Of
    1:Write('Stack Overflow');
    2:Write('Stack Underflow');
  End;

  WriteLn('.');

  Halt;
End;

{$ENDIF}

Procedure DataStack.Init;
Begin
  StackPtr:=0;
End;

Function DataStack.Empty:Boolean;
Begin
  If StackPtr=0 Then
    Empty:=True
  Else
    Empty:=False;
End;

Function DataStack.Full:Boolean;
Begin
  If StackPtr=MaxData Then
    Full:=True
  Else
    Full:=False;
End;

Procedure DataStack.Push(Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Full Then Error(1);

  {$ENDIF}

  Inc(StackPtr);
  StackData[StackPtr]:=Item;
End;

Procedure DataStack.Pop(Var Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Item:=StackData[StackPtr];             {Could Top and Drop, but
                                          this is much faster}
  Dec(StackPtr);
End;

Procedure DataStack.Top(Var Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Item:=StackData[StackPtr];
End;

Procedure DataStack.Drop;
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Dec(StackPtr);
End;

Procedure DataStack.Destroy;
Begin
  StackPtr:=0;          {Clears the stack.  Happens to be the same as Init in}
End;                    {this particular implementation.}

End.

{
ͻ
                   Pure Power Software                        
Ķ
                                                              
       This  software  is copyright by Michael Gallias.       
                                                              
ͼ
}
