{$f+}
(*
Program  : tphex.pas
Function : unit for displaying all kinds of numeric types in hexadecimal
Author   : P.Peters (pp@win.tue.nl)
Date     : Somewhere 1990-ish
*)

Unit TPHex;

Interface

Function HexL( x : LongInt; l : Byte ) : String;

Function HexByte( b : Byte ) : String;

Function HexWord( w : Word ) : String;

Function HexInteger( i : Integer ) : String;

Function HexLongInt( l : LongInt ) : String;

Function HexPointer( p : Pointer ) : String;

Implementation

Const
  HexTable : Array[0..15] Of Char = '0123456789ABCDEF';

{
Function HexL( x : LongInt; l : Byte ) : String;
Var s : String;
Begin
  s := '';
  For l := l DownTo 1 Do
    s := s + HexTable[(x shr ((l-1)*4)) And $0f];
  HexL := s;
End;
}

Function HexL( x : LongInt; l : Byte ) : String;
Begin
  HexL[0] := Char(l);
  For l := l DownTo 1 Do Begin
    HexL[l] := HexTable[x And $0f];
    x := x shr 4;
  End;
End;

Function HexByte( b : Byte ) : String;
Begin
  HexByte := HexL( b, 2);
End;

Function HexWord( w : Word ) : String;
Begin
  HexWord := HexL( w, 4 );
End;

Function HexInteger( i : Integer ) : String;
Begin
  HexInteger := HexL( i, 4 );
End;

Function HexLongInt( l : LongInt ) : String;
Begin
  HexLongInt := HexL( l, 8 );
End;

Function HexPointer( p : Pointer ) : String;
Type
  PtWd    = Record
              Case Boolean Of
                True  : ( Pt  : Pointer );
                False : ( O,S : Word );
            End;
Begin
  HexPointer := HexL( PtWd(p).S, 4 ) + ':' + HexL( PtWd(p).O, 4);
End;

End {TPHex}.
