
(*************************************************

  Procedure: Default help screen.
    This is a dummy procedure used to initialize
    the help screen.

*************************************************)

   {$F+}
    Procedure Default_Help_Screen( Selection: Word );
      Begin
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Window left.
    This procedure moves the window left if the
    variable allows them to be moved.

*************************************************)

    Procedure Window_Left;
      Var
        Okay: Boolean;
      Begin
       {$IFNDEF VER40}
        Okay := ( Move_Windows and Core.Left_Routine );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Window right.
    This procedure moves the window right if the
    variable allows them to be moved.

*************************************************)

    Procedure Window_Right;
      Var
        Okay: Boolean;
      Begin
       {$IFNDEF VER40}
        Okay := ( Move_Windows and Core.Right_Routine );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Window up.
    This procedure moves the window upwards if the
    variable allows them to be moved.

*************************************************)

    Procedure Window_Up;
      Var
        Okay: Boolean;
      Begin
       {$IFNDEF VER40}
        Okay := ( Move_Windows and Core.Up_Routine );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Window down.
    This procedure moves the window downwards if
    the variable allows them to be moved.

*************************************************)

    Procedure Window_Down;
      Var
        Okay: Boolean;
      Begin
       {$IFNDEF VER40}
        Okay := ( Move_Windows and Core.Down_Routine );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: System lock.
    This procedure locks the system if the
    variable allows it.

*************************************************)

    Procedure System_Lock;
      Begin
       {$IFNDEF VER40}
        If Lock_System
          then
            Core.Lock_Routine;
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Truncate string.
    This procedure takes the given string and
    clips it at the given boundaries.  If the
    string extends out of the boundaries, then
    the string is padded with blanks.

*************************************************)

    Procedure Truncate_String( Var Data: String; Start, Width: Byte );
      Var
        String_Width: Integer;
        Out_String: String;
      Begin
        String_Width := Succ( Length( Data ) - Start );
        If ( Width < String_Width )
          then
            Move( Data[ Start ], Out_String[ 1 ], Width )
          else
            If ( Length( Data ) = 1 )
              then
                FillChar( Out_String[ 1 ], Width, Data[ 1 ] )
              else
                Begin
                  FillChar( Out_String[ 1 ], Width, ' ' );
                  If ( String_Width > 0 )
                    then
                      Move( Data[ Start ], Out_String[ 1 ], String_Width );
                End;
        Out_String[ 0 ] := Chr( Pred( Width ) );
        Data := Out_String;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display write.
    This procedure writes out the bar menu with
    the menu choices highlighted.

*************************************************)

    Procedure Display_Write( Var Field: String; First_Color, Normal_Color: Byte );
      Var
        Count: Byte;
      Begin
        For Count := 1 to Length( Field ) do
          Begin
            If ( ( Count > 2 ) and
                 ( Field[ Count ] <> ' ' ) and
                 ( Field[ Pred( Count ) ] = ' ' ) and
                 ( Field[ Pred( Pred( Count ) ) ] = ' ' ) )
              then
                TextAttr := First_Color
              else
                TextAttr := Normal_Color;
           {$IFDEF OS2}
            TextBackground( TextAttr shr 4 );
           {$ENDIF}
            Write( Screen, Field[ Count ] );
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Truncated write.
    This procedure writes the given string at the
    given row on the screen.  It also takes care
    of highlighting the string as it writes it.

*************************************************)

    Procedure Truncate_Write( Field: String; Row, Normal_Color, First_Color: Byte );
      Var
        Width: Byte;
      Begin
        Width := Succ( Right_Of_Window^ - Left_Of_Window^ );
        Truncate_String( Field, 1, Width );
        GotoXY( 1, Row );
        Display_Write( Field, First_Color, Normal_Color );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Find finish.
    This procedure finds the last character in
    the given string from the given start
    position.  Start is expected to point to the
    first character of the menu choice.

*************************************************)

    Procedure Find_Finish( Var Menu: String; Var Start, Finish: Byte );
      Begin
        Finish := Start;
        While ( ( Finish <= Length( Menu ) ) and ( ( Menu[ Finish ] <> ' ' ) or ( Menu[ Succ( Finish ) ] <> ' ' ) ) ) do
          Inc( Finish );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get beginning.
    This procedure increments start as long as it
    points to a blank character in the string.

*************************************************)

    Procedure Get_Beginning( Var Start: Byte; Var Data: String );
      Var
        The_Length: Byte;
      Begin
        The_Length := Length( Data );
        While ( ( Start < The_Length ) and ( Data[ Start ] = ' ' ) ) do
          Inc( Start );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get choice info.
    This procedure examines the menu string and
    takes note of where each selection choice
    begins and ends.

*************************************************)

    Procedure Get_Choice_Info( Var Menu: Bar_Menu_Type );
      Var
        Count,
        Start,
        Finish: Byte;
      Begin
        Count := 1;
       { Find beginning of first choice. }
        Start := 1;
        Get_Beginning( Start, Menu.Data );
        Repeat
         { Find End of Choice. }
          Find_Finish( Menu.Data, Start, Finish );
          With Menu.Choices[ Count ] do
            Begin
              Start_HighLight := Start;
              Finish_HighLight := Finish;
            End;
          Start := Finish;
         { Find beginning of next choice. }
          Get_Beginning( Start, Menu.Data );
          Inc( Count );
        Until ( ( Start >= Length( Menu.Data ) ) or ( Count > Max_Bar_Choices ) );
        Menu.Choice_Amount := Pred( Count );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Norm.
    This procedure is specially designed to merely
    unhighlight the given position on the screen
    window.

*************************************************)

    Procedure Norm( Row, Column, Length, Normal_Color, First_Color: Byte );
      Begin
        Change_Window_Attribute( Row, Column, 1, First_Color );
        Change_Window_Attribute( Row, Succ( Column ), Pred( Length ), Normal_Color );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: HighA.
    This procedure is designed to highlight the
    given portion of the screen window.

*************************************************)

    Procedure HighA( Row, Column, Length, Selector_Color: Byte );
      Begin
       { initialize variables for alternate input. }
        Cursor_Row := Row;
        Cursor_Column_Start := Pred( Column );
        Cursor_Column_Finish := ( Column + Length );
        Change_Window_Attribute( Row, Column, Length, Selector_Color );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Go where.
    This procedure moves the current selection
    bar to the given position.

*************************************************)

    Procedure Go_Where( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color, New_Choice: Byte );
      Begin
        With Menu do
          Begin
            With Choices[ Last_Choice ] do
              Norm( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Normal_Color, First_Color );
            Last_Choice := New_Choice;
            With Choices[ Last_Choice ] do
              HighA( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Selector_Color );
           {$IFNDEF VER40}
            Display_Status( Last_Choice );
           {$ENDIF}
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Go right.
    This procedure moves the current selection
    bar to the next choice to the right.

*************************************************)

    Procedure Go_Right( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte );
      Begin
        If ( Menu.Last_Choice < Menu.Choice_Amount )
          then
            Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, Succ( Menu.Last_Choice ) )
          else
            Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, 1 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Skip right.
    This procedure moves the current selection
    bar to the selected choice to the right.

*************************************************)

    Procedure Skip_Right( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte; Amount: Integer );
      Var
        Value,
        Difference: Integer;
      Begin
        With Menu do
          Begin
            With Choices[ Last_Choice ] do
              Norm( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Normal_Color, First_Color );
            If ( Last_Choice < Choice_Amount )
              then
                Repeat
                  Value := Pred( Choices[ Succ( Last_Choice ) ].Start_HighLight - Choices[ Last_Choice ].Finish_HighLight );
                  If ( Pred( Value ) < Amount )
                    then
                      Begin
                        Inc( Last_Choice );
                        Difference := ( Choices[ Last_Choice ].Finish_HighLight -
                                        Choices[ Pred( Last_Choice ) ].Finish_HighLight );
                        Amount := Amount - Difference;
                      End;
                Until ( Value > Amount ) or ( Last_Choice = Choice_Amount );
            With Choices[ Last_Choice ] do
              HighA( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Selector_Color );
           {$IFNDEF VER40}
            Display_Status( Last_Choice );
           {$ENDIF}
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Go left.
    This procedure moves the current selection
    bar to the next choice to the left.

*************************************************)

    Procedure Go_Left( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte );
      Begin
        If ( Menu.Last_Choice > 1 )
          then
            Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, Pred( Menu.Last_Choice ) )
          else
            Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, Menu.Choice_Amount );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Skip left.
    This procedure moves the current selection
    bar to the selected choice to the left.

*************************************************)

    Procedure Skip_Left( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte; Amount: Integer );
      Var
        Value,
        Difference: Integer;
      Begin
        With Menu do
          Begin
            With Choices[ Last_Choice ] do
              Norm( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Normal_Color, First_Color );
            If ( Last_Choice > 1 )
              then
                Repeat
                  Value := Pred( Choices[ Last_Choice ].Start_HighLight - Choices[ Pred( Last_Choice ) ].Finish_HighLight );
                  If ( Pred( Value ) < Amount )
                    then
                      Begin
                        Dec( Last_Choice );
                        Difference := ( Choices[ Succ( Last_Choice ) ].Finish_HighLight -
                                        Choices[ Last_Choice ].Finish_HighLight );
                        Amount := Amount - Difference;
                      End;
                Until ( Value > Amount ) or ( Last_Choice = 1 );
            With Choices[ Last_Choice ] do
              HighA( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Selector_Color );
           {$IFNDEF VER40}
            Display_Status( Last_Choice );
           {$ENDIF}
          End;

      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Go search.
    This function moves the current selection
    bar to the next choice beginning with the
    given character.  If returns false if it
    fails.

*************************************************)

    Function Go_Search( Character: Char; Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color,
                         First_Color: Byte ): Boolean;
      Var
        Okay: Boolean;
        Count,
        New_Choice: Byte;
      Begin
        Okay := False;
        With Menu do
          For Count := Choice_Amount downto 1 do
            If ( Data[ Choices[ Count ].Start_HighLight ] = Character )
              then
                Begin
                  New_Choice := Count;
                  Okay := True;
                End;
        If Okay
          then
            Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, New_Choice );
        Go_Search := Okay;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Go home.
    This procedure moves the current selection
    bar to the home position. ( position 1 )

*************************************************)

    Procedure Go_Home( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte );
      Begin
        Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, 1 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Go end.
    This procedure moves the current selection
    bar to the end position. ( last choice
    position )

*************************************************)

    Procedure Go_End( Var Menu: Bar_Menu_Type; Row, Normal_Color, Selector_Color, First_Color: Byte );
      Begin
        Go_Where( Menu, Row, Normal_Color, Selector_Color, First_Color, Menu.Choice_Amount );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Extended capabilities.
    This procedure is called to extend the
    capabilities of the menu.

*************************************************)

    Procedure Extended_Capabilities( Command: Byte; Last_Choice: Word );
      Begin
        Case Command of
          Press_F1:
           {$IFNDEF VER40}
            Help_Screen( Last_Choice );
           {$ELSE}
            Default_Help_Screen( Last_Choice );
           {$ENDIF}
          Pressed_Move_Window_Left: { Move window left }
            Window_Left;
          Pressed_Move_Window_Right: { Move window right }
            Window_Right;
          Pressed_Move_Window_Up: { Move window up }
            Window_Up;
          Pressed_Move_Window_Down: { Move window down }
            Window_Down;
          Pressed_Lock: { lock the system }
            System_Lock;
        End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Show bar menu.
    This procedure allows the selection of one of
    the choices from the bar menu.   The selection
    is returned as the count of which choice was
    made.

*************************************************)

    Procedure Show_Bar_Menu( Var Menu: Bar_Menu_Type; Var Selection: Byte; Row, Normal_Color, Selector_Color, First_Color,
                             New_Command: Byte; Character: Char );
      Var
        Okay: Boolean;
      Begin
        With Menu do
          Begin
            TextAttr := Normal_Color;
           {$IFDEF OS2}
            TextBackground( TextAttr shr 4 );
           {$ENDIF}
            Truncate_Write( Data, Row, Normal_Color, First_Color );
            With Menu.Choices[ Last_Choice ] do
              HighA( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Selector_Color );
           {$IFNDEF VER40}
            Display_Status( Menu.Last_Choice );
           {$ENDIF}
            Case New_Command of
              Press_Tab,
              Press_Right_Arrow,
              Press_Word_Right:
                Go_Right( Menu, Row, Normal_Color, Selector_Color, First_Color );
              Press_Shift_Tab,
              Press_Left_Arrow,
              Press_Word_Left:
                Go_Left( Menu, Row, Normal_Color, Selector_Color, First_Color );
              Press_Numbers,
              Press_Capital_Letters,
              Press_Lower_Letters:
                Okay := Go_Search( UpCase( Character ), Menu, Row, Normal_Color, Selector_Color, First_Color );
              else
                Repeat
                  Get_Command( Character, Command );
                  Case Command of
                    Pointer_Right:
                      Skip_Right( Menu, Row, Normal_Color, Selector_Color, First_Color, Adjust_Amount );
                    Pointer_Left:
                      Skip_Left( Menu, Row, Normal_Color, Selector_Color, First_Color, Adjust_Amount );
                    Press_Tab,
                    Press_Right_Arrow,
                    Press_Word_Right:
                      Go_Right( Menu, Row, Normal_Color, Selector_Color, First_Color );
                    Press_Shift_Tab,
                    Press_Left_Arrow,
                    Press_Word_Left:
                      Go_Left( Menu, Row, Normal_Color, Selector_Color, First_Color );
                    Press_Numbers,
                    Press_Capital_Letters,
                    Press_Lower_Letters:
                      Begin
                        Okay := Go_Search( UpCase( Character ), Menu, Row, Normal_Color, Selector_Color, First_Color );
                        If ( Sensitive_Mode and Okay )
                          then
                            Command := Press_Enter;
                      End;
                    Press_Home:
                      Go_Home( Menu, Row, Normal_Color, Selector_Color, First_Color );
                    Press_End:
                      Go_End( Menu, Row, Normal_Color, Selector_Color, First_Color );
                    Pointer_Button1_Double:
                      Command := Press_Enter;
                    else
                      Extended_Capabilities( Command, Last_Choice );
                  End; { Case }
                Until ( Command in [ Press_Down_Arrow, Press_Up_Arrow, Press_Enter, Press_Escape ] );
            End; { Case }
            Selection := Last_Choice;
            If ( Not Leave_Choice_On )
              then
                With Choices[ Last_Choice ] do
                  Norm( Row, Start_HighLight, ( Finish_HighLight - Start_HighLight ), Normal_Color, First_Color );
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get data.
    This function returns the string data that
    is stored in the choice pointer.

*************************************************)

    Function Get_Data( Choice: Pointer ): String;
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Get_Data := Where^.String_Data;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put data.
    This procedure puts the given string data into
    the memory referred to by choice.  It takes
    care to only copy the portion of the string
    that matters.

*************************************************)

    Procedure Put_Data( Choice: Pointer; Data: String );
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Where^.String_Data := Copy( Data, 1, Length( Data ) );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put code.
    This procedure puts the given code into the
    choice memory.

*************************************************)

    Procedure Put_Code( Choice: Pointer; Code: Word );
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Where^.Data.Code := Code;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get code.
    This procedure gets the code from Choice
    pointer memory.

*************************************************)

    Function Get_Code( Choice: Pointer ): Word;
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Get_Code := Where^.Data.Code;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get next.
    This procedure gets the next pointer from
    choice pointer memory.

*************************************************)

    Function Get_Next( Choice: Pointer ): Pointer;
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Get_Next := Where^.Data.Next_Menu_Item;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Find next.
    This procedure finds the next valid pointer
    from choice pointer memory.

*************************************************)

    Function Find_Next( Choice: Pointer ): Pointer;
      Var
        Code: Word;
        Done: Boolean;
        Where: Pointer;
      Begin
        Where := Get_Next( Choice );
        Repeat
          If ( Where = Nil )
            then
              Done := True
            else
              Begin
                Code := Get_Code( Where );
                Done := ( Code <> Line_Code );
                If ( not Done )
                  then
                    Where := Get_Next( Where )
              End
        Until Done;
        Find_Next := Where;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put Next.
    This procedure puts the given next pointer
    into the choice memory.

*************************************************)

    Procedure Put_Next( Var Choice: Pointer; New_Pointer: Pointer );
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Where^.Data.Next_Menu_Item := New_Pointer;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get previous.
    This procedure gets the previous pointer from
    choice pointer memory.

*************************************************)

    Function Get_Previous( Choice: Pointer ): Pointer;
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Get_Previous := Where^.Data.Previous_Menu_Item;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Find previous.
    This procedure finds the next valid pointer
    from choice pointer memory.

*************************************************)

    Function Find_Previous( Choice: Pointer ): Pointer;
      Var
        Code: Word;
        Done: Boolean;
        Where: Pointer;
      Begin
        Where := Get_Previous( Choice );
        Repeat
          If ( Where = Nil )
            then
              Done := True
            else
              Begin
                Code := Get_Code( Where );
                Done := ( Code <> Line_Code );
                If ( not Done )
                  then
                    Where := Get_Previous( Where )
              End
        Until Done;
        Find_Previous := Where;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Put previous.
    This procedure puts the given previous pointer
    into the choice memory.

*************************************************)

    Procedure Put_Previous( Choice, New_Pointer: Pointer );
      Var
        Where: Menu_Item_Node_Pointer_Type absolute Choice;
      Begin
        Where^.Data.Previous_Menu_Item := New_Pointer;
      End;

