(*****************************************************************************

  Program: Indicators demonstration.

  Purpose:
    This program is intended to demonstrate the indicators unit.

  Features:
    Demonstrates the Change attribute routine.
    Demonstrates the side bar graph routine.
    Demonstrates the tall bar graph routine.
    Demonstrates the duel side bar graph routine.
    Demonstrates the duel tall bar graph routine.

  Copyright 1995, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Indicators_Demonstration( Input, Output );

  Uses
    CRT,
   {$IFNDEF OS2}
    Indicators;
   {$ELSE}
    Indicato;
   {$ENDIF}

  Var
    Count,
    Current: Byte;

  Begin
    WriteLn( 'Indicators demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the main features of the Indicators unit.' );
    WriteLn( 'First, it demonstrates the horizontal graphs, then the vertical graphs.' );
    WriteLn( 'Finally, it demonstrates the attribute changing utility.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

    ClrScr;
   { Demonstration of horizontal graph }
    For Count := 0 to 100 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Side_Bar_Graph( 1, 2, 40, Count );
        Delay( 80 );
      End;
    For Count := 100 downto 0 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Side_Bar_Graph( 1, 2, 40, Count );
        Delay( 80 );
      End;

   { Demonstration of duel horizontal graph. }
    ClrScr;
    For Count := 0 to 100 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Duel_Side_Bar_Graph( 1, 2, 40, Count, ( 100 - Count ) );
        Delay( 60 );
      End;

   { Demonstration of vertical graph. }
    ClrScr;
    For Count := 0 to 100 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Tall_Bar_Graph( 2, 25, 5, Count );
        Delay( 60 );
      End;
    For Count := 100 downto 0 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Tall_Bar_Graph( 2, 25, 5, Count );
        Delay( 60 );
      End;

   { Demonstration of duel vertical graph. }
    ClrScr;
    For Count := 0 to 100 do
      Begin
        GotoXY( 1, 1 );
        Write( 'Percent amount ', Count:3, '%' );
        Duel_Tall_Bar_Graph( 2, 25, 5, Count, ( 100 - Count ) );
        Delay( 60 );
      End;

   { Demonstration of change attribute }
    Current := 7;
    Change_Attribute( Current );
    ClrScr;

  End.

